<?php
/**
 * @package xf_integration
 * @version 1.0
 */
/*
Plugin Name: Xenforo Integration
Plugin URI: http://xenscripts.com
Description: Provides a complete Wordpress to Xenforo bridge featuring synced logins, comments, avatars and the ability to create a XenForo thread for each Wordpress post.
Author: Jamie Holmes
Version: 1.0
Author URI: http://xenscripts.com
*/

//load the options
$xf_options = get_option('xf_options');
define('XF_INTEGRATION_PATH', dirname( __FILE__));

//Install script to setup databases
require_once('include/xf_activation.php');
register_activation_hook( __FILE__, 'xf_activation' );

//only load anything if the XenForo path is accurate
if(isset($xf_options['xf_rel_path']) && file_exists(ABSPATH . $xf_options['xf_rel_path'] . '/library/XenForo/Autoloader.php'))
{
	//setup
	require_once('include/xf_integration_object.php');
	global $XF;
	$XF = new XF_Integration($xf_options);
	$XF->initializeXfApplication();

	//other functions we need, only load them if pluggable functions haven't already been defined
	if(!function_exists('get_currentuserinfo'))
	{
		require_once('include/XF_User_Data.php');
		require_once('include/xf_replacement_cookie_functions.php');
		require_once('include/xf_replacement_user_functions.php');
		if($XF->options['xf_sync_avatars'] == 'on')
		{
			require_once('include/xf_replacement_avatar_handler.php');
		}
		if($XF->options['use_thread_creation'] == 'on')
		{
			require_once('include/xf_thread_creation_system.php');
		}
		if($XF->options['use_comment_system'] == 'on')
		{
			require_once('include/xf_replacement_comment_handler.php');
		}
	}
}

//we need to always be able to display the options
if(is_admin())
{
	require_once('include/xf_admin_options.php');
}

//If you have purchased branding removal you may remove the following, otherwise your license requires that it remains.
//You may style it in either event provided that it remains at least the same size and the link remains as it is.
function xf_footer()
{
 echo "<div id='xf_footer' style='text-align: center; margin: 0px; font-size:small;'><a href='http://xenscripts.com'>Bridged by XenScript's XenForo to Wordpress Bridge</a></div>";
}

add_action('wp_footer', 'xf_footer');
?>