<?php
function xf_load_comments($comment, $post_id)
{
	global $XF, $wp_query;
	
	$wp_query->set('comments_per_page', $XF->options['comments_per_page']);
	
	if($XF->useXenForoCommentHandler())
	{
		$XF->post = get_post($post_id);
		
		//are we displaying comments in WP?
		if($XF->options['display_comments_in_wp'] == 'on')
		{
			$parser = $XF->getBbCodeParserFromCache();
			
			$comments = $XF->getCommentsFromCache($post_id);
			$mycomments;
			
			//load timezone related options
			$date_format = get_option('date_format');
			$time_format = get_option('time_format');
			$gmt_offset = (float)get_option('gmt_offset') * 3600;
			
			$i = -1;
			foreach($comments as $mycomment)
			{
				if($i != -1)
				{
					$mycomments[$i] = new StdClass;
					$mycomments[$i]->comment_ID = (string)$mycomment['post_id'];
					$mycomments[$i]->comment_post_ID = (string)$post_id;
					$mycomments[$i]->comment_author = $mycomment['username'];
					$mycomments[$i]->comment_author_email = $mycomment['email'];
					if($mycomment['user_id'] != 0)
					{
						$mycomments[$i]->comment_author_url = $XF->createLink('members/' . strtolower($mycomment['username']) . '.' . $mycomment['user_id'] . '/');
					}
					else
					{
						$mycomments[$i]->comment_author_url = '';
					}
					$mycomments[$i]->comment_date = gmdate($date_format . $time_format, $mycomment['post_date'] + $gmt_offset);
					$mycomments[$i]->comment_date_gmt = gmdate($date_format . $time_format, $mycomment['post_date']);
					$mycomments[$i]->comment_content = '<!-- Start imported content -->' . $parser->render($mycomment['message']) . '<!-- End imported content -->';
					$mycomments[$i]->comment_karma = $mycomment['likes'];
					$mycomments[$i]->comment_approved = '1';
					$mycomments[$i]->comment_type = '';
					$mycomments[$i]->comment_parent = '0';
					$mycomments[$i]->user_id = $mycomment['user_id'];
				}
				$i++;
			}
			
			//we now have our complete comment array, but what about comments that haven't made it to XenForo (old comments, inserted with another plugin, etc)
			$comments_to_merge = array();
			foreach($comment as $this_comment)
			{
				if(!isset($this_comment->XF_post_ID) || $this_comment->XF_post_ID == '0') //this hasn't been stored in XenForo
				{
					$comments_to_merge[] = $this_comment;
				}
			}
			
			//check if we found any comments we need to merge, and if so merge then sort them
			if($comments_to_merge != array())
			{
				if(is_array($mycomments))
				{
					$mycomments = array_merge($mycomments, $comments_to_merge);
				}
				else
				{
					$mycomments = $comments_to_merge;
				}
				
				foreach($mycomments as $mycomment)
				{
					$mycomment->timestamp = strtotime($mycomment->comment_date_gmt);
				}
				usort($mycomments, 'xf_usort_compare_comment_time');
				//die(var_dump($mycomments));
			}
			
			//add it to $wp_query so basic wp functions will use the correct comment array, set up pagination stuff
			$wp_query->comments = $mycomments;
			
			return $mycomments;
		}
		else //We are just displaying a link to the XF thread
		{
			return array();
		}
	}
	else
	{
		return $comment;
	}
}

//our usort callback function (see above)
function xf_usort_compare_comment_time($comment1, $comment2)
{
	$time1 = $comment1->timestamp;
	$time2 = $comment2->timestamp;
	if($time1 == $time2)
	{
		return 0;
	}
	return ($time1 > $time2) ? 1 : -1;
}

function xf_comment_number($n, $post_id)
{
	global $XF;
	
	if($XF->useXenForoCommentHandler())
	{
		return $XF->getCommentNumbersFromCache($post_id);
	}
	else
	{
		return $n;
	}
}

function xf_save_comment($comment)
{
	global $XF;
	
	if($XF->useXenForoCommentHandler($comment))
	{
		$thread_id = $XF->getThreadIdForPost($comment['comment_post_ID']);
		$parser = $XF->getBbCodeParserFromCache();
		
		if($thread_id !== false && $thread_id !== NULL)
		{
			$threadModel = $XF->getModelFromCache('XenForo_Model_Thread');
			$forumModel = $XF->getModelFromCache('XenForo_Model_Forum');
			$thread = $threadModel->getThreadById($thread_id);
			$forum = $forumModel->getForumById($thread['node_id']);
			if($threadModel->canReplyToThread($thread, $forum, $errorKey = ''))
			{
				if (!$XF->visitor->hasPermission('general', 'bypassFloodCheck'))
				{
					$floodTimeRemaining = XenForo_Model_FloodCheck::checkFlooding('post', null);
					if ($floodTimeRemaining)
					{
						wp_die("User flooding. Unable to process comment");
					}
				}
				
				$user_id = $XF->visitor->get('user_id');
				
				$writer = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
				$writer->set('user_id', $user_id);
				$writer->set('username', $XF->visitor->get('username'));
				
				$new_wordpress_comment_content = $parser->render($comment['comment_content']); //convert the BBCode they typed to HTML
				
				if($comment['comment_parent'] != 0) //Handle automatically adding quotes for replies
				{
					$postModel = $XF->getModelFromCache('XenForo_Model_Post');
					$post = $postModel->getPostById($comment['comment_parent']);
					$comment['comment_content'] = '[quote="' . $post['username'] . ', post: ' . $comment['comment_parent'] . '"]' . $post['message'] . '[/quote]
					' . $comment['comment_content'];
				}
				
				$writer->set('message', stripslashes($comment['comment_content']));
				$comment['comment_content'] = $new_wordpress_comment_content;
				$writer->set('message_state', $XF->getModelFromCache('XenForo_Model_Post')->getPostInsertMessageState($thread, $forum));
				$writer->set('thread_id', $thread_id);
				
				if($user_id == 0) //Guest post
				{
					$writer->set('username', $comment['comment_author']);
				}
				
				$writer->setExtraData(XenForo_DataWriter_DiscussionMessage::DATA_ATTACHMENT_HASH, '');
				$writer->preSave();
				
				if(!$writer->hasErrors())
				{
					$writer->save();
					$XF->insertion_id = $writer->get('post_id', 'xf_post');
				}
				else
				{
					$errors = $writer->getErrors();
					if(isset($errors['username']) && $user_id == 0) //Guest post with non-unique username
					{
						$i = 2;
						
						while(true)
						{
							//Try again to see if we can produce a unique username for the guest to use [they hopefully don't care too much about their display name]
							$writer = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
							$writer->set('user_id', $user_id);
							$writer->set('message', stripslashes($comment['comment_content']));
							$writer->set('username', $comment['comment_author'] . $i);
							$writer->set('message_state', $XF->getModelFromCache('XenForo_Model_Post')->getPostInsertMessageState($thread, $forum));
							$writer->set('thread_id', $thread_id);
							$writer->setExtraData(XenForo_DataWriter_DiscussionMessage::DATA_ATTACHMENT_HASH, '');
							$writer->preSave();
							
							if(!$writer->hasErrors())
							{
								$writer->save();
								break;
							}
							else
							{
								$errors = $writer->getErrors();
								if(isset($errors['username']))
								{
									$i++;
									continue;
								}
							}
						}
					}
				}
			}
		}
	}
	
	return $comment;
}

function xf_set_post_id($comment_id)
{
	global $XF, $wpdb;
	
	if(isset($XF->insertion_id))
	{
		$wpdb->query("UPDATE $wpdb->comments SET `XF_post_ID` = $XF->insertion_id WHERE `comment_ID` = $comment_id");
	}
}

function xf_comment_post_redirect($redirect, $post)
{
	global $XF;
	
	if($XF->useXenForoCommentHandler($post))
	{
		global $wp_query;
		
		$thread_id = $XF->getThreadIdForPost($post->comment_post_ID);
		$threadModel = $XF->getModelFromCache('XenForo_Model_Thread');
		$thread = $threadModel->getThreadById($thread_id);
		$num_comments = $thread['reply_count'];
		
		$wp_query->set('comments_per_page', $XF->options['comments_per_page']);
		$pages = ceil($num_comments / $wp_query->get('comments_per_page'));
		
		if(strpos($redirect, '?') !== false)
		{
			$redirect = str_replace('#comment-' . $post->comment_ID, '&cpage=' . $pages . '#comment-' . $XF->insertion_id, $redirect);
		}
		else
		{
			$redirect = str_replace('#comment-' . $post->comment_ID, '?cpage=' . $pages . '#comment-' . $XF->insertion_id, $redirect);
		}
		return $redirect;
	}
	
	return $redirect;
}

function xf_comments_open($open, $post_id)
{
	global $XF;
	
	if($XF->useXenForoCommentHandler())
	{
		//check if we are display comments in WordPress
		if($XF->options['display_comments_in_wp'] == 'on')
		{
			$thread_id = $XF->getThreadIdForPost($comment['comment_post_ID']);
			
			if($thread_id !== false && $thread_id !== NULL)
			{
				$threadModel = $XF->getModelFromCache('XenForo_Model_Thread');
				$forumModel = $XF->getModelFromCache('XenForo_Model_Forum');
				$thread = $threadModel->getThreadById($thread_id);
				$forum = $forumModel->getForumById($thread['node_id']);
				if($threadModel->canReplyToThread($thread, $forum, $errorKey = ''))
				{
					return true;
				}
				elseif($XF->visitor->get('user_id') != 0)
				{
					return false;
				}
			}
			
			return true;
		}
		else //we are only displaying a link to the XF thread
		{
			return false;
		}
	}
	else
	{
		return $open;
	}
}

function xf_check_comment_must_login($value)
{
	global $wp_query, $XF;
	
	if($XF->useXenForoCommentHandler())
	{
		$thread_id = $XF->getThreadIdForPost($wp_query->query_vars['p']);
		
		if($thread_id !== false && $thread_id !== NULL)
		{
			$threadModel = $XF->getModelFromCache('XenForo_Model_Thread');
			$forumModel = $XF->getModelFromCache('XenForo_Model_Forum');
			$thread = $threadModel->getThreadById($thread_id);
			$forum = $forumModel->getForumById($thread['node_id']);
			if($threadModel->canReplyToThread($thread, $forum, $errorKey = ''))
			{
				return false;
			}
			else
			{
				return true;
			}
		}
		return false;
	}
	
	return $value;
}

function xf_page_comments($value)
{
	global $XF;
	
	if($XF->useXenForoCommentHandler())
	{
		return true;
	}
	
	return $value;
}

function xf_default_comments_page($value)
{
	global $XF;
	
	if($XF->useXenForoCommentHandler())
	{
		return 'oldest';
	}
	
	return $value;
}

//function to be used in templates to display a link to the XenForo thread
function xenforo_thread_url()
{
	global $XF;
	
	if($XF->useXenForoCommentHandler() && isset($XF->post->thread_id) && $XF->post->thread_id != '0')
	{
		$link = $XF->createLink('threads/' . $XF->post->thread_id . '/');
		return $link;
	}
	else
	{
		return '';
	}
}



add_filter('comments_array', 'xf_load_comments', 10, 2);
add_filter('get_comments_number', 'xf_comment_number', 10, 2);
add_filter('comments_open', 'xf_comments_open', 10, 2);
add_filter('comment_post_redirect', 'xf_comment_post_redirect', 10, 2);
add_filter('option_comment_registration', 'xf_check_comment_must_login');
add_filter('pre_option_page_comments', 'xf_page_comments');
add_filter('pre_option_default_comments_page', 'xf_default_comments_page');
add_filter('preprocess_comment', 'xf_save_comment');
add_action('comment_post', 'xf_set_post_id');
?>