<?php

function xf_activation()
{
	global $wpdb;
	
	add_option('xf_options');
	
	$result = $wpdb->query("SELECT * FROM $wpdb->posts LIMIT 0,1");
	
	//loop through the fields and see if thread_id is found
	$i = 0;
	$thread_id_exists = false;

	$col_info = $wpdb->col_info;
	$count = count($col_info);
	while($i < $count)
	{
		if($col_info[$i]->name == 'thread_id')
		{
			$thread_id_exists = true;
			break;
		}
		$i++;
	}
	
	if(!$thread_id_exists)
	{
		$wpdb->query("ALTER TABLE $wpdb->posts ADD `thread_id` INT( 10 ) UNSIGNED NOT NULL AFTER `ID` ");
		$wpdb->query("ALTER TABLE $wpdb->comments ADD `XF_post_ID` INT( 10 ) UNSIGNED NOT NULL AFTER `comment_post_ID` ");
	}
		
	if (is_multisite()) {
		$sites = $wpdb->get_results("SELECT blog_id FROM {$wpdb->prefix}blogs");
		
		foreach($sites as $site)
		{
			$blog_id = $site->blog_id;
			if($blog_id != 1)
			{
				xf_add_new_site($blog_id);
			}
		}
	}
	
	return;
}

function xf_add_new_site($blog_id)
{
	global $wpdb;
	
	add_option('xf_options');
	
	$result = $wpdb->query("SELECT * FROM {$wpdb->prefix}{$blog_id}_posts LIMIT 0,1");
	
	//loop through the fields and see if thread_id is found
	$i = 0;
	$thread_id_exists = false;

	$col_info = $wpdb->col_info;
	$count = count($col_info);
	while($i < $count)
	{
		if($col_info[$i]->name == 'thread_id')
		{
			$thread_id_exists = true;
			break;
		}
		$i++;
	}
	
	if(!$thread_id_exists)
	{
		$wpdb->query("ALTER TABLE {$wpdb->prefix}{$blog_id}_posts ADD `thread_id` INT( 10 ) UNSIGNED NOT NULL AFTER `ID` ");
		$wpdb->query("ALTER TABLE {$wpdb->prefix}{$blog_id}_comments ADD `XF_post_id` INT( 10 ) UNSIGNED NOT NULL AFTER `comment_post_ID` ");
	}
	
	return;
}

add_action('wpmu_new_blog', 'xf_add_new_site', 10, 1);
?>