<?php
function set_user_roles(&$classObj, $user_group_id, $secondary_group_ids)
{
	global $XF, $table_prefix;
	$user_groups = explode(',', $secondary_group_ids);
	$user_groups[] = $user_group_id;
	
	//loop through them and fine the WP role equivalent for each
	$user_roles = array();
	foreach($user_groups as $user_group)
	{
		$user_roles[] = $XF->options['xf_user_role'][$user_group];
	}
	
	//names of fields that include $wpdb->prefix
	$capabilities = $table_prefix . 'capabilities';
	$user_level = $table_prefix . 'user_level';
	
	//now find the highest role they have and assign them the correct permissions for it
	if(in_array('administrator', $user_roles))
	{
		$classObj->$capabilities = array ( 'administrator' => 'true');
		$classObj->$user_level = '10';
		$classObj->user_level = '10';
		$classObj->show_admin_bar_front = 'true';
		$classObj->show_admin_bar_admin = 'true';
	}
	elseif(in_array('editor', $user_roles))
	{
		$classObj->$capabilities = array ( 'editor' => 'true');
		$classObj->$user_level = '7';
		$classObj->user_level = '7';
		$classObj->show_admin_bar_front = 'true';
		$classObj->show_admin_bar_admin = 'true';
	}
	elseif(in_array('author', $user_roles))
	{
		$classObj->$capabilities = array ( 'author' => 'true');
		$classObj->$user_level = '2';
		$classObj->user_level = '2';
		$classObj->show_admin_bar_front = 'true';
		$classObj->show_admin_bar_admin = 'true';
	}
	elseif(in_array('contributor', $user_roles))	
	{
		$classObj->$capabilities = array ( 'contributor' => 'true');
		$classObj->$user_level = '1';
		$classObj->user_level = '1';
		$classObj->show_admin_bar_front = 'true';
		$classObj->show_admin_bar_admin = 'true';
	}
	else
	{
		$classObj->$capabilities = array ( 'subscriber' => 'true');
		$classObj->$user_level = '0';
		$classObj->user_level = '0';
		$classObj->show_admin_bar_front = 'false';
		$classObj->show_admin_bar_admin = 'false';
	}
}

class XF_User_Data
{
	public static function fillUserData($visitor, $classObj, $user_id)
	{
		if($user_id != 0)
		{
			global $XF;
			$userModel = $XF->getModelFromCache('XenForo_Model_User');
			$user = $userModel->getUserById($user_id, array('join' => XenForo_Model_User::FETCH_USER_FULL));
				
			$classObj->userObj = $user;
			
			if($user_id == $visitor->get('user_id'))
			{
				//fill in permission based fields
				set_user_roles($classObj, (string)$visitor->get('user_group_id'), $visitor->get('secondary_group_ids'));
				
				//lots of these are set automatically as defaults because of the loss of the WP profile editor. TODO look into ways of still offering the profile editor so users can change these settings
				$classObj->ID = $visitor->get('user_id');
				$classObj->user_login = $visitor->get('username');
				$classObj->user_pass = '';
				$classObj->user_nicename = $visitor->get('username');
				$classObj->user_url = $visitor->get('homepage');
				$register_date = $visitor->get('register_date');
				$register_date = date('Y-m-d H:i:s', $register_date);
				$classObj->user_registered = $register_date;
				$classObj->user_activation_key = '';
				$classObj->user_status = '0';
				$classObj->display_name = $visitor->get('username');
				$classObj->first_name = '';
				$classObj->last_name = '';
				$classObj->nickname = $visitor->get('username');
				$classObj->description = $visitor->get('about');
				$classObj->rich_editing = true;
				$classObj->comment_shortcuts = 'false';
				$classObj->admin_color = 'fresh';
				$classObj->use_ssl = '0';
				$classObj->aim = '';
				$classObj->yim = '';
				$classObj->jabber = '';
				$classObj->wp_dashboard_quick_press_last_post_id = '0';
				$classObj->user_firstname = '';
				$classObj->user_lastname = '';
				$classObj->user_description = $visitor->get('about');
				$classObj->user_email = $visitor->get('email');
				
				return $classObj;
			}
			else
			{	
				//fill in permission based fields
				set_user_roles($classObj, (string)$user['user_group_id'], $user['secondary_group_ids']);
				
				$classObj->ID = $user['user_id'];
				$classObj->user_login = $user['username'];
				$classObj->user_pass = '';
				$classObj->user_nicename = $user['username'];
				$classObj->user_url = $user['homepage'];
				$register_date = $user['register_date'];
				$register_date = date('Y-m-d H:i:s', $register_date);
				$classObj->user_registered = $register_date;
				$classObj->user_activation_key = '';
				$classObj->user_status = '0';
				$classObj->display_name = $user['username'];
				$classObj->first_name = '';
				$classObj->last_name = '';
				$classObj->nickname = $user['username'];
				$classObj->description = $user['about'];
				$classObj->rich_editing = true;
				$classObj->comment_shortcuts = 'false';
				$classObj->admin_color = 'fresh';
				$classObj->use_ssl = '0';
				$classObj->aim = '';
				$classObj->yim = '';
				$classObj->jabber = '';
				$classObj->wp_dashboard_quick_press_last_post_id = '0';
				$classObj->user_firstname = '';
				$classObj->user_lastname = '';
				$classObj->user_description = $user['about'];
				$classObj->user_email = $user['email'];
				
				return $classObj;
				
			}
		}
	}
}
?>