<?php
/**
 * supportFunctions.php
 * @package plugins_shared
 * @version version 1.3.0
 */

	/**
	 * Sanitize numeric values
	 * @param string $currentValue
	 * @param int $minValue  Minimum value 
	 * @param int $maxValue	 Maximum value
	 * @param int $replacementValue DefaultValue if the value not between the min and max 
	 */
	function eipFilterNumeric($currentValue,$minValue,$maxValue,$replacementValue)
	{
		$newVaule = (is_numeric($currentValue)) ? intval($currentValue) : $replacementValue;
		$newVaule = (($newVaule < $minValue) || ($newVaule > $maxValue)) ? $replacementValue : $newVaule;
		return($newVaule); 
	}
//------------------------------------------------------------------------------------
// replace some of the built in WP fx's
//------------------------------------------------------------------------------------	
	/**
	 * replaces WP fx settings_fields($option_group) 
	 * Output nonce, action, and option_page fields for a settings page.
	 * @param string $option_group A settings group name.  This should match the group name used in register_setting().
	 */
	function api_settings_fields($option_group) 
	{
		$html_string = '<input type="hidden" name="option_page" value="' . esc_attr($option_group) . '" />
						<input type="hidden" name="action" value="update" />'.
						wp_nonce_field("$option_group-options","_wpnonce",TRUE,FALSE);
		return($html_string);
	}
	/**
	 * replaces the WP fx do_settings_sections($page)
	 * Prints out all settings sections added to a particular settings page
	 * @param string $page The slug name of the page whos settings sections you want to output
	 */
	function api_do_settings_sections($page) 
	{
		global $wp_settings_sections, $wp_settings_fields;
		$html_string = "";
		if ( !isset($wp_settings_sections) || !isset($wp_settings_sections[$page]) )
		{
			return;
		}

		foreach ( (array) $wp_settings_sections[$page] as $section ) 
		{
		if ( $section['title'] )
			$html_string .= "<h3>{$section['title']}</h3>\n";
		$html_string .=	call_user_func($section['callback'], $section);
		if ( !isset($wp_settings_fields) || !isset($wp_settings_fields[$page]) || !isset($wp_settings_fields[$page][$section['id']]) )
		{
			continue;
		}
		$html_string .= '<table class="form-table">';
		$html_string .= api_do_settings_fields($page, $section['id']);
		$html_string .= '</table>';
		}
		return ($html_string);
	}
	/**
	 * Replace the WP fx do_settings_fields
	 * Print out the settings fields for a particular settings section
	 * @param string $page Slug title of the admin page who's settings fields you want to show.
	 * @param section $section Slug title of the settings section who's fields you want to show.
	 */
	function api_do_settings_fields($page, $section) 
	{
		global $wp_settings_fields;
		$html_string = "";
		if (!isset($wp_settings_fields) || !isset($wp_settings_fields[$page]) || !isset($wp_settings_fields[$page][$section]) )
		{
			return;
		}

		foreach ( (array) $wp_settings_fields[$page][$section] as $field ) 
		{
			$html_string .= '<tr valign="top">';
			if ( !empty($field['args']['label_for']))
			{
				$html_string .= '<th scope="row"><label for="' . $field['args']['label_for'] . '">' . $field['title'] . '</label></th>';
			}
			else
			{
				$html_string .= '<th scope="row">' . $field['title'] . '</th>';
			}
			$html_string .=  '
					<td>'.
						call_user_func($field['callback'], $field['args']) .'
					</td>
				</tr>';
		}
		return ($html_string);
	}
?>