<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_ErrorHandler.php  handle any error processing.
 * @package plugins_shared
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//----------------------------------------------------------------------------------------------------------------------------
//GLOBALS
//----------------------------------------------------------------------------------------------------------------------------
$_SESSION['debug_mode']=FALSE;                          //Turn DEBUG mode on and off
//----------------------------------------------------------------------------------------------------------------------------
/**
 * Extends php's exception handler
 * @uses $_SESSION['debug_mode']
 * @return string --> $_SESSION['error_message']
 */
class ExceptionHandler extends Exception
{
    public function __construct($message, $code=0)
    {
        parent::__construct($message,$code);
    }
    
    /**
     * parse the error message that was generated.  Re-direct the user to the custom errorhandler webpage.
     * try and get the http_referer so the user can re-direct themselves
     * default out to standard exception class
     */
    public function ParseError($str_DebugMessage=NULL)
    {
        try
        {
            $_SESSION['error_message'] = "At " . date("m/d/Y H.i.s")  ." an unexpected error was generated. <br/>";
            
            if($_SESSION['debug_mode']==TRUE)       //write to the global session variable, details about the error that was generated
            {
                $_SESSION['error_message'].= "File: ". $this->getFile() . " :: Line: ".$this->getLine()."<br/>Err: ".$this->getMessage() ."<br/>";
                $_SESSION['error_message'].= (!$str_DebugMessage==NULL) ? "Additional info: " .$str_DebugMessage."<br/>" :"<br/>";
				$_SESSION['error_message'].= isset($_SESSION['debug_info']) ? "Debug Info: ".$_SESSION['debug_info']."<br/>" :"<br/>";
            }
            $html_reflink = isset($_SERVER['HTTP_REFERER']) ? htmlspecialchars($_SERVER['HTTP_REFERER']) : "";
            $html_reflink = (strlen($html_reflink > 1)) ? "<a href='" .$html_reflink."'>Return to the prior page</a>" : "Please use the back button to return to the prior page."; 
            $_SESSION['error_message'].= "<br/><br/>" . $html_reflink;
            
            echo($_SESSION['error_message']);										//spit back the error message
            //header('Location: http://www.yourdomain.com/errorhandler.php');		//need to make custom error handler 
			exit();				//stop processing
        }
        catch(Exception $e)
        {
            return("<br/>Error -999FFF1<br/>A critical error has occured at " . date("m/d/Y H.i.s")."<br/>");
			exit();
        }  
    }
}
?>