<?php
/** 
 * Get Forum Last Posts Admin
 * @package plugins_lastposts
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
*/
//----------------------------------------------------------------------------------------------------------------------------
//GLOBALS
//----------------------------------------------------------------------------------------------------------------------------
if(is_admin())
{
	add_action('admin_init', 'eipRegisterSettings');
	add_action("admin_menu", "eipLastPostsAdminMenu");
}
//----------------------------------------------------------------------------------------------------------------------------
	/**
	 * settings page and variables to be defined
	 */
	function eipRegisterSettings()
	{
		$setting 	= Array("forumDBConn","forumDomain","forumDirectory","forumPosts","forumUserPosts","forumLookBack","forumWidget","forumNodeList","forumUserGroup","forumTitle","forumThreadLen");
		$default 	= Array("SQL","/forums/","/var/www/forums/library/config.php",6,5,30,"sidebar",0,0,"Table Title",30);
		$callback 	= "eipOptionTextBox";
		$calldrop 	= "eipDropDownBox";
		$page 		= "eipLP";
		$section	= "eipSettingsSection";
		
		add_settings_section("eipSettingsSection", "Xenforo Last Posts", "eipLastPostsInfo", "eipLP");
		//Xenforo settings
		add_settings_field("eipLPConnection",	"Database Connection", 	$callback,$page,$section, array('setting'=>$setting[0],'defaultval'=>$default[0]));
		add_settings_field("eipLPDomain",		"Forum Domain", 		$callback,$page,$section, array('setting'=>$setting[1],'defaultval'=>$default[1]));
		add_settings_field("eipLPDirectory",	"Forum Directory", 		$callback,$page,$section, array('setting'=>$setting[2],'defaultval'=>$default[2]));
		add_settings_field("eipLPPosts",		"Forum Posts", 			$callback,$page,$section, array('setting'=>$setting[3],'defaultval'=>$default[3]));
		
		//qry settings
		add_settings_field("eipLPUserPosts",	"Required User Posts",		$callback,$page,$section, array('setting'=>$setting[4],'defaultval'=>$default[4]));
		add_settings_field("eipLPMaxDays",		"Maximum Days to Look Back",$callback,$page,$section, array('setting'=>$setting[5],'defaultval'=>$default[5]));

		//visual options
		add_settings_field("eipLPWidgetType",	"Widget Type",				$calldrop,$page,$section, array('setting'=>$setting[6],'defaultval'=>$default[6]));
		add_settings_field("eipLPExcludeNodes",	"Nodes to Exclude",			$callback,$page,$section, array('setting'=>$setting[7],'defaultval'=>$default[7]));
		add_settings_field("eipLPExcludeUsers",	"User Groups to Exclude",	$callback,$page,$section, array('setting'=>$setting[8],'defaultval'=>$default[8]));
		add_settings_field("eipLPTitle",		"Table Title", 				$callback,$page,$section, array('setting'=>$setting[9],'defaultval'=>$default[9]));
		add_settings_field("eipLPThreadLen",	"Thread Title Length",		$callback,$page,$section, array('setting'=>$setting[10],'defaultval'=>$default[10]));
		register_setting("eipLastPostOptionGroup", "eipForumOptions","eipScrubInput");
	}
	/**
	 * Define the paramets for the options page in the admin menu
	 */
	function eipLastPostsAdminMenu()
	{
		add_options_page("eip Last Posts", "Last Posts", "administrator", "eipLP", "eipBuildSettings");	
	}
	/**
	 * Header Description
	 */
	function eipLastPostsInfo()
	{	
		return("<table width='950px'>
			<tr>
				<th width='200px'>Option</td>
				<th width='500px'>Description</td>
				<th width='250px'>Sample Value</td>
			</tr>
			<tr>
				<td><b>Database Connection:</b></td>
				<td>Value can be <b>SQL</b> or <b>PDO</b></td>
				<td>If unsure enter in <b>SQL</b></li></td>
			</tr>
			<tr>
				<td><b>Forum Domain:</b></td>
				<td>Enter the value <b>AFTER</b> your internet domain</td>
				<td>/forums/</td>
			</tr>
			<tr>
				<td><b>Forum Directory:</b></td>
				<td>The complete file path to your Xenforo config.php file</td>
				<td>/var/www/forums/library/config.php</td>
			</tr>
			<tr>
				<td><b>Forum Posts</b></td>
				<td>How many posts to retrieve from the forum, maximum of 99.</td>
				<td>6</td>
			</tr>
			<tr>
				<td><b>Required User Posts: </b></td>
				<td>How many posts must a user have before showing up in the table.</td>
				<td>5</td>
			</tr>
			<tr>
				<td><b>Maximum Days to Look Back: </b></td>
				<td>Maximum days to look back for old posts, show posts newer than X days ago.</td>
				<td>30</td>
			</tr>
			<tr>
				<td><b>Widget Type: </b></td>
				<td>Sidebar Table, Sidebar List, or Footer widget</td>
				<td>Sidebar Table</td>
			</tr>
			<tr>
				<td><b>Nodes to Exclude: </b></td>
				<td>A comma separated list for nodes you don't want to show posts. If you want to include all nodes enter 0.</td>
				<td>12,17,18</td>
			</tr>
			<tr>
				<td><b>User Groups to Exclude: </b></td>
				<td>A comman separated list for user groups to exclude, i.e. banned users. If you want to include all user groups enter 0. </td>
				<td>1,4</td>
			</tr>
			<tr>
				<td><b>Table Title: </b></td>
				<td>Title to put above the table</td>
				<td></td>
			</tr>
			<tr>
				<td><b>Thread Title Length:</b></td>
				<td>Maximum character length of a thread title.</td>
				<td>30</td>
			</tr>
			</table>
		");
	} 
	/**
	 * Build up the form to enter in the settings
	 */
	function eipBuildSettings()
	{
		$html_string	=	'
			<div class = "wrap">
				<h3>Get Last Forum Posts Options</h3>
				<form method="post" action="options.php">'.
					api_settings_fields("eipLastPostOptionGroup").
					api_do_settings_sections("eipLP").
					'
					<input class="button-primary" name="Submit" type="submit" value="Save Changes" />
				</form>
			</div>
		';
		echo($html_string);
	}
	/**
	 * Create the input boxes on the admin settings page
	 * @param string $setting which setting to retrieve from the database
	 * @return string containing html for input box
	 */
	function eipOptionTextBox($arg)
	{
		$currentOptions = get_option("eipForumOptions");
		$optVal = (is_array($currentOptions) && array_key_exists($arg['setting'], $currentOptions)) ? $currentOptions[$arg['setting']] : $arg['defaultval'];
		$html_string = '
			<input id="eip'.$arg['setting'].'" name="eipForumOptions['. $arg['setting'] .']" size="40" type="text" value="'.$optVal. '" />';
		return($html_string);
	}
	/**
	 * Create a drop down box for the input
	 * 
	 */
	function eipDropDownBox($arg)
	{
		$currentOptions = get_option("eipForumOptions");
		$optVal = (is_array($currentOptions) && array_key_exists($arg['setting'], $currentOptions)) ? $currentOptions[$arg['setting']] : $arg['defaultval'];
		$widget_dd = array("footer","sidebar_table","sidebar_list");
		
		$html_string = '<select id="sel_widget" name="eipForumOptions['. $arg['setting'] .']" >';
		foreach ($widget_dd as $fe_DD)
		{
			$sel = ($fe_DD == $optVal) ? ' selected="selected"': "";
			$html_string .= '<option value="' . $fe_DD .'"' . $sel .">".ucwords(strtolower(str_replace("_", " ", $fe_DD)))."</option>"  ;
		}
		$html_string .= "</select>";
		return($html_string);
	}
?>