<?php
class XF_Integration
{
	public $visitor;
	
	//cache of models
	protected $models;
	
	//cache of comments
	protected $comments;
	
	//cache of comment numbers
	protected $commentnumbes;
	
	//our options array
	public $options;
	
	//the options array generated by XenForo
	public $xfoptions;
	
	protected $bbparser;
	
	public function __construct($xf_options)
	{
		global $wp_query;
		
		$this->models = array();
		$this->comments = array();
		$this->commentnumbers = array();
		$this->options = $xf_options;
		
	}
	
	public function initializeXfApplication()
	{
		//this is required to make the flash media uploader work; accept cookies through HTTP POST
		if(isset($_REQUEST['auth_cookie']))
		{
			$_COOKIE['xf_session'] = $_REQUEST['auth_cookie'];
		}
		

		$startTime = microtime(true);
		$this->fileDir = ABSPATH . $this->options['xf_rel_path'];
		
		if(!class_exists("XenForo_Autoloader")) {
			require($this->fileDir . '/library/XenForo/Autoloader.php');
			XenForo_Autoloader::getInstance()->setupAutoloader($this->fileDir . '/library');
			
			XenForo_Application::initialize($this->fileDir . '/library', $this->fileDir);
			XenForo_Application::set('page_start_time', $startTime);
			
			XenForo_Application::disablePhpErrorHandler();
			error_reporting( E_ALL ^ E_NOTICE ^ E_USER_NOTICE );
		}
		
		//load options
		$this->xfoptions = XenForo_Application::get('options');
		
		$this->urlDir = $this->xfoptions->boardUrl;
		

		//These are needed to make sure that XenForo addons run as required, and to load XF options
		$dependencies = new XenForo_Dependencies_Public();
		$dependencies->preLoadData();

		XenForo_Session::startPublicSession(); 
		$this->visitor = XenForo_Visitor::getInstance();
		
	}
	
	public function getModelFromCache($model)
	{
		if(isset($this->models[$model]))
		{
			return $this->models[$model];
		}
		else
		{
			$this->models[$model] = XenForo_Model::create($model);
			return $this->models[$model];
		}
	}
	
	public function createLink($link)
	{
		if($this->xfoptions->useFriendlyUrls == '1')
		{
			return $this->urlDir. '/' . $link;
		}
		else
		{
			return $this->urlDir . '/index.php?' . $link;
		}
	}
	
	//Check if we should use Xenforo to handle the comment system, or leave it to the WP default
	public function useXenForoCommentHandler($comment_array = '')
	{
		global $wp_query;
	
		if($comment_array != '') //saving a comment
		{
			if(is_array($comment_array))
			{
				$post_id = $comment_array['comment_post_ID'];
			}
			else //Object of StdClass
			{
				$post_id = $comment_array->comment_post_ID;
			}
			
			if($this->getThreadIdForPost($post_id) != false)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		elseif(isset($wp_query->post->ID)) //We are on post view
		{
			if($wp_query->post->thread_id != '0')
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		
		return false;
	}
	
	public function getCommentsFromCache($post_id)
	{
		if(isset($this->comments[$post_id]))
		{
			return $this->comments[$post_id];
		}
		else
		{
			global $wp_query;
			
			$postModel = $this->getModelFromCache('XenForo_Model_Post');
			$post = get_post($post_id);
			
			$postFetchOptions = array(
			'deleted' => false,
			'moderated' => false,
			'join' => XenForo_Model_Post::FETCH_USER,
			'likeUserId' => $this->visitor->get('user_id')
			);
			
			$this->comments[$post_id] = $postModel->getPostsInThread($post->thread_id, $postFetchOptions);
			return $this->comments[$post_id];
		}
	}
	
	public function getCommentNumbersFromCache($post_id)
	{
		if(isset($this->commentnumbers[$post_id]))
		{
			return $this->commentnumbers[$post_id];
		}
		else
		{
			global $wp_query;
			$post_arr = $wp_query->posts;
			if(count($post_arr) == 1)
			{
				$the_comments = $this->getCommentsFromCache($post_id);
				$this->commentnumbers[$post_id] = count($the_comments) - 1;
			}
			else
			{
				$thread_ids = array();
				
				foreach($post_arr as $the_post)
				{
					if($the_post->thread_id == '0') //We don't have a thread for this post
					{
						$this->commentnumbers[$the_post->ID] = 0;
					}
					else
					{
						$thread_ids[] = (int) $the_post->thread_id;
					}
				}
				
				$threadModel = $this->getModelFromCache('XenForo_Model_Thread');
				$threads = $threadModel->getThreadsByIds($thread_ids);
				
				foreach($post_arr as $the_post)
				{
					if($the_post->thread_id != '0') //we did send a request for a thread
					{
						$this->commentnumbers[$the_post->ID] = $threads[(int) $the_post->thread_id]['reply_count'];
					}
				}
			}
			return $this->commentnumbers[$post_id];
		}
	}
	
	public function getBbCodeParserFromCache()
	{
		if(empty($this->bbparser))
		{
			$this->bbparser = new XenForo_BbCode_Parser(new XenForo_BbCode_Formatter_Base());
		}
		
		return $this->bbparser;
	}
	
	public function getThreadIdForPost($post_id)
	{
		$post = get_post($post_id, ARRAY_A);
		if($post['thread_id'] != '0')
		{
			return $post['thread_id'];
		}
		else
		{
			return false;
		}
	}
}
?>