<?php
function xf_options_menu()
{
	add_options_page('XenForo Bridge Options', 'XenForo Bridge', 'manage_options', 'xf-options', 'xf_generate_options');
}

function xf_generate_options()
{
	if (!current_user_can('manage_options'))
    {
      wp_die( __('You do not have sufficient permissions to access this page.') );
    }
	
	//Update the options with their new values
	if(isset($_POST['xf_submitted']) && $_POST['xf_submitted'] == 'true')
	{
		check_admin_referer('xf_integration_options');
		$xf_new_options = array();
		$xf_new_options['xf_user_role'] = array();
		$xf_new_options['xf_category_forum_id'] = array();
		
		//a variable to check whether at least one administrator role exists (we haven't locked ourselves out of the ACP)
		$admin_exists = false;
		
		foreach($_POST as $key => $value)
		{
			if($key == 'xf_rel_path' || $key == 'xf_sync_avatars' || $key == 'use_thread_creation' || $key == 'use_thread_creation_page' || $key == 'first_post_contains' || $key == 'use_comment_system' || $key == 'display_comments_in_wp')
			{
				$xf_new_options[$key] = $value;
			}
			elseif($key == 'comments_per_page' || $key == 'xf_forum_id_page')
			{
				$xf_new_options[$key] = (int)$value;
			}
			elseif($key != 'xf_user_role_set' && strpos($key, 'xf_user_role_') !== false)
			{
				$id = str_replace('xf_user_role_', '', $key);
				$id = (int)$id;
				$xf_new_options['xf_user_role'][$id] = $value;
				
				if($value == 'administrator')
				{
					$admin_exists = true;
				}
			}
			elseif(strpos($key, 'xf_category_forum_id_') !== false)
			{
				$slug = str_replace('xf_category_forum_id_', '', $key);
				$xf_new_options['xf_category_forum_id'][$slug] = (int)$value;
			}
		}
		
		if(!isset($_POST['xf_sync_avatars']))
		{
			$xf_new_options['xf_sync_avatars'] = 'off';
		}
		
		if(!isset($_POST['use_thread_creation']))
		{
			$xf_new_options['use_thread_creation'] = 'off';
		}
		
		if(!isset($_POST['use_thread_creation_page']))
		{
			$xf_new_options['use_thread_creation_page'] = 'off';
		}
		
		if(!isset($_POST['use_comment_system']))
		{
			$xf_new_options['use_comment_system'] = 'off';
		}
		
		if(!isset($_POST['display_comments_in_wp']))
		{
			$xf_new_options['display_comments_in_wp'] = 'off';
		}
		
		if($admin_exists)
		{
			update_option('xf_options', $xf_new_options);
			
			?>
			<div class="updated"><p><strong><?php _e('settings saved.', 'menu-test' ); ?></strong></p></div>
			<?php
		}
		elseif(!isset($_POST['xf_user_role_set'])) //No admin role has been selected because the option was not available, save the default instead
		{
			$xf_new_options['xf_user_role'] = array('3' => 'administrator');
			update_option('xf_options', $xf_new_options);
			?>
			<div class="updated"><p><strong><?php _e('settings saved.', 'menu-test' ); ?></strong></p></div>
			<?php
		}
		else //we offered the choice to select usergroup roles and still no admin group was selected, refuse to save
		{
			?>
			<div class="updated"><p><strong>Unable to save settings because no usergroup has been given an administrator role. Administrator role is required to prevent loss of access to admin page.</strong></p></div>
			<?php
		}
	}
	
	if(isset($xf_new_options))
	{
		$xf_options = $xf_new_options;
	}
	else
	{
		$xf_options = get_option('xf_options');
	}
	
	//if the options array is empty (new install) fill it with some defaults
	if($xf_options == '')
	{
		$xf_options = array(	'xf_rel_path' => '',
							'xf_user_role' => array(	'3' => 'administrator',
													),
							'xf_sync_avatars' => 'on',
							'use_thread_creation' => 'on',
							'use_thread_creation_page' => 'on',
							'xf_forum_id_page' => '1',
							'first_post_contains' => 'full',
							'xf_category_forum_id' => array( 	'default' => '1',
															),
							'use_comment_system' => 'on',
							'display_comments_in_wp' => 'on',
							'comments_per_page' => 100
							);
	}
	
	?>
	<div class="wrap">
		<h2>XenForo & Wordpress Bridge Options</h2>
		<form name="xf_option_form" method="post" action="">
		<?php wp_nonce_field('xf_integration_options') ?>
		<input type="hidden" name="xf_submitted" value="true" />
			<table class="form-table">
				<tr valign="top">
				<label for="xf_rel_path">
				<th scope="row">Relative path to XenForo</th>
				<td><fieldset><legend class="screen-reader-text"><span>Relative path to XenForo</span></legend>
				<input name="xf_rel_path" type="text" id="xf_rel_path" class="regular-text" value="<?php echo $xf_options['xf_rel_path']; ?>"  />
				<strong>No trailing slash</strong> <small><em>e.g. if Wordpress is in /wordpress and XenForo is in /xenforo you would enter '../xenforo' here</em></small></label>
				<br />
				</fieldset></td>
				</tr>
				
				<tr valign="top">
				<th scope="row">User Permission System</th>
				<td><fieldset><legend class="screen-reader-text"><span>User Permission System</span></legend>
				Here you can map XenForo usergroups to Wordpress roles. If a user belongs to multiple usergroups Wordpress will take the highest of them. <br />
				<small><em>Please ensure that at least one usergroup always has the Administrator role.</em></small><br />
				<?php
				global $XF;
				
				if(is_object($XF)) //This option set requires XenForo to render, so check it is already loaded before displaying it
				{
					?>
					<input type="hidden" name="xf_user_role_set" value="true" />
					<?php
					$UGModel = $XF->getModelFromCache('XenForo_Model_UserGroup');
					$usergroups = $UGModel->getAllUserGroups();
					foreach($usergroups as $usergroup)
					{
						$id = $usergroup['user_group_id'];
						$title = $usergroup['title'];
						echo '<label for="xf_user_role_' . $id . '">';
						echo $title . ' has role ';
						echo '<select name="xf_user_role_' . $id . '" id="xf_user_role_' . $id . '">';
						?>
							<option value='subscriber' <?php echo ($xf_options['xf_user_role'][$id] == 'subscriber') ? "selected='yes'" : ''; ?>>Subscriber</option>
							<option value='contributor' <?php echo ($xf_options['xf_user_role'][$id] == 'contributor') ? "selected='yes'" : ''; ?>>Contributor</option>
							<option value='author' <?php echo ($xf_options['xf_user_role'][$id] == 'author') ? "selected='yes'" : ''; ?>>Author</option>
							<option value='editor' <?php echo ($xf_options['xf_user_role'][$id] == 'editor') ? "selected='yes'" : ''; ?>>Editor</option>
							<option value='administrator' <?php echo ($xf_options['xf_user_role'][$id] == 'administrator') ? "selected='yes'" : ''; ?>>Administrator</option>
						</select>
						</label>
						<br />
						<?php
					}
				}
				elseif(file_exists(ABSPATH . $xf_options['xf_rel_path'] . '/library/XenForo/Autoloader.php'))
				{
					echo "<strong><large>The relative path you entered is correct. Please reload this page to see usergroup mapping options.</large></strong>";
				}
				else
				{
					echo "<strong><large>Please enter the correct relative path to XenForo above then save the page to see this option set.</large></strong>";
				}
				?>
				<br />
				<label for="xf_sync_avatars">
				<input name="xf_sync_avatars" type="checkbox" id="xf_sync_avatars" <?php echo ($xf_options['xf_sync_avatars'] == 'on') ? 'checked="checked"':''; ?>  />
				Also sync XenForo Avatars to display in Wordpress</label>
				</fieldset></td>
				</tr>
				
				<tr valign="top">
				<th scope="row">Thread Creation System</th>
				<td><fieldset><legend class="screen-reader-text"><span>Thread Creation System</span></legend>
				<label for="use_thread_creation">
				<input name="use_thread_creation" type="checkbox" id="use_thread_creation" <?php echo ($xf_options['use_thread_creation'] == 'on') ? 'checked="checked"':''; ?>  />
				Automatically create threads in XenForo for each new Wordpress post</label>
				<br />
				<label for="use_thread_creation_page">
				<input name="use_thread_creation_page" type="checkbox" id="use_thread_creation_page" <?php echo ($xf_options['use_thread_creation_page'] == 'on') ? 'checked="checked"':''; ?>  />
				Also create threads for new Wordpress Pages</label><label for="xf_forum_id_page"> [in Forum ID <input type="text" name="xf_forum_id_page" id="xf_forum_id_page" value="<?php echo $xf_options['xf_forum_id_page']; ?>" />]</label>
				<br />
				<label for="first_post_contains">
				The first post of created threads should contain</label>
				<select name='first_post_contains' id='first_post_contains'>
					<option value='full' <?php echo ($xf_options['first_post_contains'] == 'full') ? 'selected="yes"' : ''; ?>>Full Wordpress Post & Link</option>
					<?php /* <option value='excerpt' <?php echo ($xf_options['first_post_contains'] == 'excerpt') ? 'selected="yes"' : ''; ?>>Wordpress Post Excerpt & Link</option> */ ?>
					<option value='link' <?php echo ($xf_options['first_post_contains'] == 'link') ? 'selected="yes"' : ''; ?>>Only A Link</option>
				</select>
				<br /><br />
				What Forum ID should threads for each category of post go in? <small><em>Note: default must be specified. Specifying for any other category is optional and if not specified the default value will be used.</em></small>
				<br />
				<label for="xf_category_forum_id_default">
				Default
				<input name="xf_category_forum_id_default" type="text" id="xf_category_forum_id_default" value="<?php echo $xf_options['xf_category_forum_id']['default']; ?>" />
				</label>
				<br />
				<?php
				//Produce list of all categories
				$categories = get_categories( array ( 'hide_empty' => '0' ) );
				foreach($categories as $category)
				{
					$name = $category->name;
					$slug = $category->slug;
					echo '<label for="xf_category_forum_id_' . $slug . '">';
					echo $name . ' ';
					echo '<input name="xf_category_forum_id_' . $slug . '" type="text" id="xf_category_forum_id_' . $slug . '" value="' . $xf_options['xf_category_forum_id'][$slug] . '" />';
					echo "</label><br />";
				}
				?>
				</fieldset></td>
				</tr>
				
				<tr valign="top">
				<th scope="row">Comment System</th>
				<td><fieldset><legend class="screen-reader-text"><span>Thread Creation System</span></legend>
				<label for="use_comment_system">
				<input name="use_comment_system" type="checkbox" id="use_comment_system" <?php echo ($xf_options['use_comment_system'] == 'on') ? 'checked="checked"':''; ?>  />
				Replace the Wordpress comment system with the XenForo one (all comments will show up on both the blog and forum if set below).
				<small><em> Will only apply to posts made after this addon was installed, only has any effect if the Thread Creation System is turned on.</em></small></label>
				<br />
				<label for "display_comments_in_wp">
				<input name="display_comments_in_wp" type="checkbox" id="display_comments_in_wp" <?php echo ($xf_options['display_comments_in_wp'] == 'on') ? 'checked="checked"':''; ?> />
				Display comments in WordPress (if unselected only a link to the forum discussion will be displayed) <em><small>This option only has any effect if the box above is checked. Displaying a link will require template edits - see the readme</small></em>
				</label>
				<br />
				<label for="comments_per_page">
				Display <input name="comments_per_page" type="text" id="comments_per_page" value="<?php echo $xf_options['comments_per_page']; ?>" /> comments per page on Wordpress posts.
				</label>
				<br />
				<small><em>If the XenForo system is used all permissions should be configured in the XenForo Admin panel. e.g. guest posting ability is decided by whether or not guests can reply to threads in that forum on XenForo</em></small>
				<br />
				</fieldset></td>
				</tr>
			</table>
		<p class="submit">
		<input type="submit" name="Submit" class="button-primary" value="<?php esc_attr_e('Save Changes') ?>" />
		</p>
		</form>
	</div>
	<?php
}

add_action('admin_menu', 'xf_options_menu');
?>