<?php

abstract class Waindigo_Listener_TemplateCreate
{
	protected $_templateName = null;
	protected $_params = null;
	/**
	 * @var XenForo_Template_Abstract
	 */	
	protected $_template = null;
	
	/**
	 * @param string $templateName
	 * @param array $params
	 * @param XenForo_Template_Abstract $template
	 */
	public function __construct(&$templateName, array &$params, XenForo_Template_Abstract $template) {
		$this->_templateName = $templateName;
		$this->_params = $params;
		$this->_template = $template;
	}
	
	public function run() {
		return array($this->_templateName, $this->_params);
	}
	
	/**
	 * @param string $templateName
	 */
	protected function _preloadTemplate($templateName)
	{
		$this->_template->preloadTemplate($templateName);
	}
	
	/**
	 * @param array $templateNames
	 */
	protected function _preloadTemplates(array $templateNames)
	{
		foreach ($templateNames as $templateName)
		{
			$this->_preloadTemplate($templateName);
		}
	}
}