<?php
						
class Waindigo_Friends_ControllerPublic_Member extends XFCP_Waindigo_Friends_ControllerPublic_Member
{
	/**
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionMember()
	{
		/* @var $response XenForo_ControllerResponse_View */
		$response = parent::actionMember();
		
		if (get_class($response) == 'XenForo_ControllerResponse_View')
		{
			$friendRecord = $this->_getUserModel()->getFriendRecord($response->params['user']['user_id']);
			if (isset($friendRecord['friend_state']))
			{
				$response->params['friend_record'] = $friendRecord;
			}
			
			$friends = $this->_getUserModel()->getUserFriends($response->params['user']['user_id']);
			$response->params['friends'] = $friends;
			$response->params['friendsCount'] = count($friends);
			
			if ($response->params['user']['user_id'] != XenForo_Visitor::getUserId())
			{
				$mutualFriends = array();
				foreach ($friends as $friendUserId => $friendUser)
				{
					if ($friendUser['mutual_friend_state'] == 'confirmed')
					{
						$mutualFriends[$friendUserId] = $friendUser;
					}
				}
				$response->params['mutualFriends'] = $mutualFriends;
				$response->params['mutualFriendsCount'] = count($mutualFriends);
			}
		}
		
		return $response;
	}
	
	/**
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionCard()
	{
		/* @var $response XenForo_ControllerResponse_View */
		$response = parent::actionCard();
	
		if (get_class($response) == 'XenForo_ControllerResponse_View')
		{
			$friendRecord = $this->_getUserModel()->getFriendRecord($response->params['user']['user_id']);
			if (isset($friendRecord['friend_state']))
			{
				$response->params['friend_record'] = $friendRecord;
			}
		}
	
		return $response;
	}
	
	public function actionFriends()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);
	
		$userModel = $this->_getUserModel();
	
		// TODO: pagination?
	
		$viewParams = array(
				'user' => $user,
				'friends' => $userModel->getFriendsUserProfiles($user['user_id'])
		);
	
		return $this->responseView('Waindigo_Friends_ViewPublic_Member_Friends', 'waindigo_member_friends_friends', $viewParams);
	}
	
	public function actionMutualFriends()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);
	
		$userModel = $this->_getUserModel();
	
		// TODO: pagination?
	
		$viewParams = array(
				'user' => $user,
				'friends' => $userModel->getMutualFriendsUserProfiles($user['user_id'])
		);
	
		return $this->responseView('Waindigo_Friends_ViewPublic_Member_MutualFriends', 'waindigo_member_mutual_friends_friends', $viewParams);
	}
	
	
	public function actionFriend()
	{
		$this->_assertRegistrationRequired();
	
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$message = $this->_input->filterSingle('message', XenForo_Input::STRING);
		$knowPersonally = $this->_input->filterSingle('know_personally', XenForo_Input::UINT);
		
		if (!$user = $this->_getUserModel()->getUserById($userId, array('join' => XenForo_Model_User::FETCH_USER_OPTION)))
		{
			return $this->responseError(new XenForo_Phrase('requested_member_not_found'), 404);
		}
	
		$visitor = XenForo_Visitor::getInstance();
	
		$options = XenForo_Application::getOptions();
		
		if (!$this->_getUserModel()->isFollowing($userId) && $options->waindigo_friends_requireFollow)
		{
			return $this->responseError(new XenForo_Phrase('waindigo_you_must_be_following_before_friend'));
		}
	
		if ($this->isConfirmedPost())
		{
			$this->_getUserModel()->friend($user, null, $message, $knowPersonally);
	
			return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_Link::buildPublicLink('members', $user)
			);
		}
		else // show confirmation dialog
		{
			$friend = $this->_getUserModel()->getFriendRecord($userId);
			$viewParams = array(
				'user' => $user,
				'friend' => $friend,
			);
	
			return $this->responseView('Waindigo_Friends_ViewPublic_Member_Friend', 'waindigo_member_friend_friend', $viewParams);
		}
	}
	
	public function actionUnfriend()
	{
		$this->_assertRegistrationRequired();
	
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
	
		if (!$user = $this->_getUserModel()->getUserById($userId))
		{
			return $this->responseError(new XenForo_Phrase('requested_member_not_found'), 404);
		}
	
		$visitor = XenForo_Visitor::getInstance();
	
		if ($this->isConfirmedPost())
		{
			$this->_getUserModel()->unfriend($userId);
	
			return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_Link::buildPublicLink('members', $user)
			);
		}
		else // show confirmation dialog
		{
			$viewParams = array('user' => $user);
	
			return $this->responseView('Waindigo_Friend_ViewPublic_Member_Unfriend', 'waindigo_member_unfriend_friend', $viewParams);
		}
	}
}