<?php
class SplendidNetwork_XfRuAlbumsMore_ControllerPublic_Albums extends XFCP_SplendidNetwork_XfRuAlbumsMore_ControllerPublic_Albums
{
	public function actionIndex()
	{
		$response = parent::actionIndex();
		
		$albums = $this->limitAlbumsOnType($response->params['albums']);		
		$response->params['albums'] = $albums;
				
		return $response;	
	}
	
	public function actionList()
	{
		$response = parent::actionList();
		
		$albums = $this->limitAlbumsOnType($response->params['albums']);
		$response->params['albums'] = $albums;
		
		return $response;
	}
	
	
	public function actionView()
	{
		$response = parent::actionView();
		
		$albums = $this->limitAlbumsOnType(array($response->params['album']));
		if(!$albums)
		{
			return $this->responseError(new XenForo_Phrase('xfr_album_not_available'));
		}
		else
		{
			list($album) = $albums; 
			$response->params['album'] = $album;			
			return $response;
		}
	}
	
	
	public function actionInsert()
	{
		$this->_assertPostOnly();
		
		$input = $this->_input->filter(array(
				'title' => XenForo_Input::STRING,
				'type' => XenForo_Input::STRING,
				'recipients' => XenForo_Input::STRING
		));
		
		if ($input['type'] == 'selected' && empty($input['recipients']))
		{
			return $this->responseError(new XenForo_Phrase('xfr_empty_selected'));
		}
		
		if (empty($input['recipients']))
		{
			return parent::actionInsert();
		}
		else 
		{
			$response =  parent::actionInsert();
			
			$albumsModel = $this->_getXfRuAlbumsMoreModel();
			$albumId = $albumsModel->getUserLatestAlbumId(XenForo_Visitor::getUserId());
			
			$recipients = trim($input['recipients']);			
			if(substr($recipients, -1) == ',')
			{
				$recipients = substr($recipients, 0, -1);
			}						
			$recipientsArr = explode (',', $recipients);			
			
			$userModel = $this->_getUserModel();
			$users = $userModel->getUsersByNames($recipientsArr);

			if($users)
			{
				$userIds = '';
				foreach ($users as $user)
				{
					$userIds .= $user['user_id'] . ',';
				}
				
				$userIds = substr($userIds, 0, -1);
				
				$albumsModel->updateAlbumSelectedUsers($albumId, $userIds);
			}
						
			return $response;
		}
	}
	
	public function actionSave()
	{
		$this->_assertPostOnly();
	
		$input = $this->_input->filter(array(
				'title' => XenForo_Input::STRING,
				'type' => XenForo_Input::STRING,
				'recipients' => XenForo_Input::STRING,
				'moderated'  => XenForo_Input::UINT,
		));
		
		if ($input['type'] == 'selected' && empty($input['recipients']))
		{
			return $this->responseError(new XenForo_Phrase('xfr_empty_selected'));
		}
		
		if (empty($input['recipients']))
		{
			return parent::actionSave();
		}
		
		else
		{
			$response =  parent::actionSave();
			$albumsModel = $this->_getXfRuAlbumsMoreModel();
			
			$albumId = $this->_input->filterSingle('album_id', XenForo_Input::UINT);
			$recipients = trim($input['recipients']);
			if(substr($recipients, -1) == ',')
			{
				$recipients = substr($recipients, 0, -1);
			}
			$recipientsArr = explode (',', $recipients);
			
			$userModel = $this->_getUserModel();
			$users = $userModel->getUsersByNames($recipientsArr);
			
			if($users)
			{
				$userIds = '';
				foreach ($users as $user)
				{
					$userIds .= $user['user_id'] . ',';
				}
			
				$userIds = substr($userIds, 0, -1);
			
				$albumsModel->updateAlbumSelectedUsers($albumId, $userIds);
			}
			
			return $response;			
		}		
	}
	
	public function limitAlbumsOnType($albums)
	{
		if($albums)
		{
			$visitor = XenForo_Visitor::getInstance();
			
			foreach($albums AS $key => $album)
			{
				if(!$visitor['user_id'])
				{
					if($album['album_type'] == 'members' || $album['album_type'] == 'followed' || $album['album_type'] == 'selected')
					{
						unset($albums[$key]);
					}
				}
				else
				{
					if($album['user_id'] == $visitor['user_id'])
						continue;
					
					if($visitor->hasPermission('xfrUserAlbumsPermissions', 'xfr_UAM_ByPassPrivacy'))
						continue;
	
					if($album['album_type'] == 'followed')
					{
						$userModel = $this->_getUserModel();
	
						$followRecord = $userModel->getFollowRecord($album['user_id'], $visitor['user_id']);
						if(!$followRecord)
						{
							unset($albums[$key]);
						}
					}
	
					if($album['album_type'] == 'selected')
					{
						$selected_users = explode(',',$album['selected_users']);
	
						if (!in_array($visitor['user_id'], $selected_users))
						{
							unset($albums[$key]);
						}
					}
				}
			}
		}
		return $albums;
	}
	
	protected function _getXfRuAlbumsMoreModel()
	{
		return $this->getModelFromCache('SplendidNetwork_XfRuAlbumsMore_Model_Albums');
	}
	
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
}