<?php

/**
* Data writer for currency.
*
* @package Brivium_Credits
*/
class Brivium_Credits_DataWriter_Currency extends XenForo_DataWriter
{
	/**
	 * Title of the phrase that will be created when a call to set the
	 * existing data fails (when the data doesn't exist).
	 *
	 * @var string
	 */
	protected $_existingDataErrorPhrase = 'BRC_requested_currency_not_found';
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'xf_credits_currency' => array(
				'currency_id'		=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'title'				=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 50,'requiredError' => 'please_enter_valid_title'),
				'code'				=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 10,'requiredError' => 'BRC_please_enter_valid_code'),
				'symbol_left'		=> array('type' => self::TYPE_STRING, 'default' => '','maxLength' => 12),
				'symbol_right'		=> array('type' => self::TYPE_STRING, 'default' => '','maxLength' => 12),
				'decimal_place'		=> array('type' => self::TYPE_UINT, 'default' => 0),
				'value'				=> array('type' => self::TYPE_FLOAT, 'default' => 1,'maxLength' => 15),
				'status'			=> array('type' => self::TYPE_UINT, 'default' => 1),
				'date_modified'		=> array('type' => self::TYPE_UINT, 'default' => XenForo_Application::$time),
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$currencyId = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('xf_credits_currency' => $this->_getCurrencyModel()->getCurrencyById($currencyId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'currency_id = ' . $this->_db->quote($this->getExisting('currency_id'));
	}


	/**
	 * Internal post-save handler
	 */
	protected function _postSave()
	{
		$this->_getCurrencyModel()->rebuildCurrencyCaches();
	}
	/**
	 * Internal pre-delete handler.
	 */
	protected function _preDelete()
	{
		$currencyModel = $this->_getCurrencyModel();
		$currencies = $currencyModel->getAllCurrencies();

		if (sizeof($currencies) <= 1)
		{
			$this->error(new XenForo_Phrase('BRC_it_is_not_possible_to_delete_last_currency'));
		}

		if ($this->get('currency_id') == XenForo_Application::get('options')->BRC_defaultCurrencyId)
		{
			$this->error(new XenForo_Phrase('BRC_it_is_not_possible_to_remove_default_currency'));
		}
	}
	/**
	 * Post-delete behaviors.
	 */
	protected function _postDelete()
	{
		$this->_getCurrencyModel()->rebuildCurrencyCaches();
	}
	
	/**
	 * Gets the currency model.
	 *
	 * @return Brivium_Credits_Model_Currency
	 */
	protected function _getCurrencyModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Currency');
	}
	
	
	
}