!function($, window, document, _undefined)
{    	
	/*ToggleME 2.0.2*/
	var Tools = {},
	cookiename = 'toggleme',
	mycookie = $.getCookie(cookiename),
	bloodyIE = false;

	if($.browser.msie && parseInt($.browser.version, 10) < 8)
	{
		bloodyIE = true;
	}
	
	XenForo.ToggleME =
	{
		initGlobal: function($element)
		{
			// NODES with children
			$('.tglWchild').ready(function() 
			{
				var hook = '.tglWchild',
				cookie_data_prefix = 'main';
				
				Tools.bakeCategories(hook, cookie_data_prefix);
			});
		
			// NODES without children
			$('.tglNOchild').ready(function() 
			{
				var hook = '.tglNOchild',
				cookie_data_prefix = 'mix';
				
				Tools.bakeCategories(hook, cookie_data_prefix);
			});
		
			// NODELIST in FORUMVIEW
			$('.tglNodelist_forumview').ready(function()
			{
				Tools.bakeNodeList();
			});
	
			// SIDEBAR BLOCKS
			$('.tglSidebar').ready(function()
			{
				Tools.bakeBlocks();	
			});		
		
		},
		
		initPostbit: function($element)
		{
			$tglPostbit = $element.find('.tglPosbit').addClass("inactive");

			if($tglPostbit.length == 0)
			{
				return;
			}

			$element.find('.extraUserInfo').hide();
			
			//Needed for ajax
      			/*
      			 	The class "extraUserInfo" is used instead of "tglPosbit" because it's located in 
      				"message_user_info" template AFTER xenForo check content verification, so this
      				will prevent to display the toggle icon if extraUserInfo has no content ^^
      			*/
      		
      			$element.find('.tglPosbit').toggle(
      				function () {
      					$(this).parents('.messageUserBlock').find('.extraUserInfo').slideDown(500);
      					$(this).removeClass('inactive').addClass("active");
      				},
      				function () {
      					$(this).parents('.messageUserBlock').find('.extraUserInfo').slideUp(500);
      					$(this).removeClass('active').addClass("inactive");
      				}
      			);

		}
	}

	Tools.bakeCookie = function(cname, ccat, cval) 
	{
		var cdata = ccat + ':' + cval;	
	
		if (mycookie && !(mycookie == 'undefined')){//if the cookie exists and its value is defined
			var cdatas = mycookie.split('[]'),
			ccat_regex = new RegExp( ccat + ":[01]", "i" );
			
			if (mycookie.match(ccat_regex)){//if the category is found inside cookie change its value
				mycookie = mycookie.replace(ccat_regex, cdata);
			} 
			else{//if the category is not found, add it inside the cookie
				mycookie = mycookie + '[]' + cdata;
			}
		}
		else//if the cookie hasn't been created yet
		{
			mycookie = cdata;
		}

		//Date Expiratation
		var expires = 90; // number of days
		expires = new Date(new Date().getTime() + expires * 86400000); // milliseconds in a day
	
		return $.setCookie(cname, mycookie, expires); //final cookie value
	}
	
	Tools.bakeCategories = function(hook, cookie_data_prefix)
	{
		var hook_active = hook + '.active',
		hook_inactive = hook + '.inactive',
		hook_defaultoff = hook + '.tglWOFF',
		chkClass = false;		

		if(!$(hook).hasClass("tglDnt"))
		{
			chkClass = true;
		}
		
		$(hook).addClass("active");
	
		//Multi theme and multi-addon trick
		$(hook).parent().each(function(){
			$(this).nextAll().not('span').wrapAll('<div class="toggleMEtarget" />');
		});
	
		//Force close option ?
		if(hook_defaultoff)
		{
			/*
				Not needed => if user decided to open a closed category, don't automatically close it again
				$(hook_defaultoff).parent().next().css({display:"none"});
				$(hook_defaultoff).removeClass('active').addClass("inactive");
				$(hook_defaultoff).parent().removeClass("categoryStrip").addClass("CategoryStripCollapsed");
			*/
		}
	
		//Check inside cookie which category has to be collapsed
		if (mycookie && !(mycookie == 'undefined')){
		//The cookie exists, let's proceed
			//Let's get all the categories with ID (XenForo Categories -  template_postrender fct || XenForo Add-ons -  template_hook fct)
			$(hook).each(function(index){
				var node_id = this.id,
				TargeT = $(this).parent().next(), // = li.category ol ; = toggleMEtarget
				check_regex_closed = new RegExp(cookie_data_prefix + node_id + ":1", "i" ), //Look inside cookie to check if category was closed
				check_regex_opened = new RegExp(cookie_data_prefix + node_id + ":0", "i" ); //Look inside cookie to check if category was opened
											
				if ( (mycookie.match(check_regex_closed)) || ($(this).hasClass('tglWOFF') && !(mycookie.match(check_regex_opened)) && !(mycookie.match(check_regex_closed))) ){
					$(TargeT).hide();
					$(TargeT).prev().children(hook).removeClass('active').addClass('inactive');
					if(chkClass == true)
					{
						$(TargeT).prev().removeClass('categoryStrip').addClass('CategoryStripCollapsed');
					}
				}
			});
	
		}
		else{
		//The cookie doesn't exist, manage the defaut closed categories
			$(hook_defaultoff).parent().next().hide();
			$(hook_defaultoff).removeClass('active').addClass("inactive");
			if(chkClass == true)
			{			
				$(hook_defaultoff).parent().removeClass("categoryStrip").addClass("CategoryStripCollapsed");
			}
		};
	
		//Active class
		$(hook_active).toggle(
			function () {// I was considered as active, COLLAPSE ME !
				if(bloodyIE) { $(this).parent().next().slideUp(500).hide(); } else { $(this).parent().next().slideUp(500); }
				
				$(this).removeClass('active').addClass("inactive");
				if(chkClass == true)
				{
					$(this).parent().removeClass('categoryStrip').addClass("CategoryStripCollapsed");
				}
	
				var num = $(this).attr('id'),
				cookieCategory = cookie_data_prefix + num,
				cookieCategoryValue = '1';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
			},
			function () {// I was considered as active and you COLLAPSE ME, EXPAND ME !
				if(bloodyIE) { $(this).parent().next().show(); } else { $(this).parent().next().slideDown(500); }
				$(this).removeClass('inactive').addClass("active");
				if(chkClass == true)
				{
					$(this).parent().removeClass("CategoryStripCollapsed").addClass("categoryStrip");
				}
	
				var num = $(this).attr('id'),
				cookieCategory = cookie_data_prefix + num,
				cookieCategoryValue = '0';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
			}
		);
		
		//Inactive class
		$(hook_inactive).toggle(
			function () {// I was considered as inactive, EXPAND ME !
				if(bloodyIE) { $(this).parent().next().show(); } else { $(this).parent().next().slideDown(500); }
				$(this).removeClass('inactive').addClass("active");
				if(chkClass == true)
				{
					$(this).parent().removeClass("CategoryStripCollapsed").addClass("categoryStrip");
				}
				var num = $(this).attr('id'),
				cookieCategory = cookie_data_prefix + num,
				cookieCategoryValue = '0';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
	
			},
			function () { // I was considered as inactive and you expanded me, COLLAPSE ME !
				if(bloodyIE) { $(this).parent().next().hide(); } else { $(this).parent().next().slideUp(500); }
				$(this).removeClass('active').addClass("inactive");
				if(chkClass == true)
				{				
					$(this).parent().removeClass('categoryStrip').addClass("CategoryStripCollapsed");
				}

				var num = $(this).attr('id'),
				cookieCategory = cookie_data_prefix + num,
				cookieCategoryValue = '1';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
			}
		);
	}

	Tools.bakeNodeList = function()
	{
		var hook = '.tglNodelist_forumview',
		hook_active = hook + '.active',
		hook_inactive = hook + '.inactive',
		cookie_data_prefix = 'ndfw_',
		ndfw_id = $('.tglNodelist_forumview').attr('id'), //will be unique anyway: 1 per page max
		cookieCategory = cookie_data_prefix + ndfw_id;
	
		//Wrap all next tags in parent
		$(hook).each(function(){
			$(this).nextAll().wrapAll('<div class="toggleMEtarget" />');
		});

		//Check if must be closed by default
		if($(hook).hasClass("tglNodeOff"))
		{
			$(hook).addClass("inactive");
			$(hook).children('.toggleME_Expand').show();
			$(hook).children('.toggleME_Collapse').hide();
			$(hook).next().hide();
		}
		else
		{
			$(hook).addClass("active");
			$(hook).children('.toggleME_Expand').hide();
			$(hook).children('.toggleME_Collapse').show();
		}
	
		//Cookie check
		if (mycookie && !(mycookie == 'undefined')){
			var check_regex = new RegExp(cookieCategory + ":1", "i" );
	
			if (mycookie.match(check_regex)){
				$(hook).next().hide();
				$(hook).removeClass('active').addClass('inactive');
				$(hook).children('.toggleME_Expand').show();
				$(hook).children('.toggleME_Collapse').hide();
			}
		};
	
		//Let's toogle !
		$(hook_active).toggle(
			function () {// I was considered as active, COLLAPSE ME !
				$(this).children('.toggleME_Collapse').hide();
				$(this).children('.toggleME_Expand').show();
				$(this).next().slideUp(500);
				$(this).removeClass('active').addClass("inactive");
	
				var cookieCategoryValue = '1';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
			},
			function () {// I was considered as active and you COLLAPSE ME, EXPAND ME !
				$(this).children('.toggleME_Collapse').show();
				$(this).children('.toggleME_Expand').hide();
				$(this).next().slideDown(500);
				$(this).removeClass('inactive').addClass("active");
	
				var cookieCategoryValue = '0';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
			}
		);
		$(hook_inactive).toggle(
			function () {// I was considered as inactive, EXPAND ME !
				$(this).children('.toggleME_Collapse').show();
				$(this).children('.toggleME_Expand').hide();
				$(this).next().slideDown(500);
				$(this).removeClass('inactive').addClass("active");
	
				var cookieCategoryValue = '0';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
	
			},
			function () { // I was considered as inactive and you expanded me, COLLAPSE ME !
				$(this).children('.toggleME_Collapse').hide();
				$(this).children('.toggleME_Expand').show();
				$(this).next().slideUp(500);
				$(this).removeClass('active').addClass("inactive");
	
				var cookieCategoryValue = '1';
				Tools.bakeCookie(cookiename, cookieCategory, cookieCategoryValue);
			}
		);
	}

	Tools.bakeBlocks= function()
	{
      		var hook = '.tglSidebar',
      		hook_active = hook + '.active',
      		hook_inactive = hook + '.inactive',
      		hook_defaultoff = hook + '.tglSbOFF',
      		cookie_data_prefix = 'sbb';
      	
      		$(hook).addClass("active");
      	
      		//Wrap all next tags in parent
      		$(hook).next().each(function(){
      			$(this).nextAll().wrapAll('<div class="toggleMEtarget" />');
      		});
      	
      		//Cookie check
      		if (mycookie && !(mycookie == 'undefined')){
      		//The cookie exists, let's proceed
      			//Let's get all the categories with ID (XenForo Categories -  template_postrender fct || XenForo Add-ons -  template_hook fct)
      			$(hook).each(function(index){
      				var sbb_id = this.id;
      				var check_regex_closed = new RegExp(cookie_data_prefix + sbb_id + ":1", "i" ); //Look inside cookie to check if category was closed
      				var check_regex_opened = new RegExp(cookie_data_prefix + sbb_id + ":0", "i" ); //Look inside cookie to check if category was opened
      											
      				if ( (mycookie.match(check_regex_closed)) || ($(this).hasClass('tglSbOFF') && !(mycookie.match(check_regex_opened)) && !(mycookie.match(check_regex_closed))) ){
      					$(this).siblings('.toggleMEtarget').hide();
      					$(this).removeClass('active').addClass("inactive");
      					$(this).parent().removeClass('secondaryContent').addClass("secondaryContentCollapsed");				
      				}
      			});
      	
      		}
      		else{
      		//The cookie doesn't exist, manage the defaut closed categories
      			$(hook_defaultoff).siblings('.toggleMEtarget').hide();
      			$(hook_defaultoff).removeClass('active').addClass("inactive");
      			$(hook_defaultoff).parent().removeClass('secondaryContent').addClass("secondaryContentCollapsed");				
      		};
      	
      		//Let's toogle !
      		$(hook_active).toggle(
      			function () {// I was considered as active, COLLAPSE ME !
      				$(this).siblings('.toggleMEtarget').slideUp(500);
      				$(this).removeClass('active').addClass("inactive");
      				$(this).parent().removeClass('secondaryContent').addClass("secondaryContentCollapsed");
      	
      				var num = $(this).attr('id');
      				var cookieWidget = cookie_data_prefix + num;
      				var cookieWidgetValue = '1';
      				Tools.bakeCookie(cookiename, cookieWidget, cookieWidgetValue);
      			},
      			function () {// I was considered as active and you COLLAPSE ME, EXPAND ME !
      				$(this).siblings('.toggleMEtarget').slideDown(500);
      				$(this).removeClass('inactive').addClass("active");
      				$(this).parent().removeClass('secondaryContentCollapsed').addClass("secondaryContent");
      	
      				var num = $(this).attr('id');
      				var cookieWidget = cookie_data_prefix + num;
      				var cookieWidgetValue = '0';
      				Tools.bakeCookie(cookiename, cookieWidget, cookieWidgetValue);
      			}
      		);
      		$(hook_inactive).toggle(
      			function () {// I was considered as inactive, EXPAND ME !
      				$(this).siblings('.toggleMEtarget').slideDown(500);
      				$(this).removeClass('inactive').addClass("active");
      				$(this).parent().removeClass('secondaryContentCollapsed').addClass("secondaryContent");
      	
      				var num = $(this).attr('id');
      				var cookieWidget = cookie_data_prefix + num;
      				var cookieWidgetValue = '0';
      				Tools.bakeCookie(cookiename, cookieWidget, cookieWidgetValue);
      	
      			},
      			function () { // I was considered as inactive and you expanded me, COLLAPSE ME !
      				$(this).siblings('.toggleMEtarget').slideUp(500);
      				$(this).removeClass('active').addClass("inactive");
      				$(this).parent().removeClass('secondaryContent').addClass("secondaryContentCollapsed");
      	
      				var num = $(this).attr('id');
      				var cookieWidget = cookie_data_prefix + num;
      				var cookieWidgetValue = '1';
      				Tools.bakeCookie(cookiename, cookieWidget, cookieWidgetValue);
      			}
      		);
	}

	 XenForo.register('body', 'XenForo.ToggleME.initGlobal');
	 XenForo.register('.messageUserBlock', 'XenForo.ToggleME.initPostbit');	 
}
(jQuery, this, document);