<?php

class XenGallery_Model_File extends XenForo_Model
{
	/**
	 * Inserts uploaded attachment data.
	 *
	 * @param XenForo_Upload $file Uploaded attachment info. Assumed to be valid
	 * @param integer $userId User ID uploading
	 * @param array $extra Extra params to set
	 *
	 * @return integer Attachment data ID
	 */
	public function insertUploadedAttachmentData(XenForo_Upload $file, $userId, array $extra = array())
	{
		if ($file->isImage()
			&& XenForo_Image_Abstract::canResize($file->getImageInfoField('width'), $file->getImageInfoField('height'))
		)
		{
			$dimensions = array(
				'width' => $file->getImageInfoField('width'),
				'height' => $file->getImageInfoField('height'),
			);

			$tempThumbFile = tempnam(XenForo_Helper_File::getTempDir(), 'xf');
			if ($tempThumbFile)
			{           
				$image = XenForo_Image_Abstract::createFromFile($file->getTempFile(), $file->getImageInfoField('type'));
				if ($image)
				{   
                    $thumbnailDimension = XenForo_Application::get('options')->xengalleryThumbnailDimensions;
                    
                    $imageOrientation = $image->getOrientation();
                    $imageWidth = $image->getWidth();
                    $imageHeight = $image->getHeight();
                    
                    $hasThumbnailed = false;
                    
                    switch ($imageOrientation)
                    {
						case 'square':
						
	                        $image->thumbnail($thumbnailDimension);
	                        $hasThumbnailed = true;					
	                        	
							break;
							
						case 'landscape':
						
	                        $image->thumbnailFixedShorterSide($thumbnailDimension);
	                        
	                        $imageWidth = $image->getWidth();
	                        
	                        $image->crop(($imageWidth / 2) - ($thumbnailDimension / 2), 0, $thumbnailDimension, $thumbnailDimension);
	                        
	                        $hasThumbnailed = true;						
	                        
							break;
							
						case 'portrait':
						
	                        $image->thumbnailFixedShorterSide($thumbnailDimension);
	                        
	                        $imageHeight = $image->getHeight();
	                     
	                        $image->crop(0, ($imageHeight / 2) - ($thumbnailDimension / 2), $thumbnailDimension, $thumbnailDimension);
	                        
	                        $hasThumbnailed = true;
	                        
	                        break;
                    }
                    
					if ($hasThumbnailed)
					{
						$image->output($file->getImageInfoField('type'), $tempThumbFile);
					}
					else
					{
						copy($file->getTempFile(), $tempThumbFile); // no resize necessary, use the original
					}

					$dimensions['thumbnail_width'] = $image->getWidth();
					$dimensions['thumbnail_height'] = $image->getHeight();

					unset($image);
				}
			}
		}
		else
		{
			$tempThumbFile = '';
			$dimensions = array();
		}

		try
		{
			$dataDw = XenForo_DataWriter::create('XenForo_DataWriter_AttachmentData');
			$dataDw->bulkSet($extra);
			$dataDw->set('user_id', $userId);
			$dataDw->set('filename', $file->getFileName());
			$dataDw->bulkSet($dimensions);
			$dataDw->setExtraData(XenForo_DataWriter_AttachmentData::DATA_TEMP_FILE, $file->getTempFile());
			if ($tempThumbFile)
			{
				$dataDw->setExtraData(XenForo_DataWriter_AttachmentData::DATA_TEMP_THUMB_FILE, $tempThumbFile);
			}
			$dataDw->setExtraData(XenGallery_DataWriter_AttachmentData::DATA_XMG_DATA, true);
			$dataDw->save();
		}
		catch (Exception $e)
		{
			if ($tempThumbFile)
			{
				@unlink($tempThumbFile);
			}

			throw $e;
		}

		if ($tempThumbFile)
		{
			@unlink($tempThumbFile);
		}

		// TODO: add support for "on rollback" behavior

		return $dataDw->get('data_id');
	}
}
