<?php

class XenGallery_Listener
{
	protected static $_addedUsernameChange = false;
	
	public static function navigationTabs(array &$extraTabs, $selectedTabId)
	{
		if (XenForo_Visitor::getInstance()->hasPermission('xengallery', 'view'))
		{
			$definedPrefix = XenForo_Application::get('options')->xengalleryRoutePrefix;
			
			$extraTabs['xengallery'] = array(
				'title' => new XenForo_Phrase('xengallery_media'),
				'href' => XenForo_Link::buildPublicLink("full:$definedPrefix"),
				'position' => 'middle',
				'linksTemplate' => 'xengallery_tab_links'
			);
		}
	}
	
	public static function extendControllers($class, array &$extend)
	{
		switch ($class)
		{
			case 'XenForo_ControllerPublic_FindNew':
			
				$extend[] = 'XenGallery_ControllerPublic_FindNew';
				break;
		}
		
		if (XenForo_Application::$versionId < 1020031)
		{
			if ($class == 'XenForo_ControllerPublic_Index')
			{
				$extend[] = 'XenGallery_ControllerPublic_Index';
			}
		}
		elseif (XenForo_Application::$versionId >= 1020031)
		{
			if ($class == 'XenForo_ControllerPublic_Forum')
			{
				$extend[] = 'XenGallery_ControllerPublic_Index';
			}
		}
	}
	
	public static function extendViews($class, array &$extend)
	{
		switch ($class)
		{
			case 'XenForo_ViewPublic_Forum_List':
			
				$extend[] = 'XenGallery_ViewPublic_Forum_List';
				break;
		}
	}
	
	public static function extendDataWriters($class, array &$extend)
	{
		if (!self::$_addedUsernameChange && $class == 'XenForo_DataWriter_User')
		{
			self::$_addedUsernameChange = true;
			XenForo_DataWriter_User::$usernameChangeUpdates['permanent']['xengallery_username'] =
				array('xengallery_media', 'username', 'user_id');
		}
		
		switch ($class)
		{
			case 'XenForo_DataWriter_AttachmentData':
				
				$extend[] = 'XenGallery_DataWriter_AttachmentData';
				break;
		}
	}	
	
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if (XenForo_Visitor::getInstance()->hasPermission('xengallery', 'view'))
		{		
			switch ($hookName)
			{
				case 'member_view_tabs_heading':
				
					$params = $template->getParams();
					
					$contents .= $template->create('xengallery_media_profile_tab', $params);
					break;
					
				case 'member_view_tabs_content':
				
					$params = $template->getParams();
					
					$contents .= $template->create('xengallery_media_profile_tab_content', $params);
					break;
					
	    		case 'member_card_stats':

					$params = $template->getParams();
					
					$contents .= $template->create('xengallery_member_card_stats_media', $params);
	                break;
	                
				case 'account_alerts_after_profile_posts':
				
					$params = $template->getParams();
				
					$contents .= $template->create('xengallery_account_alert_preferences', $params);	
					break;
					
				case 'search_form_tabs':
				
					$params = $template->getParams();
				
					$contents .= $template->create('xengallery_search_form_tabs', $params);
					break;
					
				case 'forum_list_nodes':
					
					$options = XenForo_Application::get('options');
					if ($options->xengalleryForumListRecent && XenForo_Visitor::getInstance()->hasPermission('xengallery', 'view'))
					{
						$params = $template->getParams();
						
						$block = $template->create('xengallery_forum_list_recent', $params)->render();
						
						if ($options->xengalleryForumListPosition == 'top')
						{
							$contents = $block . $contents;
						}
						else
						{
							$contents = $contents . $block;
						}
					}
					
					break;
					
				case 'navigation_visitor_tab_links2':
				
					$params = $template->getParams();
					
					if (XenForo_Visitor::getInstance()->media_count)
					{
						$params = $template->getParams();
						
						$contents = $template->create('xengallery_navigation_visitor_tab_links', $params) . $contents;
					}
					
					break;
			}
		}
	}
	
	public static function templatePostRender($templateName, &$contents, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($template instanceof XenForo_Template_Admin && $templateName == 'tools_rebuild')
		{
			$contents .= $template->create('xengallery_tools_rebuild', $template->getParams())->render();
		}
		
		if ($template instanceof XenForo_Template_Public && $templateName == 'find_new_threads')
		{
			$params = $template->getParams();
			
			$replace = $template->create('xengallery_find_new_tabs', $params);
			$contents = preg_replace('/<div class="pageNavLinkGroup">(.*?<\/div>)/is', "$replace \\0", $contents, 1);
			$contents = str_replace('sectionMain', '', $contents);				
		}
	}	
	
	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		switch ($templateName)
		{
			case 'forum_list':
			
				$template->preloadTemplate('xengallery_forum_list_recent');
				break;
		}
	}
	
	public static function initDependencies(XenForo_Dependencies_Abstract $dependencies, array $data)
	{
		if (isset($data['routesPublic']))
		{
			if (isset($data['routesPublic']['xenmediagallery']))
			{
				$definedPrefix = XenForo_Application::get('options')->xengalleryRoutePrefix;
				
				$data['routesPublic'][$definedPrefix] = $data['routesPublic']['xenmediagallery'];
			}
			
			XenForo_Link::setHandlerInfoForGroup('public', $data['routesPublic']);
		}
		
		if ($dependencies instanceof XenForo_Dependencies_Admin)
		{
			XenForo_CacheRebuilder_Abstract::$builders['MediaThumbnails'] = 'XenGallery_CacheRebuilder_Thumbnail';
			XenForo_CacheRebuilder_Abstract::$builders['MediaCounts'] = 'XenGallery_CacheRebuilder_MediaCount';
		}		
	}	
}