<?php

abstract class Waindigo_Listener_ControllerPreDispatch
{
	protected static $_checkForUpdates = null;
	protected static $_upgradeAddOns = array();
	protected static $_installAddOns = array();
	
	protected static $_checkForCopyright = null;
	protected static $_showCopyright = false;
	
	/**
	 * Standard approach to caching other model objects for the lifetime of the model.
	 *
	 * @var array
	 */
	protected $_modelCache = array();
	
	/**
	* @var XenForo_Controller
	*/
	protected static $_controller = null;
	protected static $_action = '';
	
	/**
	 * @param XenForo_Dependencies_Abstract $dependencies
	 * @param array $data
	 */
	public function __construct(XenForo_Controller $controller, $action)
	{
		if (is_null(self::$_controller)) self::$_controller = $controller;
		if (!self::$_action) self::$_action = $action;
	}

	public function run()
	{
		$cpdListeners = XenForo_CodeEvent::getEventListeners('controller_pre_dispatch');
		
		$lastListener = end($cpdListeners);
		if ($lastListener[0] == get_class($this) && !isset(self::$_checkForCopyright))
		{
			self::$_checkForCopyright = true;
			$this->_removeUnwantedCopyrightNotice();
		}
		
		$firstListener = reset($cpdListeners);
	    if ($firstListener[0] == get_class($this) && !isset(self::$_checkForUpdates))
    	{
    		self::$_checkForUpdates = true;
    		/* @var $options XenForo_Options */
	    	$options = XenForo_Application::get('options');
   	    	$lastXMLUploadDate = $options->waindigo_last_xml_upload_date;
	    	
	    	/* @var $dir Directory */
	    	$dir = dir(XenForo_Autoloader::getInstance()->getRootDir() . '/../install/data/');
	    	
	    	$addOns = array();
	    	
	    	while($entry=$dir->read())
	    	{
				if (strlen($entry) > strlen('addon-Waindigo_.xml')
						&& substr($entry, 0, strlen('addon-Waindigo_')) == 'addon-Waindigo_')
				{
					if (filemtime(XenForo_Autoloader::getInstance()->getRootDir() . '/../install/data/' . $entry) > $lastXMLUploadDate)
					{
						$addOns[] = substr($entry, strlen('addon-'), strlen($entry) - strlen('addon-.xml'));
					}
				}
	    	}
	    	
	    	if ($this->_checkAddOnsNeedUpgrading($addOns))
	    	{
	    		$upgradeAddOns = $this->getUpgradeAddOns();
	    		if (!empty($upgradeAddOns))
	    		{
			    	XenForo_Application::get('options')->set('boardActive', false);
	    		}
	    	}
    	}
	}
	
	public static function isAddOnEnabled($addOnId, $codeEvent = '')
	{
		if (!$codeEvent)
		{
			$codeEvents = array(
				'container_admin_params',
				'container_public_params',
				'controller_post_dispatch',
				'controller_pre_dispatch',
				'criteria_page',
				'criteria_user',
				'file_health_check',
				'front_controller_post_view',
				'front_controller_pre_dispatch',
				'front_controller_pre_route',
				'front_controller_pre_view',
				'init_dependencies',
				'init_router_public',
				'load_class_bb_code',
				'load_class_controller',
				'load_class_datawriter',
				'load_class_importer',
				'load_class_mail',
				'load_class_model',
				'load_class_route_prefix',
				'load_class_search_data',
				'load_class_view',
				'navigation_tabs',
				'option_captcha_render',
				'search_source_create',
				'template_create',
				'template_hook',
				'template_post_render',
				'visitor_setup',
				'load_class_installer_waindigo',
				'load_class_pdf_waindigo',
				'load_class_reward_handler',
			);
		}
		else
		{
			$codeEvents = array($codeEvent);
		}
		
		foreach ($codeEvents as $codeEvent)
		{
			$listeners = XenForo_CodeEvent::getEventListeners($codeEvent);
			if (!empty($listeners))
			{
				foreach ($listeners as $listener)
				{
					if (strlen($listener[0]) > strlen($addOnId)
							&& substr($listener[0], 0, strlen($addOnId)) == $addOnId)
					{
						return true;
					}
				}
			}
		}
		return false;
	}
	
	protected function _run()
	{
		try {
			return $this->run();
		} catch (Exception $e) {
			// do nothing
		}
	}
	
	/**
	 * Gets the specified model object from the cache. If it does not exist,
	 * it will be instantiated.
	 *
	 * @param string $class Name of the class to load
	 *
	 * @return XenForo_Model
	 */
	public function getModelFromCache($class)
	{
		if (!isset($this->_modelCache[$class]))
		{
			$this->_modelCache[$class] = XenForo_Model::create($class);
		}
	
		return $this->_modelCache[$class];
	}

	protected function _checkAddOnsNeedUpgrading(array $addOns)
	{
		/* @var $addOnModel XenForo_Model_AddOn */
		$addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
		 
		$allAddOns = $addOnModel->getAllAddOns();

		foreach ($addOns as $addOnId)
		{
			if (isset($allAddOns[$addOnId]))
			{
				$addOn = $allAddOns[$addOnId];
				 
				$addOnXML = new SimpleXMLElement(file_get_contents(XenForo_Autoloader::getInstance()->getRootDir() . '/../install/data/addon-'.$addOnId.'.xml'));
				$versionId = (string)$addOnXML->attributes()->version_id;
				if ($versionId > $addOn['version_id'])
				{
					self::$_upgradeAddOns[$addOnId] = $addOn;
				}
			}
			else
			{
				self::$_installAddOns[] = $addOnId;
			}
		}
		
		if (is_subclass_of(self::$_controller, 'XenForo_ControllerAdmin_Abstract'))
		{
			$controllerName = self::$_controller->getRequest()->getParam('_controllerName');
			$action = self::$_controller->getRequest()->getParam('_action');
			if ($controllerName == 'XenForo_ControllerAdmin_AddOn')
			{
				if ($action == 'WaindigoUpgrade' || $action == 'WaindigoInstall')
				{
					$this->_upgradeOrInstallAddOns($action);
				}
			}
			
			if (self::$_action == 'Index' && get_class(self::$_controller) == 'XenForo_ControllerAdmin_Home')
			{
				eval('class Waindigo_Listener_ControllerPreDispatch_TemplatePostRender
{
	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($templateName == "home")
		{
			$upgradeAddOns = Waindigo_Listener_ControllerPreDispatch::getUpgradeAddOns();
			if (!empty($upgradeAddOns))
			{
				$content = \'<p class="importantMessage"><a href="\'.XenForo_Link::buildAdminLink(\'add-ons/waindigo-upgrade\').\'">There are add-ons ready to be upgraded. Click here to upgrade them.</a></p>\' . $content;
			}
			else
			{
				$installAddOns = Waindigo_Listener_ControllerPreDispatch::getInstallAddOns();
				if (!empty($installAddOns))
				{
					$content = \'<p class="importantMessage"><a href="\'.XenForo_Link::buildAdminLink(\'add-ons/waindigo-install\').\'">There are add-ons ready to be installed. Click here to install them.</a></p>\' . $content;
				}
			}
		}
	}
}');
				XenForo_CodeEvent::setListeners(array('template_post_render' => array(array('Waindigo_Listener_ControllerPreDispatch_TemplatePostRender', 'templatePostRender'))));
			}
		}
		
		if (empty(self::$_upgradeAddOns) && empty(self::$_installAddOns)) return false;
		
		return true;
	}
	
	public static function getUpgradeAddOns()
	{
		return self::$_upgradeAddOns;
	}
	
	public static function getInstallAddOns()
	{
		return self::$_installAddOns;
	}
	
	protected function _upgradeOrInstallAddOns($action)
	{
		$template = new XenForo_Template_Admin('PAGE_CONTAINER_SIMPLE', array(
				'jQuerySource' => XenForo_Dependencies_Abstract::getJquerySource(),
				'xenOptions' => XenForo_Application::get('options')->getOptions(),
				'_styleModifiedDate' => XenForo_Application::get('adminStyleModifiedDate'),
		));
		$template->setLanguageId(1);
		
		if ($action == 'WaindigoUpgrade')
		{
			$template->setParam('title', 'Upgrading Waindigo Add-ons...');
			$addOns = array_keys(self::getUpgradeAddOns());
		}
		elseif ($action == 'WaindigoInstall')
		{
			$template->setParam('title', 'Installing Waindigo Add-ons...');
			$addOns = self::getInstallAddOns();
		}
		
		$addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
		if (count($addOns))
		{
			$addOn = reset($addOns);
			$fileName = XenForo_Autoloader::getInstance()->getRootDir() . '/../install/data/addon-'.$addOn.'.xml';
			if ($action == 'WaindigoUpgrade')
			{
				try
				{
					$caches = $addOnModel->installAddOnXmlFromFile($fileName, $addOn);
					$template->setParam('contents', '<form action="'.XenForo_Link::buildAdminLink('add-ons/waindigo-upgrade').'" class="xenForm formOverlay CacheRebuild" method="post">
						<p id="ProgressText">Upgrading... <span class="RebuildMessage"></span> <span class="DetailedMessage"></span></p>
						<p id="ErrorText" style="display: none">An error occurred or the request was stopped.</p>
						<input type="submit" class="button" value="Continue Upgrading" />
						<input type="hidden" name="_xfToken" value="'.XenForo_Visitor::getInstance()->get('csrf_token_page').'" />
						</form>');
				}
				catch (Exception $e)
				{
					$template->setParam('contents', 'Upgrade error (' . $addOn . '). Please use the standard upgrade tool and report any error messages to Waindigo.');
				}
			}
			else
			{
				try
				{
					$caches = $addOnModel->installAddOnXmlFromFile($fileName);
					$template->setParam('contents', '<form action="'.XenForo_Link::buildAdminLink('add-ons/waindigo-install').'" class="xenForm formOverlay CacheRebuild" method="post">
						<p id="ProgressText">Installing... <span class="RebuildMessage"></span> <span class="DetailedMessage"></span></p>
						<p id="ErrorText" style="display: none">An error occurred or the request was stopped.</p>
						<input type="submit" class="button" value="Continue Installing" />
						<input type="hidden" name="_xfToken" value="'.XenForo_Visitor::getInstance()->get('csrf_token_page').'" />
						</form>');
				}
				catch (Exception $e)
				{
					$template->setParam('contents', 'Install error (' . $addOn . '). Please use the standard install tool and report any error messages to Waindigo.');
				}
			}
		}
		else
		{
			$caches = $addOnModel->rebuildAddOnCaches();
		}
		
		if (!count($addOns) && isset($caches))
		{
			if (self::$_controller->getRouteMatch()->getResponseType() == 'json')
			{
				header('Content-Type: application/json; charset=UTF-8');
				echo json_encode(array('_redirectTarget' => XenForo_Link::buildAdminLink('index')));
			}
			else
			{
				header('Location: '.XenForo_Link::buildAdminLink('index'));
			}
		}
		else if (count($addOns) == 1 && isset($caches))
		{
			if (self::$_controller->getRouteMatch()->getResponseType() == 'json')
			{
				header('Content-Type: application/json; charset=UTF-8');
				echo json_encode(array(
					'_redirectTarget' => XenForo_Link::buildAdminLink('tools/cache-rebuild', null,
							array('caches' => json_encode($caches)))
				));
			}
			else
			{
				header('Location: '.XenForo_Link::buildAdminLink('tools/cache-rebuild', null,
					array('caches' => json_encode($caches))));
			}
		}
		else
		{
			if (self::$_controller->getRouteMatch()->getResponseType() == 'json')
			{
				if ($action == 'WaindigoUpgrade')
				{
					echo json_encode(array(	'_redirectTarget' => XenForo_Link::buildAdminLink('add-ons/waindigo-upgrade')));
				}
				else
				{
					echo json_encode(array(	'_redirectTarget' => XenForo_Link::buildAdminLink('add-ons/waindigo-install')));
				}
			}
			else
			{
				$output = $template->render();
				$output = str_replace("<!--XenForo_Require:JS-->", '<script src="js/xenforo/cache_rebuild.js"></script>', $output);
				echo $output;
			}
		}
		exit();
	}
	
	/**
	 * This is to ensure copyright notices don't display on every page if all add-ons
	 * are newer than 15 September 2012 (unless explicitly set).
	 */
	protected function _removeUnwantedCopyrightNotice()
	{
		if (self::$_showCopyright) return;
		
		$className = get_class(self::$_controller);
		if (strlen($className) > strlen('Waindigo_')
				&& substr($className, 0, strlen('Waindigo')) == 'Waindigo')
		{
			return;
		}
		
		$addOns = array();
		$rootDir = XenForo_Autoloader::getInstance()->getRootDir();
	
		$thListeners = XenForo_CodeEvent::getEventListeners('template_hook');
		if (!empty($thListeners))
		{
			$templateHookVersion = 0;
			foreach ($thListeners as $templateHook)
			{
				if (strlen($templateHook[0]) > strlen('Waindigo_')
						&& substr($templateHook[0], 0, strlen('Waindigo_')) == 'Waindigo_')
				{
					if (!$templateHookVersion)
					{
						if ($handle = opendir($rootDir . '/Waindigo/Listener/TemplateHook')) {
							while (false !== ($entry = readdir($handle))) {
								if (intval($entry) > $templateHookVersion)
								{
									$templateHookVersion = intval($entry);
								}
							}
						}
					}
					if ($templateHookVersion < '20120715') return;
					$addOns[] = substr($templateHook[0], 0, strlen($templateHook[0])-strlen('_Listener_TemplateHook'));
				}
			}
		}
	
		$tprListeners = XenForo_CodeEvent::getEventListeners('template_post_render');
		if (!empty($tprListeners))
		{
			$templatePostRenderVersion = 0;
			foreach ($tprListeners as $templatePostRender)
			{
				if (strlen($templatePostRender[0]) > strlen('Waindigo_')
						&& substr($templatePostRender[0], 0, strlen('Waindigo_')) == 'Waindigo_')
				{
					
					if (!$templatePostRenderVersion)
					{
						if ($handle = opendir($rootDir . '/Waindigo/Listener/TemplatePostRender')) {
							while (false !== ($entry = readdir($handle))) {
								if (intval($entry) > $templatePostRenderVersion)
								{
									$templatePostRenderVersion = intval($entry);
								}
							}
						}
					}
					$addOnId = substr($templatePostRender[0], 0, strlen($templatePostRender[0])-strlen('_Listener_TemplatePostRender'));
					if (in_array($addOnId, $addOns)) continue;
					if ($templatePostRenderVersion < '20120715') return;
					$addOns[] = $addOnId;
				}
			}
		}
		
		$lccListeners = XenForo_CodeEvent::getEventListeners('load_class_controller');
		if (!empty($lccListeners))
		{
			$loadClassVersion = 0;
			foreach ($lccListeners as $loadClassController)
			{
				if (strlen($loadClassController[0]) > strlen('Waindigo_')
						&& substr($loadClassController[0], 0, strlen('Waindigo_')) == 'Waindigo_')
				{
						
					if (!$loadClassVersion)
					{
						if ($handle = opendir($rootDir . '/Waindigo/Listener/LoadClass')) {
							while (false !== ($entry = readdir($handle))) {
								if (intval($entry) > $loadClassVersion)
								{
									$loadClassVersion = intval($entry);
								}
							}
						}
					}
					$addOnId = substr($loadClassController[0], 0, strlen($loadClassController[0])-strlen('_Listener_LoadClassController'));
					if ($loadClassVersion >= '20121018')
					{
						$loadClassController = Waindigo_Listener_LoadClass::create($loadClassController[0]);
						$extendedClasses = $loadClassController->getExtendedClasses();
						if (in_array(get_class(self::$_controller), $extendedClasses)) return;
					}
					if (!in_array($addOnId, $addOns)) $addOns[] = $addOnId;
				}
			}
		}
		
		$cpdListeners = XenForo_CodeEvent::getEventListeners('controller_pre_dispatch');
		foreach ($cpdListeners as $controllerPreDispatch)
		{
			if (strlen($controllerPreDispatch[0]) > strlen('Waindigo_')
					&& substr($controllerPreDispatch[0], 0, strlen('Waindigo_')) == 'Waindigo_')
			{
				$addOnId = substr($controllerPreDispatch[0], 0, strlen($controllerPreDispatch[0])-strlen('_Listener_ControllerPreDispatch'));
				$addOnKey = array_search($addOnId, $addOns);
				if ($addOnKey !== FALSE) unset($addOns[$addOnKey]);
			}
		}
		
		if (empty($addOns))
		{
			if (method_exists('Waindigo_Listener_Template', 'setCopyrightNotice'))
			{
				Waindigo_Listener_Template::setCopyrightNotice(true);
			}
			else
			{
				eval('class ' . $addOnId . '_Listener_Template extends Waindigo_Listener_Template
{
	public static function setCopyrightNotice($copyrightNotice)
	{
		self::$_copyrightNotice = $copyrightNotice;
	}
}');
				call_user_func(array($addOnId . '_Listener_Template', 'setCopyrightNotice'), true);
			}
		}
	}
}