<?php

abstract class Waindigo_Install
{
	/**
	 * @var Zend_Db_Adapter_Abstract
	 */
	protected $_db;

	protected $_fieldNameChanges;
	protected $_tables;
	protected $_tableChanges;
	protected $_contentTypes;
	protected $_contentTypeFields;
	protected $_nodeTypes;
	protected $_userFields;
	protected $_primaryKeys;
	protected $_uniqueKeys;
	protected $_keys;
	protected $_fields;

	/**
	 * Standard approach to caching other model objects for the lifetime of the model.
	 *
	 * @var array
	 */
	protected $_modelCache = array();

	/**
	 * Gets the specified model object from the cache. If it does not exist,
	 * it will be instantiated.
	 *
	 * @param string $class Name of the class to load
	 *
	 * @return XenForo_Model
	 */
	public function getModelFromCache($class)
	{
		if (!isset($this->_modelCache[$class]))
		{
			$this->_modelCache[$class] = XenForo_Model::create($class);
		}

		return $this->_modelCache[$class];
	}

	/**
	 * Gets the autoloader's root directory.
	 *
	 * @return string
	 */
	public function getRootDir()
	{
		return XenForo_Autoloader::getInstance()->getRootDir();
	}

	/**
	 * At some point this will be made final, but old add-ons still extend it at present.
	 */
	public static function install()
	{
		$addOnData = func_get_arg(1);
		if (class_exists($addOnData['addon_id']."_Install"))
		{
			$installer = self::create($addOnData['addon_id']."_Install");
			$installer->_install();
		}
	}

	/**
	 * At some point this will be made final, but old add-ons still extend it at present.
	 */
	public static function uninstall()
	{
		$addOnData = func_get_arg(0);
		if (class_exists($addOnData['addon_id']."_Install"))
		{
			$uninstaller = self::create($addOnData['addon_id']."_Install");
			$uninstaller->_uninstall();
		}
	}

	/**
	 * Factory method to get the named installer. The class must exist or be autoloadable
	 * or an exception will be thrown.
	 *
	 * @param string Class to load
	 *
	 * @return Waindigo_Install
	 */
	public static function create($class)
	{
		$createClass = XenForo_Application::resolveDynamicClass($class, 'installer_waindigo');
		if (!$createClass)
		{
			throw new XenForo_Exception("Invalid installer '$class' specified");
		}

		return new $createClass;
	}

	protected final function _install()
	{
		$this->_preInstallBeforeTransaction();
		$this->_db->beginTransaction();
		$this->_preInstall();
		if (!empty($this->_fieldNameChanges))
			$this->_makeFieldNameChanges($this->_fieldNameChanges);
		if (!empty($this->_tables))
			$this->_createTables($this->_tables);
		if (!empty($this->_tableChanges))
			$this->_makeTableChanges($this->_tableChanges);
		if (!empty($this->_contentTypeFields))
			$this->_insertContentTypeFields($this->_contentTypeFields);
		if (!empty($this->_contentTypes) || !empty($this->_contentTypeFields))
			$this->_insertContentTypes($this->_contentTypes);
		if (!empty($this->_nodeTypes))
			$this->_insertNodeTypes($this->_nodeTypes);
		if (!empty($this->_userFields))
			$this->_createUserFields($this->_userFields);
		if (!empty($this->_primaryKeys))
			$this->_addPrimaryKeys($this->_primaryKeys);
		if (!empty($this->_uniqueKeys))
			$this->_addUniqueKeys($this->_uniqueKeys);
		if (!empty($this->_keys))
			$this->_addKeys($this->_keys);
		if (!empty($this->_fields))
			$this->_insertFields($this->_fields);
		$this->_postInstall();
		$this->_db->commit();
		$this->_postInstallAfterTransaction();
	}

	protected final function _uninstall()
	{
		$this->_preUninstallBeforeTransaction();
		$this->_db->beginTransaction();
		$this->_preUninstall();
		if (!empty($this->_tables))
			$this->_dropTables($this->_tables);
		if (!empty($this->_tableChanges))
			$this->_dropTableChanges($this->_tableChanges);
		if (!empty($this->_contentTypeFields))
			$this->_deleteContentTypes($this->_contentTypeFields);
		if (!empty($this->_contentTypes) || !empty($this->_contentTypeFields))
			$this->_deleteContentTypes($this->_contentTypes);
		if (!empty($this->_nodeTypes))
			$this->_deleteNodeTypes($this->_nodeTypes);
		if (!empty($this->_userFields))
			$this->_dropUserFields($this->_userFields);
		if (!empty($this->_fields))
			$this->_deleteFields($this->_fields);
		$this->_postUninstall();
		$this->_db->commit();
		$this->_postUninstallAfterTransaction();
	}

	public function __construct()
	{
		$this->_db = XenForo_Application::get('db');
		$this->_fieldNameChanges = $this->_getFieldNameChanges();
		$this->_tables = $this->_getTables();
		$this->_tableChanges = $this->_getTableChanges();
		$this->_contentTypes = $this->_getContentTypes();
		$this->_contentTypeFields = $this->_getContentTypeFields();
		$this->_nodeTypes = $this->_getNodeTypes();
		$this->_userFields = $this->_getUserFields();
		$this->_primaryKeys = $this->_getPrimaryKeys();
		$this->_uniqueKeys = $this->_getUniqueKeys();
		$this->_keys = $this->_getKeys();
		$this->_fields = $this->_getFields();
	}

	protected function _getFieldNameChanges()
	{
		return array();
	}

	protected function _getTables()
	{
		return array();
	}

	protected function _getTableChanges()
	{
		return array();
	}

	protected function _getContentTypes()
	{
		return array();
	}

	protected function _getContentTypeFields()
	{
		return array();
	}

	protected function _getNodeTypes()
	{
		return array();
	}

	protected function _getUserFields()
	{
		return array();
	}

	protected function _getPrimaryKeys()
	{
		return array();
	}

	protected function _getUniqueKeys()
	{
		return array();
	}

	protected function _getKeys()
	{
		return array();
	}

	protected function _getFields()
	{
		return array();
	}

	protected function _makeFieldNameChanges(array $fieldNameChanges)
	{
		foreach ($fieldNameChanges as $tableName => $rows)
		{
			if (in_array($tableName, $this->_db->listTables()))
			{
				$describeTable = $this->_db->describeTable($tableName);
				$keys = array_keys($describeTable);

				$sql = "ALTER TABLE `".$tableName."` ";
				$sqlAdd = array();
				foreach ($rows as $oldFieldName => $newField)
				{
					if (in_array($oldFieldName, $keys))
					{
						$sqlAdd[] = "CHANGE `".$oldFieldName."` ".$newField;
					}
				}
				$sql .= implode(", ", $sqlAdd);
				$this->_db->query($sql);
			}
		}
	}

	protected function _createTables(array $tables)
	{
		foreach ($tables as $tableName => $rows)
		{
			if (!in_array($tableName, $this->_db->listTables()))
			{
				$sql = "CREATE TABLE IF NOT EXISTS `".$tableName."` (";
				$sqlRows = array();
				foreach ($rows as $rowName => $rowParams)
				{
					$sqlRows[] = "`".$rowName."` ".$rowParams;
				}
				$sql.= implode(",", $sqlRows);
				$sql.= ") ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci";
				$this->_db->query($sql);
			}
			else
			{
				$sql = "ALTER TABLE `".$tableName."` ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci";
			}
		}

		$this->_makeTableChanges($tables);
	}

	protected function _makeTableChanges(array $tableChanges)
	{
		foreach ($tableChanges as $tableName => $rows)
		{
			if (in_array($tableName, $this->_db->listTables()))
			{
				$describeTable = $this->_db->describeTable($tableName);
				$keys = array_keys($describeTable);

				$sql = "ALTER IGNORE TABLE `".$tableName."` ";
				$sqlAdd = array();
				foreach ($rows as $rowName => $rowParams)
				{
					if (strpos($rowParams, 'PRIMARY KEY') !== false)
					{
						if ($this->_getExistingPrimaryKeys($tableName))
						{
							$sqlAdd[] = "DROP PRIMARY KEY ";
						}
					}
					if (in_array($rowName, $keys))
					{
						$sqlAdd[] = "CHANGE `".$rowName."` `".$rowName."` ".$rowParams;
					}
					else
					{
						$sqlAdd[] = "ADD `".$rowName."` ".$rowParams;
					}
				}
				$sql .= implode(", ", $sqlAdd);
				$this->_db->query($sql);
			}
		}
	}

	protected function _getExistingPrimaryKeys($tableName)
	{
		$columns = $this->_db->describeTable($tableName);

		$primaryKeys = array();
		foreach ($columns as $columnName => $column)
		{
			if ($column['PRIMARY'])
			{
				$primaryKeys[] = $columnName;
			}
		}
		return $primaryKeys;
	}

	protected function _addPrimaryKeys(array $primaryKeys)
	{
		foreach ($primaryKeys as $tableName => $primaryKey)
		{
			$oldKey = $this->_getExistingPrimaryKeys($tableName);
			$keyDiff = array_diff($primaryKey, $oldKey);
			if (!empty($keyDiff))
			{
				$sql = "ALTER TABLE `".$tableName."`
					". (empty($oldKey) ? "": "DROP PRIMARY KEY, ") ."
					ADD PRIMARY KEY(".implode(",", $primaryKey).")";
				$this->_db->query($sql);
			}
		}
	}


	protected function _getExistingKeys($tableName)
	{
		$columns = $this->_db->describeTable($tableName);

		$indexes = $this->_db->fetchAll('SHOW INDEXES FROM  `'.$tableName.'`');

		$keys = array();
		foreach ($indexes as $index)
		{
			$keys[$index['Key_name']] = $index;
		}
		return $keys;
	}

	protected function _addUniqueKeys(array $uniqueKeys)
	{
		foreach ($uniqueKeys as $tableName => $uniqueKey)
		{
			$oldKeys = $this->_getExistingKeys($tableName);
			foreach ($uniqueKey as $keyName => $keyColumns)
			{
				$sql = "ALTER TABLE `".$tableName."`
					". (!isset($oldKeys[$keyName]) ? "": "DROP INDEX `" . $keyName . "`, ") ."
					ADD UNIQUE `" . $keyName . "` (" . implode(",", $keyColumns) . ")";
				$this->_db->query($sql);
			}
		}
	}

	protected function _addKeys(array $keys)
	{
		foreach ($keys as $tableName => $key)
		{
			$oldKeys = $this->_getExistingKeys($tableName);
			foreach ($key as $keyName => $keyColumns)
			{
				$sql = "ALTER TABLE `".$tableName."`
					". (!isset($oldKeys[$keyName]) ? "": "DROP INDEX `" . $keyName . "`, ") ."
					ADD INDEX `" . $keyName . "` (" . implode(",", $keyColumns) . ")";
				$this->_db->query($sql);
			}
		}
	}

	protected function _dropTables(array $tables)
	{
		foreach ($tables as $tableName => $rows)
		{
			$sql = "DROP TABLE IF EXISTS `".$tableName."` ";
			$this->_db->query($sql);
		}
	}

	protected function _dropTableChanges(array $tableChanges)
	{
		foreach ($tableChanges as $tableName => $rows)
		{
			$keys = array_keys($this->_db->describeTable($tableName));

			foreach ($rows as $rowName => $rowParams)
			{
				if (in_array($rowName, $keys))
				{
					$sql = "ALTER TABLE `".$tableName."` DROP `".$rowName;
					$this->_db->query($sql);
				}
			}
		}
	}

	protected function _insertFields(array $inserts)
	{
		foreach ($inserts as $insert)
		{
			if (isset($insert['table_name'], $insert['data_writer']))
			{
				$dw = XenForo_DataWriter::create($insert['data_writer']);
				if (isset($insert['primary_fields']))
				{
					$strSql = "SELECT count(*) FROM `".$insert['table_name']."` ";
					$whereClauses = array();
					foreach ($insert['primary_fields'] as $fieldName => $fieldValue)
					{
						$whereClauses[] = "`".$fieldName."` = '".$fieldValue."'";
					}
					if (!empty($whereClauses))
					{
						$strSql.= "WHERE ".implode(" AND ", $whereClauses)." ";
					}
					if ($this->_db->fetchOne($strSql))
					{
						$dw->setExistingData($insert['primary_fields']);
					}
				}
				$dw->bulkSet($insert['primary_fields']);
				if (isset($insert['fields']))
				{
					$dw->bulkSet($insert['fields']);
				}
				$dw->save();
			}
		}
	}

	protected function _deleteFields(array $inserts)
	{
		foreach ($inserts as $insert)
		{
			if (isset($insert['data_writer']))
			{
				$dw = XenForo_DataWriter::create($insert['data_writer']);
				if (isset($insert['primary_fields']))
				{
					$dw->setExistingData($insert['primary_fields']);
				}
				$dw->delete();
			}
		}
	}

	protected function _createUserFields(array $userFields)
	{
		foreach ($userFields as $fieldId => $fields)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_UserField');
			if (!$dw->setExistingData($fieldId))
			{
				$dw->set('field_id', $fieldId);
			}
			$dw->bulkSet($fields);
			$dw->save();
		}
	}

	protected function _dropUserFields(array $userFields)
	{
		foreach ($userFields as $fieldId => $fields)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_UserField');
			$dw->setExistingData($fieldId);
			$dw->delete();
		}
	}

	protected function _insertContentTypes(array $contentTypes)
	{
		foreach ($contentTypes as $contentType => $contentTypeParams)
		{
			if (isset($contentTypeParams['addon_id']))
			{
				$addOnId = $contentTypeParams['addon_id'];
				$sql = "INSERT INTO xf_content_type (
							content_type,
							addon_id,
							fields
						) VALUES (
							'".$contentType."',
							'".$addOnId."',
							''
						) ON DUPLICATE KEY UPDATE
							addon_id = '".$addOnId."'";
				$this->_db->query($sql);

				if (isset($contentTypeParams['fields']))
				{
    				$this->_insertContentTypeFields(array($contentType => $contentTypeParams['fields']));
				}
			}
		}
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
	}

	protected function _insertContentTypeFields(array $contentTypes)
	{
		foreach ($contentTypes as $contentType => $contentTypeFields)
		{
			foreach ($contentTypeFields as $fieldName => $fieldValue)
			{
				$sql = "INSERT INTO xf_content_type_field (
						content_type,
						field_name,
						field_value
					) VALUES (
						'".$contentType."',
						'".$fieldName."',
						'".$fieldValue."'
					) ON DUPLICATE KEY UPDATE
						field_value = '".$fieldValue."'";
				$this->_db->query($sql);
			}
		}
	}

	protected function _deleteContentTypes(array $contentTypes)
	{
		foreach ($contentTypes as $contentType => $contentTypeParams)
		{
			if (isset($contentTypeParams['addon_id']))
			{
				$addOnId = $contentTypeParams['addon_id'];
				$sql = "DELETE FROM xf_content_type WHERE content_type = '".$contentType."' AND addon_id = '".$addOnId."'";
				$this->_db->query($sql);
				$sql = "DELETE FROM xf_content_type_field WHERE content_type = '".$contentType."'";
				$this->_db->query($sql);
			}
		}
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
	}

	protected function _deleteContentTypeFields(array $contentTypes)
	{
		foreach ($contentTypes as $contentType => $contentTypeFields)
		{
			foreach ($contentTypeFields as $fieldName => $fieldValue)
			{
				$sql = "DELETE FROM xf_content_type_field WHERE content_type = '".$contentType."'
						AND field_name = '".$fieldName."' AND field_value = '".$fieldValue."'";
				$this->_db->query($sql);
			}
		}
	}

	protected function _insertNodeTypes(array $nodeTypes)
	{
		foreach ($nodeTypes as $nodeTypeId => $nodeTypeParams)
		{
			//Add library to the node type table
			$sql = "INSERT INTO `xf_node_type` (
					`node_type_id`,
					`handler_class`,
					`controller_admin_class`,
					`datawriter_class`,
					`permission_group_id`,
					`public_route_prefix`
				) VALUES (
					'".$nodeTypeId."',
					'".$nodeTypeParams['handler_class']."',
					'".$nodeTypeParams['controller_admin_class']."',
					'".$nodeTypeParams['datawriter_class']."',
				 	'".$nodeTypeParams['permission_group_id']."',
				 	'".$nodeTypeParams['public_route_prefix']."'
				 ) ON DUPLICATE KEY UPDATE
					handler_class = '".$nodeTypeParams['handler_class']."',
					controller_admin_class = '".$nodeTypeParams['controller_admin_class']."',
					datawriter_class = '".$nodeTypeParams['datawriter_class']."',
					permission_group_id = '".$nodeTypeParams['permission_group_id']."',
					public_route_prefix = '".$nodeTypeParams['public_route_prefix']."'";
			$this->_db->query($sql);
		}
		XenForo_Model::create('XenForo_Model_Node')->rebuildNodeTypeCache();
	}

	protected function _deleteNodeTypes(array $nodeTypes)
	{
		foreach ($nodeTypes as $nodeTypeId => $nodeTypeParams)
		{
			$sql = "DELETE FROM `xf_node_type` WHERE `node_type_id` = '".$nodeTypeId."' ";
			$this->_db->query($sql);
			$sql = "DELETE FROM `xf_node` WHERE `node_type_id` = '".$nodeTypeId."' ";
			$this->_db->query($sql);
		}
		XenForo_Model::create('XenForo_Model_Node')->rebuildNodeTypeCache();
	}

	protected function _preInstall()
	{
	}

	protected function _preInstallBeforeTransaction()
	{
	}

	protected function _preUninstall()
	{
	}

	protected function _preUninstallBeforeTransaction()
	{
	}

	protected function _postInstall()
	{
	}

	protected function _postInstallAfterTransaction()
	{
	}

	protected function _postUninstall()
	{
	}

	protected function _postUninstallAfterTransaction()
	{
	}
}