<?php

class Waindigo_EmailIdleUsers_UserLogHandler_EmailIdleUsers extends Waindigo_EmailIdleUsers_UserLogHandler_Abstract
{

    protected function _log(array $logUser, $action, array $actionParams = array())
    {
        $dw = XenForo_DataWriter::create('Waindigo_EmailIdleUsers_DataWriter_EmailIdleUsersLog');
        $dw->bulkSet(
            array(
                'user_id' => $logUser['user_id'],
                'username' => $logUser['username'],
                'content_type' => 'user',
                'action' => $action,
                'action_params' => $actionParams
            ));
        $dw->save();

        return $dw->get('log_id');
    } /* END _log */

    public function prepareEntry(array $entry)
    {
        $entry = $this->_prepareEntry($entry);

        if (!isset($entry['actionText'])) {
            $entry['actionText'] = new XenForo_Phrase(
                'waindigo_emailIdleUsers_log_' . $entry['content_type'] . '_' . $entry['action']);
        }

        $params = json_decode($entry['action_params'], true);
        $entry['last_activity'] = $params['old'];

        return $entry;
    } /* END prepareEntry */

    protected function _prepareEntry(array $entry)
    {
        return $entry;
    } /* END _prepareEntry */
}