<?php

/**
 * Controller for sending idle users emails.
 *
 * @package EmailIdleUsers
 */
class Waindigo_EmailIdleUsers_ControllerAdmin_EmailIdleUsers extends XenForo_ControllerAdmin_Abstract
{

    /**
     * @see XenForo_Controller::_preDispatch()
     */
    protected function _preDispatch($action)
    {
        $this->assertAdminPermission('user');
    } /* END _preDispatch */

    /**
     *
     * @return XenForo_ControllerResponse_View
     */
    public function actionIndex()
    {
        return $this->responseView('XenForo_ViewAdmin_Base', 'waindigo_emailidleusers', array());
    } /* END actionIndex */

    /**
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionSendEmail()
    {
        $textOnly = $this->_input->filterSingle('textOnly', XenForo_Input::UINT);
        $emailNumber = $this->_input->filterSingle('emailNumber', XenForo_Input::UINT);
        if ($emailNumber < 1 || $emailNumber > 2)
            return $this->responseError(new XenForo_Phrase('waindigo_email_number_must_be_one_or_two_emailidleusers'));

        $usernames = $this->_input->filterSingle('usernames', XenForo_Input::STRING);
        if (empty($usernames)) {
            // nothing to do so return
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('idle-users'));
        }

        $usernames = explode(',', $usernames);
        foreach ($usernames as &$name) {
            $name = trim($name);
        }

        $emailIdleUsersModel = $this->_getEmailIdleUsersModel();
        $userModel = $this->_getUserModel();
        $users = array();
        foreach ($usernames as $name) {
            $user = $userModel->getUserByName($name);
            if (empty($user)) {
                return $this->responseError($name . ' - ' . new XenForo_Phrase('requested_user_not_found'));
            } elseif (!empty($user['email'])) {
                $exists = $emailIdleUsersModel->getIdleUsersByUserId($user['user_id']);
                $include = true;

                if (!empty($exists)) {
                    if ($emailNumber == 1) {
                        if ($exists['email_one_date'] !== null) {
                            $include = false;
                        }
                    } else {
                        if ($exists['email_two_date'] !== null) {
                            $include = false;
                        }
                    }
                }

                if ($include) {
                    $users[$user['user_id']] = $user;
                }
            }
        }

        if (empty($users)) {
            // nothing to do so return
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('idle-users'));
        }

        // send emails
        $emailBodyHTML = '';
        $options = XenForo_Application::get('options');
        if ($emailNumber == 1) {
            $emailSubject = $options->waindigo_emailIdleUsers_email_subject_one;
            $emailBodyText = $options->waindigo_emailIdleUsers_email_text_one;
            if (!$textOnly) {
                $emailBodyHTML = $options->waindigo_emailIdleUsers_email_html_one;
            }
        } else {
            $emailSubject = $options->waindigo_emailIdleUsers_email_subject_two;
            $emailBodyText = $options->waindigo_emailIdleUsers_email_text_two;
            if (!$textOnly) {
                $emailBodyHTML = $options->waindigo_emailIdleUsers_email_html_two;
            }
        }

        $template = 'waindigo_email_emailidleusers';
        $emailIdleUsersLogModel = $this->_getEmailIdleUsersLogModel();

        foreach ($users as $user) {
            $params = array(
                'boardTitle' => $options->boardTitle,
                'boardUrl' => $options->boardUrl,
                'subject' => $emailSubject,
                'plainText' => $emailBodyText,
                'htmlText' => $emailBodyHTML
            );

            $numDays = ceil((XenForo_Application::$time - $user['last_activity']) / 86400);

            $params['username'] = $user['username'];
            $params['plainText'] = strtr($params['plainText'],
                array(
                    '{username}' => $user['username'],
                    '{numDays}' => $numDays,
                    '{boardUrl}' => $params['boardUrl'],
                    '{boardTitle}' => $params['boardTitle']
                ));
            if (!$textOnly) {
                $params['htmlText'] = nl2br(
                    strtr($params['htmlText'],
                        array(
                            '{username}' => $user['username'],
                            '{numDays}' => $numDays,
                            '{boardUrl}' => $params['boardUrl'],
                            '{boardTitle}' => $params['boardTitle']
                        )));
            }

            $mail = XenForo_Mail::create($template, $params, $user['language_id']);
            $mail->enableAllLanguagePreCache();
            $mail->queue($user['email'], $user['username']);

            // insert into table
            if ($emailNumber == 1) {
                $emailIdleUsersModel->registerEmailOne($user['user_id']);
                $type = 'email_one';
            } else {
                $emailIdleUsersModel->registerEmailTwo($user['user_id']);
                $type = 'email_two';
            }

            // log entry
            $actionParams['old'] = $user['last_activity'];
            $emailIdleUsersLogModel->logIdleUsersAction('user', $type, $actionParams, $user);
        }

        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
            XenForo_Link::buildAdminLink('idle-users-logs'));
    } /* END actionSendEmail */

    /**
     *
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    } /* END _getUserModel */

    /**
     *
     * @return Waindigo_EmailIdleUsers_Model_EmailIdleUsers
     */
    protected function _getEmailIdleUsersModel()
    {
        return $this->getModelFromCache('Waindigo_EmailIdleUsers_Model_EmailIdleUsers');
    } /* END _getEmailIdleUsersModel */

    /**
     *
     * @return Waindigo_EmailIdleUsers_Model_EmailIdleUsersLog
     */
    protected function _getEmailIdleUsersLogModel()
    {
        return $this->getModelFromCache('Waindigo_EmailIdleUsers_Model_EmailIdleUsersLog');
    } /* END _getEmailIdleUsersLogModel */
}