<?php

class UnreadPostCount_Listener
{
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if ($hookName == 'header' && $userId = XenForo_Visitor::getUserId())
		{
			$viewableNodes = XenForo_Model::create('XenForo_Model_Node')->getViewableNodeList();
			$nodeIds = array();
			
			foreach ($viewableNodes AS $key => $node)
			{
				if ($node['node_type_id'] == 'Forum')
				{
					$nodeIds[$key] = $key;
				}
			}
			
			$unread = XenForo_Model::create('UnreadPostCount_Model_Unread')->getUnreadPostCount($userId, $nodeIds);
			
			$whatsNewPhrase = new XenForo_Phrase('whats_new');
			$whatsNewPhraseQuoted = preg_quote($whatsNewPhrase->__toString());
			
			$replace = $template->create('unread_posts_count', array('unread' => $unread))->render();
			$contents = preg_replace('/<div class="tabLinks(.*?' . $whatsNewPhraseQuoted . ')/is', "$0 $replace", $contents, 1);
		}
	}
}