<?php

class ProfileViewCount_ControllerPublic_Member extends XFCP_ProfileViewCount_ControllerPublic_Member
{
	public function actionMember()
	{
		$parent = parent::actionMember();

		if ($this->_input->filterSingle('card', XenForo_Input::UINT))
		{
			return $parent;
		}

		$options = XenForo_Application::get('options');
		
		$db = XenForo_Application::getDb();

		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$visitorId = XenForo_Visitor::getUserId();
		
		$exists = '';
		
		if ($options->preventDupeVisits)
		{
			$exists = $db->fetchAll('
				SELECT *
				FROM xf_profile_view
				WHERE user_id = ?
				AND visitor_id = ?
			', array($userId, $visitorId));			
		}
		
		// Do not log visits to your own profile of by guests
		if ($userId != $visitorId && !$exists && $visitorId)
		{
		    $db->query('
		        INSERT ' . (XenForo_Application::get('options')->enableInsertDelayed ? 'DELAYED' : '') . ' INTO xf_profile_view
		        	(user_id, visitor_id)
		        VALUES
					(?, ?)
		    ', array($userId, $visitorId));
		}
		
		if ($options->showRecentViewers)
		{
			$viewers = $db->fetchAll('
				SELECT
					user.username,
					user.user_id
				FROM xf_profile_view AS profile_view
				INNER JOIN xf_user AS user ON
					(profile_view.visitor_id = user.user_id)
				WHERE profile_view.user_id = ?
				LIMIT ' . $options->showRecentViewers,
			array($userId));			
			
			$parent->params['viewers'] = $viewers;
		}
		
		$parent->params['user']['view_count']++;

		return $parent;
	}

	protected function _getViewCountModel()
	{
		return $this->getModelFromCache('ProfileViewCount_Model_ViewCount');
	}        
}