<?php

class Brivium_Credits_Model_User extends XFCP_Brivium_Credits_Model_User
{
	public function prepareUserConditions(array $conditions, array &$fetchOptions)
	{
		$result = parent::prepareUserConditions($conditions, $fetchOptions);
		$sqlConditions = array($result);
		
		if (!empty($conditions['dob_day'])) {
			$sqlConditions[] = 'user_profile.dob_day = ' . $this->_getDb()->quote($conditions['dob_day']);
		}
		if (!empty($conditions['dob_month'])) {
			$sqlConditions[] = 'user_profile.dob_month = ' . $this->_getDb()->quote($conditions['dob_month']);
		}
		if (count($sqlConditions) > 1) {
			return $this->getConditionsForClause($sqlConditions);
		} else {
			return $result;
		}
	
	}
	public function prepareUserOrderOptions(array &$fetchOptions, $defaultOrderSql = '')
	{
		$choices = array(
			'credits' => 'user.credits',
		);
		$result = $this->getOrderByClause($choices, $fetchOptions, '');
		if($result)
			return $result;
		else
			return parent::prepareUserOrderOptions($fetchOptions, $defaultOrderSql);
	}
}