<?php

/**
 * Cron entry for updating credits interest.
 */
class Brivium_Credits_CronEntry_Interest
{
	public static function runInterestUpdate()
	{
		$creditModel = XenForo_Model::create('Brivium_Credits_Model_Credit');
		$action = XenForo_Model::create('Brivium_Credits_Model_Action')->getActionById('interest');
		
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0,
		);
		$users = $userModel->getUsers($criteria, array(
			'join' => XenForo_Model_User::FETCH_USER_FULL
		));
		foreach ($users AS $user)
		{
			if(isset($user['credits']) && $user['credits'] > 0){
				$amount = $action['amount'] + $user['credits']*$action['multiplier'];
				$creditModel->updateUserCredit('interest',$user['user_id'],array('amount' => $amount,'user'=>$user));
			}
		}
	}
}