<?php

class Brivium_Credits_ControllerPublic_Credits extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$limit = XenForo_Application::get('options')->BRC_memberPerTop;
		$userModel = $this->_getUserModel();
		$transactionModel = $this->_getTransactionModel();
		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0
		);
		$fetchOptions = array(
			'limit' => $limit,
			'order' => 'credits',
		);
		// richest user
		$fetchOptions['direction'] = 'desc';
		$richestUsers = $userModel->getUsers($criteria, $fetchOptions);
		
		// poorest user
		$fetchOptions['direction'] = 'asc';
		$poorestUsers = $userModel->getUsers($criteria, $fetchOptions);
		
		// top transaction in day user
		$dayStartTimestamps = XenForo_Locale::getDayStartTimestamps();
		$conditions = array(
			'start' => $dayStartTimestamps['today'],
		);
		//top in day.
		$topEarnedInDay = $transactionModel->getTopEarnedTransactions($conditions, array('limit' => $limit));
		
		$topSpentInDay = $transactionModel->getTopSpentTransactions($conditions, array('limit' => $limit));
		
		$topEarnedInDays = array();
		$topSpentInDays = array();
		if(is_array($topEarnedInDay) && !empty($topEarnedInDay)){
			foreach($topEarnedInDay AS $userId=>$earnInfo){
				$topEarnedInDays[$userId] = $userModel->getUserById($userId);
				$topEarnedInDays[$userId]['credits'] = $earnInfo['credits'];
			}
		}
		if(is_array($topSpentInDay) && !empty($topSpentInDay)){
			foreach($topSpentInDay AS $userId=>$spentInfo){
				$topSpentInDays[$userId] = $userModel->getUserById($userId);
				$topSpentInDays[$userId]['credits'] = $spentInfo['credits'];
			}
		}
		$viewParams = array(
			'richestUsers'   => $richestUsers,
			'poorestUsers'   => $poorestUsers,
			'topSpentInDays'   => $topSpentInDays,
			'topEarnedInDays'   => $topEarnedInDays,
		);
		return $this->_getWrapper(
			'credits', 'index',
			$this->responseView(
				'Brivium_Credits_ViewAdmin_Credits_Index',
				'BRC_credits',
				$viewParams
			)
		);
	}
	/*========================= Transaction ================================*/
	public function actionTransactions()
	{
		$transactionModel = $this->_getTransactionModel();
		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$perPage = XenForo_Application::get('options')->BRC_transactionsPerPage;
		
		list($defaultOrder, $defaultOrderDirection) = $this->_getDefaultTransactionSort();

		$order = $this->_input->filterSingle('order', XenForo_Input::STRING, array('default' => $defaultOrder));
		$orderDirection = $this->_input->filterSingle('direction', XenForo_Input::STRING, array('default' => $defaultOrderDirection));
		$visitor = XenForo_Visitor::getInstance();
		$conditions = array(
			'user_id' => $visitor['user_id']
		);
		
		$actionId = $this->_input->filterSingle('action_id', XenForo_Input::STRING, array('default' => 0));
		if($actionId)$conditions['action_id'] = $actionId;
		$fetchOptions = array(
			'order' => $order,
			'orderDirection' => $orderDirection,
			'page' => $page,
			'perPage' => $perPage,
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);

		$totalTransactions = $transactionModel->countTransactions($conditions);
		
		$transactions = $transactionModel->getTransactions($conditions, $fetchOptions);
		$transactions = $transactionModel->prepareTransactions($transactions);
		
		$orderDirectionEx = ($orderDirection == 'desc' ? 'asc' : 'desc');
		
		$actionModel = $this->_getActionModel();
		$actions = $actionModel->getAllActions();
		$actions = $actionModel->prepareActions($actions);
		
		$viewParams = array(
			'actions' => $actions,
			'transactions' => $transactions,
			'page' => $page,
			'perPage' => $perPage,
			'actionId' => $actionId,
			'transactionStartOffset' => ($page - 1) * $perPage + 1,
			'transactionEndOffset' => ($page - 1) * $perPage + count($transactions) ,
			'totalTransactions' => $totalTransactions,
			'pagenavLink' => 'credits/transactions',
			
			'order' => $order,
			'orderDirection' => $orderDirection,
			'orderDirectionEx' => $orderDirectionEx,
		);
		return $this->_getWrapper(
			'credits', 'transactions',
			$this->responseView(
				'Brivium_Credits_ViewAdmin_Credits_Transaction',
				'BRC_transaction_list',
				$viewParams
			)
		);
	}
	
	public function actionViewTransaction()
	{
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);
		$transactionModel = $this->_getTransactionModel();
		$fetchOptions = array(
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);
		$transaction = $transactionModel->getTransactionById($transactionId,$fetchOptions);
		
		$viewParams = array(
			'transaction' => $transaction,
		);
		
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Action', 'BRC_view_transaction', $viewParams);
	}
	
	
	/*========================= Transfer ================================*/
	public function actionTransfer()
	{
		$creditModel = $this->_getCreditModel();
		$actionModel = $this->_getActionModel();
		$action = XenForo_Application::get('brcActions')->transfer;
		$action = $actionModel->getActionDataArray($action);
		if (!$creditModel->requireInclude($action)) {
			// it shouldn't be negative because we used filter
			return $this->responseError(new XenForo_Phrase('do_not_have_permission'));
		}
		$data = $this->_input->filter(array(
			'receiver' => XenForo_Input::STRING,
		));
		
		$visitor = XenForo_Visitor::getInstance()->toArray();
		if ($visitor['credits'] <= $action['amount']){  
			return $this->responseError(new XenForo_Phrase('BRC_your_credits_must_bigger_than_x',array('amount' => Brivium_Credits_Currency::currencyFormat($action['amount']))));
		}
		
		$viewParams = array(
			'receiver' => $data['receiver'],
			'action' => $action
		);

		return $this->_getWrapper(
			'credits', 'transfer',
			$this->responseView(
				'Brivium_Credits_ViewAdmin_Credits_Transaction',
				'BRC_transfer',
				$viewParams
			)
		);
	}
	public function actionDoTransfer()
	{
		$this->_assertPostOnly();
		$data = $this->_input->filter(array(
			'receiver' => XenForo_Input::STRING,
			'amount' => XenForo_Input::FLOAT,
			'comment' => XenForo_Input::STRING,
			'redirect' => XenForo_Input::STRING,
		));
		$redirect = ($data['redirect'] ? $data['redirect'] : $this->getDynamicRedirect());
		$link = XenForo_Link::buildPublicLink('credits/transfer');
		$visitorId = XenForo_Visitor::getInstance()->getUserId();
		$visitor = XenForo_Visitor::getInstance()->toArray();
		/* @var $userModel XenForo_Model_user */
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		$creditModel = $this->_getCreditModel();
		if (!$creditModel->requireInclude('transfer')) {
			// it shouldn't be negative because we used filter
			return $this->responseError(new XenForo_Phrase('do_not_have_permission'));
		}
		$receiver = $userModel->getUserByName($data['receiver'], array('join' => XenForo_Model_User::FETCH_USER_FULL));
		if (empty($receiver)) {
			return $this->responseError(new XenForo_Phrase('BRC_following_receiver_not_found_x', array('username' => $data['receiver'])));
		} else if ($receiver['user_id'] == $visitorId) {
			return $this->responseError(new XenForo_Phrase('BRC_transfer_self'));
		}
		
		if ($data['amount'] <= 0) {
			// it shouldn't be negative because we used filter
			return $this->responseError(new XenForo_Phrase('BRC_not_valid_amount'));
		}
		
		
		$userCredit = $visitor['credits'];
		$data['amount'] = Brivium_Credits_Currency::convert($data['amount']);
		$actionModel = $this->_getActionModel();
		$actionModel = $this->_getActionModel();
		$action = XenForo_Application::get('brcActions')->transfer;
		$action = $actionModel->getActionDataArray($action);
		if($data['amount'] <= $action['amount']){  
			return $this->responseError(new XenForo_Phrase('BRC_your_transfer_must_bigger_than_x',array('amount' => Brivium_Credits_Currency::currencyFormat($action['amount']))));
		}
		
		list($userTax, $userActionTax, $bothTax) = $creditModel->processTax( $data['amount'],$action);
		$userTaxedAmount = $data['amount'] + $userTax + $bothTax;
		$userActionTaxedAmount = $data['amount'] - $userActionTax - $bothTax;
		if ( ($userCredit - $userTaxedAmount) < 0) {
			return $this->responseError(new XenForo_Phrase('BRC_not_enough_transfer',array('amount' => Brivium_Credits_Currency::currencyFormat($userTaxedAmount))));
		}
		
		//$hash = md5(implode(',',array_keys($receivers)) . $formData['amount'] . $balanceAfter);
		$dataCredit = array(
			'user_action_id' 	=>	$receiver['user_id'],
			'amount' 			=>	-$userTaxedAmount,
			'message' 			=>	$data['comment'],
			'extraData' 		=>	array(
										'type'	=>	'sender',
										'user'	=>	$visitor,
									)
		);
		$errorString = '';
		$creditModel->updateUserCredit('transfer',$visitorId,$dataCredit,$errorString);
		if($errorString)return $this->responseError($errorString);
		$dataCredit2 = array(
			'user_action_id' 	=>	$visitorId,
			'amount' 			=>	$userActionTaxedAmount,
			'message' 			=>	$data['comment'],
			'ignoreInclude' 		=>	true,
			'extraData' 		=>	array(
										'type'	=>	'receiver',
										'user'	=>	$receiver
									)
		);
		$errorString = '';
		$creditModel->updateUserCredit('transfer',$receiver['user_id'],$dataCredit2,$errorString);
		if($errorString)return $this->responseError($errorString);
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$redirect,
			new XenForo_Phrase('BRC_transaction_processed_successfully')
		);
	}
	
	protected function _preDispatch($action)
	{
		$this->_assertRegistrationRequired();
	}
	
	protected function _getDefaultTransactionSort()
	{
		return array('transaction_date',  'desc');
	}

	protected function _getTransactionSortFields()
	{
		return array('action_id', 'transaction_date', 'user_id', 'user_action_id', 'amount');
	}
	
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	
	/**
	 * Gets the credit pages wrapper.
	 *
	 * @param string $selectedGroup
	 * @param string $selectedLink
	 * @param XenForo_ControllerResponse_View $subView
	 *
	 * @return XenForo_ControllerResponse_View
	 */
	protected function _getWrapper($selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
	{
		$creditHelper = new Brivium_Credits_ControllerHelper_Credit($this);
		return $creditHelper->getWrapper($selectedGroup, $selectedLink, $subView);
	}
	
}