<?php

class Brivium_Credits_ControllerAdmin_Credits extends XenForo_ControllerAdmin_Abstract
{
	public function actionIndex()
	{
		$limit = XenForo_Application::get('options')->BRC_memberPerTop;
		$userModel = $this->_getUserModel();
		$transactionModel = $this->_getTransactionModel();
		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0
		);
		$fetchOptions = array(
			'limit' => $limit,
			'order' => 'credits',
		);
		// richest user
		$fetchOptions['direction'] = 'desc';
		$richestUsers = $userModel->getUsers($criteria, $fetchOptions);
		
		// poorest user
		$fetchOptions['direction'] = 'asc';
		$poorestUsers = $userModel->getUsers($criteria, $fetchOptions);
		
		// top transaction in day user
		$dayStartTimestamps = XenForo_Locale::getDayStartTimestamps();
		$conditions = array(
			'start' => $dayStartTimestamps['today'],
		);
		//top in day.
		$topEarnedInDay = $transactionModel->getTopEarnedTransactions($conditions, array('limit' => $limit));
		$topSpentInDay = $transactionModel->getTopSpentTransactions($conditions, array('limit' => $limit));
		
		$topEarnedInDays = array();
		$topSpentInDays = array();
		if(is_array($topEarnedInDay) && !empty($topEarnedInDay)){
			foreach($topEarnedInDay AS $userId=>$earnInfo){
				$topEarnedInDays[$userId] = $userModel->getUserById($userId);
				$topEarnedInDays[$userId]['credits'] = $earnInfo['credits'];
			}
		}
		if(is_array($topSpentInDay) && !empty($topSpentInDay)){
			foreach($topSpentInDay AS $userId=>$spentInfo){
				$topSpentInDays[$userId] = $userModel->getUserById($userId);
				$topSpentInDays[$userId]['credits'] = $spentInfo['credits'];
			}
		}
		
		$boardTotals = $this->getModelFromCache('XenForo_Model_DataRegistry')->get('boardTotals');
		if (!$boardTotals)
		{
			$boardTotals = $this->getModelFromCache('XenForo_Model_Counters')->rebuildBoardTotalsCounter();
		}
		
		$creditModel = $this->_getCreditModel();
		$statistic['totalCredits'] 	= $creditModel->totalCredits();
		$statistic['totalUsers'] 	= $boardTotals['users'];
		
		$conditions  = array();
		$statistic['totalEarned'] 	= $transactionModel->getTotalEarnedCredits($conditions)?$transactionModel->getTotalEarnedCredits($conditions):0;
		$statistic['totalSpent'] 	= $transactionModel->getTotalSpentCredits($conditions)?$transactionModel->getTotalSpentCredits($conditions):0;
		
		$firstDay = $transactionModel->firstTimeTransactions($conditions);
		$day = (XenForo_Application::$time - $firstDay);
		if($day <= 86400){
			$day = 1;
		}else{
			$day = ($day - ($day%86400))/86400;
		}
		
		$statistic['earnedPerday'] = $statistic['totalEarned'] / $day;
		$statistic['spentPerday'] = $statistic['totalSpent'] / $day;

		$viewParams = array(
			'statistic'   => $statistic,
			'richestUsers'   => $richestUsers,
			'poorestUsers'   => $poorestUsers,
			'topSpentInDays'   => $topSpentInDays,
			'topEarnedInDays'   => $topEarnedInDays,
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Index', 'BRC_credits', $viewParams);
	}
	

	public function actionUserCredits()
	{
		$criteria = array();

		$filter = $this->_input->filterSingle('_filter', XenForo_Input::ARRAY_SIMPLE);
		if ($filter && isset($filter['value']))
		{
			$criteria['username2'] = array($filter['value'], empty($filter['prefix']) ? 'lr' : 'r');
			$filterView = true;
		}
		else
		{
			$filterView = false;
		}

		$order = $this->_input->filterSingle('order', XenForo_Input::STRING);
		$direction = $this->_input->filterSingle('direction', XenForo_Input::STRING);

		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$usersPerPage = 20;

		$fetchOptions = array(
			'perPage' => $usersPerPage,
			'page' => $page,

			'order' => $order,
			'direction' => $direction
		);

		$userModel = $this->_getUserModel();
		foreach (array('username', 'username2', 'email') AS $field)
		{
			if (isset($criteria[$field]) && is_string($criteria[$field]))
			{
				$criteria[$field] = trim($criteria[$field]);
			}
		}

		$totalUsers = $userModel->countUsers($criteria);
		if (!$totalUsers)
		{
			return $this->responseError(new XenForo_Phrase('no_users_matched_specified_criteria'));
		}

		$users = $userModel->getUsers($criteria, $fetchOptions);
		$orderDirectionEx = ($direction == 'desc' ? 'asc' : 'desc');
		
		
		
		$viewParams = array(
			'users' => $users,
			'totalUsers' => $totalUsers,
			'orderDirectionEx' => $orderDirectionEx,
			'order' => $order,
			'direction' => $direction,
			
			'linkParams' => array('criteria' => $criteria, 'order' => $order, 'direction' => $direction),
			'page' => $page,
			'usersPerPage' => $usersPerPage,

			'filterView' => $filterView,
			'filterMore' => ($filterView && $totalUsers > $usersPerPage)
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_User_List', 'BRC_user_list', $viewParams);
	}
	
	/*========================= Transactions ================================*/
	
	public function actionTransactions()
	{
		if ($this->_input->inRequest('delete_selected'))
		{
			return $this->responseReroute(__CLASS__, 'delete-transaction');
		}

		$input = $this->_getFilterParams();

		$dateInput = $this->_input->filter(array(
			'start' => XenForo_Input::DATE_TIME,
			'end' => XenForo_Input::DATE_TIME,
		));

		$transactionModel = $this->_getTransactionModel();

		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$perPage = 50;

		$pageParams = array();
		if ($input['order'])
		{
			$pageParams['order'] = $input['order'];
		}
		if ($input['start'])
		{
			$pageParams['start'] = $input['start'];
		}
		if ($input['end'])
		{
			$pageParams['end'] = $input['end'];
		}
		if ($input['action_id'])
		{
			$pageParams['action_id'] = $input['action_id'];
		}

		$userId = 0;
		if ($input['username'])
		{
			if ($user = $this->getModelFromCache('XenForo_Model_User')->getUserByName($input['username']))
			{
				$userId = $user['user_id'];
				$pageParams['username'] = $input['username'];
			}
			else
			{
				$input['username'] = '';
			}
		}

		$conditions = array(
			'action_id' => $input['action_id'],
			'user_id' => $userId,
			'start' => $dateInput['start'],
			'end' => $dateInput['end'],
		);
		$fetchOptions = array(
			'page' => $page,
			'perPage' => $perPage,
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);
		switch ($input['order'])
		{
			case 'amount':
				$fetchOptions['order'] = 'amount';
				break;

			case 'transaction_date';
			default:
				$input['order'] = 'transaction_date';
				$fetchOptions['order'] = 'transaction_date';
				break;
		}

		$transactions = $transactionModel->getTransactions($conditions, $fetchOptions);
		$transactions = $transactionModel->prepareTransactions($transactions);
		$actionModel = $this->_getActionModel();
		$actions = $actionModel->getAllActions();
		$actions = $actionModel->prepareActions($actions);
		
		$viewParams = array(
			'actions' => $actions,

			'transactions' => $transactions,

			'order' => $input['order'],
			'actionId' => $input['action_id'],
			'username' => $input['username'],
			'start' => $input['start'],
			'end' => $input['end'],

			'datePresets' => XenForo_Helper_Date::getDatePresets(),

			'page' => $page,
			'perPage' => $perPage,
			'pageParams' => $pageParams,
			'total' =>	$transactionModel->countTransactions($conditions)
		);

		return $this->responseView('XenForo_ControllerAdmin_Attachment_List', 'BRC_transaction_list', $viewParams);
	}
	
	public function actionViewTransaction()
	{
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);
		$transactionModel = $this->_getTransactionModel();
		$fetchOptions = array(
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);
		$transaction = $transactionModel->getTransactionById($transactionId,$fetchOptions);
		$viewParams = array(
			'transaction' => $transactionModel->prepareTransaction($transaction),
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_ViewTransaction', 'BRC_view_transaction', $viewParams);
	}
	
	
	public function actionSaveTransaction()
	{
		$filterParams = $this->_getFilterParams();
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('credits/transactions', null, $filterParams)
		);
	}
	
	public function actionDeleteTransaction()
	{
		$transactionModel = $this->_getTransactionModel();
		
		$filterParams = $this->_getFilterParams();

		$transactionIds = $this->_input->filterSingle('transaction_ids', array(XenForo_Input::UINT, 'array' => true));

		if ($transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT))
		{
			$transactionIds[] = $transactionId;
		}
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);

		if ($this->isConfirmedPost())
		{
			foreach ($transactionIds AS $transactionId)
			{
				$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Transaction');
				$dw->setExistingData($transactionId);
				$dw->delete();
			}
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('credits/transactions', null, $filterParams)
			);
		}
		else // show confirmation dialog
		{
			$fetchOptions = array(
				'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
			);
			$viewParams = array(
				'transactionIds' => $transactionIds,
				'filterParams' => $filterParams
			);

			if (count($transactionIds) == 1)
			{
				list($transactionId) = $transactionIds;
				$viewParams['transaction'] = $transactionModel->prepareTransaction($transactionModel->getTransactionById($transactionId,$fetchOptions));
			}
			

			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_DeleteTransaction', 'BRC_transaction_delete', $viewParams);
		}
	}
	
	
	/*========================= Action ================================*/
	
	public function actionActions()
	{
		$actionModel = $this->_getActionModel();
		$actions = $actionModel->getAllActions();
		$actions = $actionModel->prepareActions($actions);
		
		$viewParams = array(
			'actions' => $actions,
		);
		
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_ListActions', 'BRC_action_list', $viewParams);
	}
	
	
	public function _getActionAddEditResponse(array $action)
	{
		$actionModel = $this->_getActionModel();
		$addOnModel = $this->_getAddOnModel();
		$actionForums = $action['forums']?$action['forums']:array(0=>0);
		$actionUserGroups = $action['user_groups']?$action['user_groups']:array(0=>0);
		/* @var $nodeModel XenForo_Model_Node */
		$nodeModel = XenForo_Model::create('XenForo_Model_Node');
		$forums = $nodeModel->getNodeOptionsArray($nodeModel->getAllNodes(),0, sprintf('(%s)', new XenForo_Phrase('all_forums')));
		foreach ($forums AS &$node)
		{
			if (!empty($node['node_type_id']) && $node['node_type_id'] != 'Forum')
			{
				$node['disabled'] = 'disabled';
			}
			unset($node['node_type_id']);
			$node['selected'] = in_array($node['value'] , $actionForums);
		}
		
		$listUserGroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
		$userGroups[0] = array(
			'label' =>  sprintf('(%s)', new XenForo_Phrase('all_user_groups')),
			'value' => 0,
			'selected' => in_array(0 , $actionUserGroups)
		);
		foreach ($listUserGroups AS $userGroupId => $userGroup)
		{
			if($userGroupId!=0)
			$userGroups[$userGroupId] = array(
				'label' => $userGroup['title'],
				'value' => $userGroup['user_group_id'],
				'selected' => in_array($userGroup['user_group_id'] , $actionUserGroups)
			);
		}
	
		$viewParams = array(
			'action' => $action,
			'forums' => $forums,
			'userGroups' => $userGroups,
			'masterTitle' => $action['action_id']?$actionModel->getActionTitlePhraseValue($action['action_id']):'',
			'masterRevertedTitle' => $action['action_id']?$actionModel->getActionRevertedTitlePhraseValue($action['action_id']):'',
			'masterExplain' => $action['action_id']?$actionModel->getActionMasterExplainPhraseValue($action['action_id']):'',
			'addOnOptions' => $addOnModel->getAddOnOptionsListIfAvailable(),
			'addOnSelected' => (isset($action['addon_id']) ? $action['addon_id'] : $addOnModel->getDefaultAddOnId()),
			'templates' => $this->_getEditActionTemplate(),
		);
		$editTemplate = 'BRC_action_edit';
		if(!empty($action['template'])){
			$editTemplate = 'BRC_action_edit_template_'. $action['template'];
		}
		return $this->responseView('XenForo_ViewAdmin_Credits_Action',$editTemplate, $viewParams);
	}

	public function actionAddAction()
	{
		if ($this->isConfirmedPost())
		{
			$template = $this->_input->filterSingle('template', XenForo_Input::STRING);
			//if ($this->_input->inRequest('more_options'))
			//	$template = 'BRC_action_editAdvanced';
			$action = array(
				'action_id' => '',
				'forums' => array(),
				'user_groups' => array(),
				'action_id' => '',
				'active' => 1,
				'alert' => 1,
				'display_order' => 1,
				'times' => 0,
				'template' => $template,
			);
			return $this->_getActionAddEditResponse($action);
		}else // show confirmation dialog
		{
			$viewParams = array(
				'templates' => $this->_getEditActionTemplate(),
			);
			return $this->responseView('XenForo_ViewAdmin_Credits_Action','BRC_action_editChooseTemplate', $viewParams);
		}
	}
	public function actionEditAction()
	{
		$actionId = $this->_input->filterSingle('action_id', XenForo_Input::STRING);
		$actionModel = $this->_getActionModel();
		$action = $actionModel->getActionById($actionId);
		$action = $actionModel->prepareAction($action);
		
		return $this->_getActionAddEditResponse($action);
	}
	public function actionSaveAction()
	{
		$this->_assertPostOnly();
		if ($this->_input->inRequest('more_options'))
		{
			return $this->responseReroute(__CLASS__, 'add-action');
		}
		$input = $this->_input->filter(array(
			'original_action_id' => XenForo_Input::STRING,
		));

		$dwInput = $this->_input->filter(array(
			'action_id' => XenForo_Input::STRING,
			'amount' => XenForo_Input::FLOAT,
			'sub_amount' => XenForo_Input::FLOAT,
			'multiplier' => XenForo_Input::FLOAT,
			'sub_multiplier' => XenForo_Input::FLOAT,
			'times' => XenForo_Input::UINT,
			'active' => XenForo_Input::UINT,
			'alert' => XenForo_Input::UINT,
			'display_order' => XenForo_Input::UINT,
			'max_time' => XenForo_Input::UINT,
			'target' => XenForo_Input::STRING,
			'apply_max' => XenForo_Input::UINT,
			'addon_id' => XenForo_Input::STRING,
			'template' => XenForo_Input::STRING,
		));
		
		$dwInput['forums'] = $this->_input->filterSingle('forums', XenForo_Input::ARRAY_SIMPLE);
		$dwInput['user_groups'] = $this->_input->filterSingle('user_groups', XenForo_Input::ARRAY_SIMPLE);
		
		if(!$dwInput['target'])$dwInput['target'] = 'user';
		$phrase = $this->_input->filter(array(
			'title' => XenForo_Input::STRING,
			'reverted_title' => XenForo_Input::STRING,
			'explain' => XenForo_Input::STRING
		));
		$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Action');
		if ($input['original_action_id'])
		{
			$dw->setExistingData($input['original_action_id']);
		}
		//	prd($dwInput);
		$dw->bulkSet($dwInput);
		$dw->setExtraData(Brivium_Credits_DataWriter_Action::DATA_TITLE, $phrase['title']);
		$dw->setExtraData(Brivium_Credits_DataWriter_Action::DATA_REVERTED_TITLE, $phrase['reverted_title']);
		$dw->setExtraData(Brivium_Credits_DataWriter_Action::DATA_EXPLAIN, $phrase['explain']);
		$dw->updateContent();
		$dw->save();
		
		$redirectType = ($input['original_action_id']
			? XenForo_ControllerResponse_Redirect::RESOURCE_CREATED
			: XenForo_ControllerResponse_Redirect::RESOURCE_UPDATED);
		
		return $this->responseRedirect(
			$redirectType,
			XenForo_Link::buildAdminLink('credits/edit-action','', array('action_id' => $dw->get('action_id')))
		);
	}
	
	public function actionDeleteAction()
	{
		$actionModel = $this->_getActionModel();
		$actionId = $this->_input->filterSingle('action_id', XenForo_Input::STRING);

		if ($this->isConfirmedPost())
		{
			$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Action');
			$dw->setExistingData($actionId);
			$dw->delete();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('credits/actions')
			);
		}
		else // show confirmation dialog
		{
			$action = $actionModel->getActionById($actionId);
			if($action['global'])
				return $this->responseError(new XenForo_Phrase('BRC_you_cant_delete_global_action'));
			$action['title'] = $actionModel->getActionTitlePhraseValue($action['action_id']);
			$action['explain'] = $actionModel->getActionMasterExplainPhraseValue($action['action_id']);
			$viewParams = array(
				'action' => $action
			);

			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_DeleteAction', 'BRC_action_delete', $viewParams);
		}
	}
	
	public function actionSaveActionConfig()
	{
		$actions = $this->_input->filterSingle('actions', XenForo_Input::ARRAY_SIMPLE);
		foreach($actions AS $actionId=>$action){
			$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Action');
			$dw->setExistingData($actionId);
			$dw->set('amount',$action['amount']);
			if(!isset($action['active']))$action['active']=0;
				$dw->set('active',$action['active']);
			if(!isset($action['alert']))$action['alert']=0;
				$dw->set('alert',$action['alert']);
			$dw->save();
		}
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::RESOURCE_UPDATED,
			XenForo_Link::buildAdminLink('credits/actions')
		);
	}
	
	/*========================= Transfer ================================*/
	public function actionTransfer()
	{
		$creditModel = $this->_getCreditModel();
		$data = $this->_input->filter(array(
			'receiver' => XenForo_Input::STRING,
		));
		$type = 'user';
		$from = 'self';
		$listUserGroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
		foreach ($listUserGroups AS $userGroupId => $userGroup)
		{
			if($userGroupId!=0)
			$userGroups[$userGroupId] = array(
				'label' => $userGroup['title'],
				'value' => $userGroup['user_group_id'],
			);
		}
		
		$viewParams = array(
			'receiver' => $data['receiver'],
			'type' => $type,
			'from' => $from,
			'userGroups' => $userGroups,
		);

		return $this->responseView(
			'Brivium_Credits_ViewAdmin_Credits_Transfer',
			'BRC_transfer',
			$viewParams
		);
	}
	public function actionDoTransfer()
	{
		$this->_assertPostOnly();
		$data = $this->_input->filter(array(
			'type' => XenForo_Input::STRING,
			'from' => XenForo_Input::STRING,
			'user_group' => XenForo_Input::STRING,
			'receiver' => XenForo_Input::STRING,
			'amount' => XenForo_Input::FLOAT,
			'comment' => XenForo_Input::STRING,
			'redirect' => XenForo_Input::STRING,
		));
		$redirect = ($data['redirect'] ? $data['redirect'] : $this->getDynamicRedirect());
		$link = XenForo_Link::buildPublicLink('credits/transfer');
		$visitorId = XenForo_Visitor::getInstance()->getUserId();
		$visitor = XenForo_Visitor::getInstance()->toArray();
		/* @var $userModel XenForo_Model_user */
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		$userGroupModel = $this->getModelFromCache('XenForo_Model_UserGroup');
		$creditModel = $this->_getCreditModel();
		
		$data['amount'] = Brivium_Credits_Currency::convert($data['amount']);
		$actionModel = $this->_getActionModel();
		
		if($data['from'] =="self"){
			$userCredit = $visitor['credits'];
			if ( ($userCredit - $data['amount']) < 0) {
				return $this->responseError(new XenForo_Phrase('BRC_not_enough_transfer',array('amount' => Brivium_Credits_Currency::currencyFormat($data['amount']))));
			}
		}
		
		$userIds = array();
		if($data['type'] =="usergroup"){
			$users = $userGroupModel->getUserIdsInUserGroup($data['user_group']);
			if(is_array($users) && !$userIds = array_keys($users)){
				$userIds = array();
			}
		}else{
			$receiver = $userModel->getUserByName($data['receiver']);
			if (empty($receiver)) {
				return $this->responseError(new XenForo_Phrase('BRC_following_receiver_not_found_x', array('username' => $data['receiver'])));
			} else if ($receiver['user_id'] == $visitorId && $data['from'] =="self") {
				return $this->responseError(new XenForo_Phrase('BRC_transfer_self'));
			}
			$userIds[] = $receiver['user_id'];
		}
		foreach($userIds AS $userId){
			$errorString = '';
			if($data['from'] =="self"){
				$dataCredit = array(
					'user_action_id' 	=>	$userId,
					'amount' 			=>	-$data['amount'],
					'message' 			=>	$data['comment'],
					'ignoreInclude' 	=>	true,
					'extraData' 		=>	array(
											'type'	=>	'sender',
											'user'	=>	$visitor,
										)
				);
				$creditModel->updateUserCredit('transfer',$visitorId,$dataCredit,$errorString);
				if($errorString)return $this->responseError($errorString);
			}else{
				$visitorId = 0;
			}
			$dataCredit2 = array(
				'user_action_id' 	=>	$visitorId,
				'amount' 			=>	$data['amount'],
				'message' 			=>	$data['comment'],
				'ignoreInclude' 	=>	true,
				'extraData' 		=>	array('type'=>'receiver')
			);
			$creditModel->updateUserCredit('transfer',$userId,$dataCredit2,$errorString);
			if($errorString)return $this->responseError($errorString);
		}
		$viewParams = array();
		
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$redirect,
			new XenForo_Phrase('BRC_transaction_processed_successfully')
		);
	}
	
	/**
	 * Remove credits of all users.
	 *
	 */
	public function actionResetCredit()
	{
		if ($this->isConfirmedPost())
		{
			$deleteTransaction = $this->_input->filterSingle('delete_transaction', XenForo_Input::UINT);
			$amount = $this->_input->filterSingle('amount', XenForo_Input::UINT);
			$creditModel = $this->_getCreditModel();
			$creditModel->resetCredit($amount);
			$transactionModel = $this->_getTransactionModel();
			if($deleteTransaction){
				$transactionModel->deleteAllTransaction();
			}
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('credits'),
				new XenForo_Phrase('BRC_transaction_processed_successfully')
			);
		}
		else
		{
			$viewParams = array(
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_ResetCredit', 'BRC_reset_credit', $viewParams);
		}
		
	}
	/*========================= Import Export ================================*/
	public function actionImportCredits(){
		$importBdBank = false;
		$bdBankAddon = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('bdbank');
		if ($bdBankAddon) {
			$importBdBank = true;
        }
		$importMyPoints = false;
		$myPointsAddon = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('bdbank');
		if ($myPointsAddon) {
			$importMyPoints = true;
        }
		$viewParams = array(
			'importBdBank' => $importBdBank,
			'importMyPoints' => $importMyPoints,
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import', 'BRC_import_credits', $viewParams);
	}
	/**
	 * Import money from BdBanking to credits
	 *
	 */
	public function actionImportTrophyPoints()
	{
		if ($this->isConfirmedPost())
		{
			$userModel = $this->_getUserModel();
			$users = $userModel->getUsers(array());
			$creditModel = $this->_getCreditModel();
			$type = $this->_input->filterSingle('type', XenForo_Input::UINT);
			$removeTrophyPoints = $this->_input->filterSingle('remove_trophy_points', XenForo_Input::UINT);
			$merge = true;
			if($type !='merge'){
				$merge = false;
			}
			$creditModel->importCredits('trophy_points',$merge);
			if($removeTrophyPoints)$creditModel->resetTrophyPoints();
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array(
				'type' => 'merge',
				'trophyPoints' => true
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import_TrophyPoints', 'BRC_confirm_import_credits', $viewParams);
		}
		
	}/**
	 * Import money from BdBanking to credits
	 *
	 */
	public function actionImportMyPoints()
	{
		if ($this->isConfirmedPost())
		{
			$creditModel = $this->_getCreditModel();
			$type = $this->_input->filterSingle('type', XenForo_Input::UINT);
			$myPoints = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('myPoints');
			if (!$myPoints) {
				return $this->responseError('MyPoints Addon required');
			}
			$merge = true;
			if($type !='merge'){
				$merge = false;
			}
			
			$creditModel->importCredits('mypoints_currency',$merge);
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array(
				'type' => 'merge'
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import_MyPoints', 'BRC_confirm_import_credits', $viewParams);
		}
		
	}
	/**
	 * Import money from BdBanking to credits
	 *
	 */
	public function actionImportBdBanking()
	{
		if ($this->isConfirmedPost())
		{
			$userModel = $this->_getUserModel();
			$users = $userModel->getUsers(array());
			$bdBankAddon = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('bdbank');
			if (!$bdBankAddon) {
				return $this->responseError('[bd] Banking Addon required');
			}
			$bdbankField = XenForo_Application::get("options")->bdbank_field;
			$creditModel = $this->_getCreditModel();
			$creditModel->importCredits($bdbankField,$merge);
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array(
				'type' => 'merge'
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import_MyPoints', 'BRC_confirm_import_credits', $viewParams);
		}
	}
	
	public function actionActionExport()
	{
		if ($this->isConfirmedPost())
		{
			$input = $this->_input->filter(array(
				'addon_id' => XenForo_Input::STRING,
			));

			$this->_routeMatch->setResponseType('xml');

			$addOnId = ($input['addon_id'] ? $input['addon_id'] : null);

			$viewParams = array(
				'addOnId' => $addOnId,
				'xml' => $this->_getActionModel()->getActionXml($addOnId)
			);

			return $this->responseView('Brivium_Credits_ViewAdmin_Action_ExportXml', '', $viewParams);
		}
		else
		{
			$viewParams = array(
				'addOnOptions' => $this->getModelFromCache('XenForo_Model_AddOn')->getAddOnOptionsList(false, true)
			);

			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Action_Export', 'BRC_action_export', $viewParams);
		}
	}

	public function actionActionImport()
	{
		$actionModel = $this->_getActionModel();

		if ($this->isConfirmedPost())
		{
			$upload = XenForo_Upload::getUploadedFile('upload');
			if (!$upload)
			{
				return $this->responseError(new XenForo_Phrase('please_upload_valid_language_xml_file'));
			}

			$document = $this->getHelper('Xml')->getXmlFromFile($upload);
			$caches = $actionModel->importActionsXml($document);
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array();
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Action_Import', 'BRC_action_import');
		}
	}

	
	protected function _getEditActionTemplate()
	{
		$allActionTemplates = $this->_getAdminTemplateModel()->getAdminTemplatesForAdminQuickSearch('BRC_action_edit_template_');
		$templates = array();
		$templates[] = 'BRC_action_edit';
		foreach($allActionTemplates AS $key=>&$template){
			if($pos = strpos($template['title'], 'BRC_action_edit_template_')!= 1){
				$templateName = substr($template['title'] , ($pos+24));
				$templates[$templateName] = $template['title'];
			}
		}
		return $templates;
	}
	
	
	protected function _getFilterParams()
	{
		return $this->_input->filter(array(
			'order' => XenForo_Input::STRING,
			'action_id' => XenForo_Input::STRING,
			'username' => XenForo_Input::STRING,
			'start' => XenForo_Input::STRING,
			'end' => XenForo_Input::STRING
		));
	}
	
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	/**
	 * @return XenForo_Model_AddOn
	 */
	protected function _getAddOnModel()
	{
		return $this->getModelFromCache('XenForo_Model_AddOn');
	}
	
	/**
	 * Gets the admin template model.
	 *
	 * @return XenForo_Model_AdminTemplate
	 */
	protected function _getAdminTemplateModel()
	{
		return $this->getModelFromCache('XenForo_Model_AdminTemplate');
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	
}