<?php /*
Plugin Name: Uber Grid
Plugin URI: http://codecanyon.net
Description: Powerful grid plugin for WordPress
Author: Nikolay Karev
Version: 1.5.2
Author URI: mailto: karev.n@gmail.com
*/

define('UBERGRID_MAIN', __FILE__);
define('UBERGRID_REQUIRED_WP', '3.5');
define('UBERGRID_PATH', dirname(__FILE__) . "/");
define('UBERGRID_URL', plugins_url('uber-grid') . "/");
define('UBERGRID_VERSION', '1.5.2');
define('UBERGRID_POST_TYPE', 'uber-grid');

require('functions.php');
require('post-types.php');
require('grid.class.php');
require('cell.class.php');
require('cell-template.class.php');
require(UBERGRID_PATH . 'widgets.php');
require(UBERGRID_PATH . "wpthumb.class.php");
if (!is_admin()){
	if (uber_grid_requirements_met()){
		require('shortcodes.php');
	}
} else {
	require('admin/diagnostics.php');
	if (uber_grid_requirements_met()){
		require('updater.php');
		require('ajax.php');
		require('admin/grid-editor.php');
		require('admin/grid-list.php');
		require('admin/settings.php');
		require('admin/pointers.php');
	}
}