<?php
	
function uber_grid_array_insert(&$input, $offset, $element, $key = null){
	if ($key == null)
		$key = $offset;
	if ($offset > count($input))
		$offset = count($input);
	else if ($offset < 0)
		$offset = 0;
	$input = array_merge(array_slice($input, 0, $offset), array($key => $element), array_slice($input, $offset));
}

function uber_grid_hex2rgba($hex, $opacity = 1){
	if (empty($hex))
		return 'transparent';
	$hex = preg_replace("/^#/", "", trim($hex));
	$color = array();
	if(strlen($hex) == 3) {
		$color['r'] = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
		$color['g'] = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
		$color['b'] = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
	}
	else if(strlen($hex) == 6) {
		$color['r'] = hexdec(substr($hex, 0, 2));
		$color['g'] = hexdec(substr($hex, 2, 2));
		$color['b'] = hexdec(substr($hex, 4, 2));
	}
	return "rgba(" . implode(', ', $color) . ", " . $opacity . ")";
}

function uber_grid_color($hex, $opacity = 1){
	$hex = strtolower($hex);
	if ((float)$opacity < 1.0)
		return uber_grid_hex2rgba($hex, $opacity);
	if (preg_match("/^#(\d|[abcdef]){3,6}$/i", $hex))
		return $hex;
	if (preg_match("/^(\d|[abcdef]){3,6}$/i", $hex))
		return "#" . $hex;
		if ('transparent' == $hex)
			return $hex;
	return null;
}

function uber_grid_requirements_met(){
	global $wp_version;
	return version_compare($wp_version, UBERGRID_REQUIRED_WP, ">=");
}