<?php

class UberGrid_Cell {
	var $layout = 'r1c1-io';
	var $title = 'Title';
	var $title_color = '#FFFFFF';
	var $title_background_color = '#ff6760';
	var $title_background_image;
	var $title_position = 'center';
	var $tagline = 'Tagline';
	var $tagline_color = '#FFFFFF';
	
	var $tags;

	var $image;
	
	var $link_enable;
	var $link_url;
	var $link_rel;
	var $link_target;
	
	var $link_mode;
	var $lightbox_image;
	var $lightbox_title;
	var $lightbox_text;
	
	var $background_image;
	var $background_color;
	
	var $hover_enable;
	var $hover_title;
	var $hover_text;
	var $hover_text_color = '#FFFFFF';
	var $hover_background_image;
	var $hover_background_color;
	var $hover_hide_arrow = false;
	
	
	
	var $label_enable;
	var $label_title;
	var $label_tagline;
	var $label_title_color = '#FFFFFF';
	var $label_tagline_color = '#FFFFFF';
	var $label_background_color;
	var $label_price;
	var $label_price_color = "#FFFFFF";
	var $label_price_background_color = "#ff6760";
	
	var $lightbox_facebook;
	var $lightbox_twitter;
	var $lightbox_email;
	var $lightbox_linkedin;
	var $lightbox_skype;
	var $lightbox_pinterest;
	var $lightbox_googleplus;
	var $lightbox_flickr;
	var $lightbox_website;
	var $lightbox_dribbble;
	
	function __construct($data = null){
		if ($data){
			$this->assign($data);
		}
	}
	
	function assign($data){
		foreach ( UberGrid_Cell::get_cell_fields() as $name){
			 $this->$name = isset($data[$name]) ? $data[$name] : null;
		 };
	}
	
	static function get_cell_fields(){
		$class = new ReflectionClass('UberGrid_Cell');
		$props = array();
		foreach($class->getProperties(ReflectionProperty::IS_PUBLIC) as $prop){
			$props []= $prop->getName();
		}
		return $props;
	}
	
	function setImage($id){
		$this->image = $id;
	}
	
	function get_image_width($grid){
		if ($this->get_image_columns() == 2)
			return $grid->get_2x_width();
		return $grid->cell_width;
	}
	
	function get_image_height($grid){
		if ($this->get_image_rows() == 2)
			return $grid->get_2x_height();
		return $grid->cell_height;
	}
	
	function getImageSrc($grid){
		$width = $this->get_image_width($grid);
		$height = $this->get_image_height($grid);
		$size = "uber-grid-{$width}x{$height}";
		$img = wp_get_attachment_image_src($this->image, $size);
		return $img[0];
	}
	
	function getBackgroundImageSrc(){
		$img = wp_get_attachment_image_src($this->background_image, 'original');
		return $img[0];
	}
	
	function getTitleBackgroundImageSrc(){
		$img = wp_get_attachment_image_src($this->title_background_image, 'original');
		return $img[0];
	}
	
	
	function getHoverBackgroundImageSrc(){
		$img = wp_get_attachment_image_src($this->hover_background_image, 'original');
		return $img[0];
	}
	
	function getLightboxImageSrc(){
		$img = wp_get_attachment_image_src($this->lightbox_image, 'original');
		return $img[0];
	}
	
	function get_image_columns(){
		$columns = array(
			'r1c1-io' => 1,
			'r2c2-io' => 2,
			'r1c2-il' => 1,
			'r1c2-ir' => 1,
			'r2c2-il' => 1,
			'r2c2-ir' => 1,
			'r2c2-it' => 2,
			'r2c2-ib' => 2,
			'r1c2-io' => 2,
			'r2c1-it' => 1,
			'r2c1-ib' => 1,
			'r2c1-io' => 1
		);
		return $columns[$this->layout];
	}
	
	function get_image_rows(){
		$rows = array(
			'r1c1-io' => 1,
			'r2c2-io' => 2,
			'r1c2-il' => 1,
			'r1c2-ir' => 1,
			'r2c2-il' => 2,
			'r2c2-ir' => 2,
			'r2c2-it' => 1,
			'r2c2-ib' => 1,
			'r1c2-io' => 1,
			'r2c1-it' => 1,
			'r2c1-ib' => 1,
			'r2c1-io' => 1
		);
		return $rows[$this->layout];
	}
	
	function get_link_rel(){
		if ($this->link_mode == 'url' && $this->link_rel)
			return $this->format_attribute('rel', $this->link_rel);
		if ($this->link_mode == 'lightbox'){
			return $this->format_attribute('rel', 'uber-grid-lightbox');
		}
		return '';
	}
	function get_link_target(){
		if ($this->link_mode == 'url' && $this->link_target)
			return $this->format_attribute('target', $this->link_target);
		return '';
	}
	function format_attribute($name, $value){
		return "$name=\"" . esc_attr($value) . "\" ";
	}
	
	function get_link_url(){
		if ($this->link_mode == 'url'){
			return $this->link_url;
		}
		if ($this->lightbox_image){
			return $this->getLightboxImageSrc();
		}
		if ($this->link_url)
			return $this->link_url;
		return "#";
	}
	
	function get_rows(){
		return str_replace('r', '', preg_replace('/c.*$/', '', $this->layout));
	}
	function get_columns(){
		return preg_replace('/[^\d]+$/', '', preg_replace('/^r\d+c/', '', $this->layout));
	}
	
	function imageOnly(){
		return preg_match('/-io$/', $this->layout);
	}
	
	function imageLocation(){
		return preg_replace('/.*\-/', '', $this->layout);
	}
	
}