<?php
require_once(ABSPATH . "wp-admin/includes/image.php");
class UberGrid_CellTemplate extends UberGrid_Cell{
	var $current_post;
	
	function __construct($data = null){
		$this->title = "%post_title%";
		$this->link_enable = 1;
		$this->link_mode = 'link';
		$this->link_url = "%post_permalink%";
		parent::__construct();
		if ($data)
			$this->assign($data);
	}
	
	function build_cell($post, $options = array()){
		$data = array();
		foreach(UberGrid_Cell::get_cell_fields() as $field){
			if (!preg_match('/_enable$/', $field))
				$data[$field] = $this->do_tags($this->$field, $post);
			else
				$data[$field] = $this->$field;
		}
		if (isset($options['generate_thumbnail']) && $options['generate_thumbnail'] && !(int)$data['image'] && $thumbnail = get_post_thumbnail_id($post->ID)){
			if (!in_array((int)$options['width'], get_post_meta($thumbnail, '_ubergrid_cell_width')) ||
			!in_array((int)$options['height'], get_post_meta($thumbnail, '_ubergrid_cell_height'))){
				$this->generate_thumbnail($thumbnail, $options['width'], $options['height']);
			}
			$data['image'] = $thumbnail;
		}
		return new UberGrid_Cell($data);
	}
	
	function generate_thumbnail($thumbnail, $width, $height){
		wp_update_attachment_metadata($thumbnail, wp_generate_attachment_metadata($thumbnail, get_attached_file($thumbnail)));
		add_post_meta($thumbnail, '_ubergrid_cell_width', $width);
		add_post_meta($thumbnail, '_ubergrid_cell_height', $height);
	}
	
	function do_tags($value, $post){
		$this->current_post = $post;
		$value = str_replace('%post_title%', $post->post_title, $value);
		$value = str_replace('%post_excerpt%', $post->post_excerpt, $value);
		$value = str_replace('%post_ID%', $post->post_ID, $value);
		$value = str_replace('%post_permalink%', get_permalink($post->ID), $value);
		$value = preg_replace_callback("/%post_meta_([^%]+)%/", array($this, 'do_replace'), $value);
		return $value;
	}
	
	function do_replace($matches){
		return get_post_meta($this->current_post->ID, $matches[1], true);
	}
	
}