if (!jQuery)
	alert('Message from UberGrid: jQuery not found!');
else if (parseInt(jQuery().jquery.replace(/\./g, '')) < 172){
	alert('Message from UberGrid You have jQuery < 1.7.2. Please upgrade your jQuery or enable "Force new jQuery version" option at UberGrid settings page.');
} else {
	jQuery(function($){
		$('.uber-grid-wrapper').each(function(){
			new UberGrid($(this));
		});
		function UberGrid($grid){
			var inner = $grid.find('> .uber-grid');
			new Packery(inner[0]);
			var cells = [];
			var resizeTimeout = null;
			if (!inner.hasClass('uber-grid-forced-width') || true){
				$(window).resize(function(){
					updateGridWidth();
				});
			}
			function updateGridWidth(){
				var w = $(inner.find('li.r1c1, li.r2c1'));
				var width;
				if (w.size() == 0){
					w = $(inner).find('li.r2c2, li.r1c2');
					if (w.size() == 0)
						return;
					var cellWidth = parseInt($(w[0]).width() / 2);
					var cellBorder = parseInt($(w[0]).css('border-width'));
					var cellGap = parseInt($(w[0]).css('margin-right'));
					var columns = Math.floor(($grid.width()) / (cellWidth + cellGap * 2 + 2 * cellBorder));
					width = columns * (cellWidth + cellBorder * 2 + cellGap * 2);
					
				} else {
					var cellWidth = parseInt($(w[0]).width());
					var cellBorder = parseInt($(w[0]).css('border-width'));
					var cellGap = parseInt($(w[0]).css('margin-right'));
					var columns = Math.floor(($grid.width()) / (cellWidth + cellGap * 2 + 2 * cellBorder));
					width = columns * (cellWidth + cellBorder * 2 + cellGap * 2);
				}
				inner.css('width', width);
			}
			$(window).resize();
			inner.find(">li").each(function(){cells.push(new UberGridCell($(this)));});
			$grid.find('ul.uber-grid-filters li:first-child').addClass('active');
			$grid.find('ul.uber-grid-filters li a').click(function(){
				$('ul.uber-grid-filters li').removeClass('active');
				var a = $(this);
				a.parent().addClass('active');
				tag = a.attr('href').replace(/^#/, '');
				if (tag == ''){
					$.each(cells, function(index, cell){cell.show();})
				} else {
					$.each(cells, function(index, cell){
						if (cell.hasTag(tag))
							cell.show();
						else
							cell.blur();
					});
				}
				return false;
			});
			var masterPopupSettings = {gallery: {enabled: true, navigateByImgClick: true, preload: [1,1]}, closeBtnInside: true, mainClass: 'mfp-fade'};
			var items = inner.find('a[rel=uber-grid-lightbox]');
			items.each(function(index, item){
				$(item).click(function(){$.magnificPopup.open($.extend(masterPopupSettings, {
					items: $.map(items, function(item){
						function isImage(){return item.attr('href').match(/(\.jpe?g|\.png|\.gif)$/i);}
						function isInline(){return item.attr('href').match(/^#/);}
						item = $(item);
						var settings = {src: item.attr('href')};
						if (isInline()){
							settings.type = 'inline';
							if (settings.src == '#'){
								settings.src = $(item.closest('li').find('.uber-grid-lightbox').html());
							}
						} else if (isImage()){
							settings.type = 'image';
						} else{
							settings.type = 'iframe';
						}
						settings.ubergridCell = $(item).closest('li');
						return settings;
					}),
					image: {
						titleSrc: function(){
							if (this.currItem.data.ubergridCell.find('.uber-grid-lightbox').size())
								return this.currItem.data.ubergridCell.find('.uber-grid-lightbox').html();
							return '';
						}
					}
					, callbacks: {
						open: function(){
							$('.mfp-wrap').addClass('mfp-uber-grid');
							
						},
						markupParse: function(template){
							template.find('.mfp-counter').remove();
						}
					},}), index);
				return false;
			});
		});
						
		}
		
		function UberGridCell($cell){
			var self = this;
			var showTimeout = null;
			var hideTimeout = null;
			var description = $cell.find('.uber-grid-cell-description');
$.extend(self, {
				hasTag: function(tag){
					tags = $.map($cell.attr('data-tags').split(','), function(tag){return tag.replace(/\s+$/, '').replace(/^\s+/, '');});
					for(var i = 0; i < tags.length; i++)
						if(tag == tags[i])
							return true;
					return false;
				}
			, show: function(){
				$cell.find('.uber-grid-blur').fadeOut('fast', function(){$(this).remove();});
			}, blur: function(){
				$blur = $cell.find('.uber-grid-blur');
				if ($blur.size() == 0)
					$blur = $('<div class="uber-grid-blur" />').appendTo($cell);
				$blur.fadeIn('fast');
			}});
		}
		window.UberGrid = UberGrid;
	});
}