jQuery(function($){
	var manualEditor;
	var autoEditor;
	
	$('#post').submit(function(){
		$(this).parent().find('.spinner').show();
	});
	
	function ImageSelector(view){
		var self = this;
		view = $(view);
		view.find('button.select-image').click(function(e){
			e.preventDefault();
			var self = this;
			var flow = wp.media({
				//Title of media manager frame
				title: "Select an image",
				library: {
					type: 'image'
				},
				button: {
					//Button text
					text: "Select Image"
				},
				//Do not allow multiple files, if you want multiple, set true
				multiple: false
			}).open();
			flow.state().set('display', false);
			flow.state().on('select', function(el){
				var selection = this.get('selection').single();
				setImageField(selection.id);
				loadNewImage(selection);
			});
		
			//console.info(wp.media.editor.open('test', {multiple: false}));
			function setImageField(selection){
				view.find('input').val(selection);
			}
		
			function loadNewImage(selection){
				var img = $(self).closest('.image-selector').find('img');
				if (img.size() == 0)
					img = $('<img />').prependTo($(self).closest('.image-selector'));
				img.attr('src', selection.attributes.url);
				img.attr('class', 'r1c1');
				view.find('.image-delete').fadeIn('fast');
				view.find('.actions-wrapper, .overlay').fadeOut('fast');
				function getCurrentLayout(){
					var layouts = {
						'r1c1-io': 'r1c1',
						'r1c2-ir': 'r1c1',
						'r1c2-il': 'r1c1',
						'r2c1-it': 'r1c1',
						'r2c1-ib': 'r1c1',
						'r2c2-io': 'r2c2',
						'r2c2-it': 'r1c2',
						'r2c2-ib': 'r1c2',
						'r2c2-il': 'r2c1',
						'r2c2-ir': 'r2c1',
						'r1c2-io': 'r1c2',
						'r2c1-io': 'r2c1'
					}
					return layouts[view.closest('li').find('.cell-layout input').val()];
				}
				$.post(selection.url, {action: 'uber_grid_generate_thumbnail', id: selection.id, format: getCurrentLayout()}, function(response){
					console.info(response);
					if (response.url){
						img.attr('src', response.url);
					}
				});
			}
			return false;
		});
		view.hover(function(){
			if(view.find('img').size() > 0){
				view.find('.actions-wrapper, .overlay').fadeIn('fast');
			}
		}, function(){
			if (view.find('img').size() > 0){
				view.find('.actions-wrapper, .overlay').fadeOut('fast');
			}
		});
		view.find('.image-delete').click(function(){
			view.find('img').remove();
			view.find('input').val('');
			view.find('.actions-wrapper, .overlay').fadeIn('fast');
			view.find('.image-delete, .overlay').fadeOut('fast');
			return false;
		});
		if (view.find('img').size() > 0){
			view.find('.actions-wrapper, .overlay').fadeOut('fast');
		}
	}
	
	function renameCellInputs(){
		$('#cells .cell').each(function(index, cell){
			$(cell).find('*:input').each(function(inputIndex, input){
				var name = $(input).attr('name');
				if (name)
						$(input).attr('name', name.replace(/^cells\[\d*\]/, "cells[" + index + "]"));
			});
		});
	}
	
	function Cell(view, options){
		var self = this;
		var view = $(view);
		var currentClass;
		var colorPickersInitialized = false;
		options = $.extend({pickerOnCreate: false}, options);
		function getCurrentLayout(){
			var layouts = {
				'r1c1-io': 'r1c1',
				'r1c2-ir': 'r1c1',
				'r1c2-il': 'r1c1',
				'r2c1-it': 'r1c1',
				'r2c1-ib': 'r1c1',
				'r2c2-io': 'r2c2',
				'r2c2-it': 'r1c2',
				'r2c2-ib': 'r1c2',
				'r2c2-il': 'r2c1',
				'r2c2-ir': 'r2c1',
				'r1c2-io': 'r1c2',
				'r2c1-io': 'r2c1'
			}
			return layouts[view.find('.cell-layout input').val()];
		}
		function reloadImages(){
			var ids = [];
			var inputs = view.find('.image-selector input')
			inputs.each(function(index, el){
				if ($(el).val())
					ids.push($(el).val());
			});
			$.post('admin-ajax.php?action=uber_grid_reload_images', {ids: ids.join(','), layout: getCurrentLayout()}, function(response){
				inputs.each(function(index, el){
					$(el).parent().find('img').attr('src', response.srcs[index]);
				});
			});
		}
		view.find('.cell-title input.cell-title-editor').keyup(function(){
			var text = $(this).val();
			if (text){
				view.find('h3 .heading').text(text);
			} else {
				var i = -1;
				$('#cells > li').each(function(index, element){
					if (element == $(this).closest('li')[0])
					i = index;
				});
				view.find('h3 .heading').html("Cell " + i);
			}
		});
		self.toggle = function(callback){
			view.find("> .cell-content").toggle(callback);
			view.toggleClass('expanded');
		}
		view.find('h3').on('click', function(){
			initPickers();
			self.toggle();
		});
		function initPickers(){
			if (!colorPickersInitialized){
				view.find('.color-picker').wpColorPicker();
				colorPickersInitialized = true;
			}
		}
		if (options.pickerOnCreate)
			initPickers();
		view.find('.image-selector').each(function(index, el){
			new ImageSelector(el);
		});

		view.find('.cell-delete').click(function(){
			if (confirm('Are you sure you want to delete it?'))
				view.fadeOut('fast', function(){$(this).remove(); renameCellInputs();});
		});
		view.find('.cell-cancel').click(function(){
			view.find('> .cell-content').toggle();
			$(this).closest('li').toggleClass('expanded');
		});
		view.find('label.huge :checkbox').each(function(index, el){
			if (!$(el).is(':checked'))
				$(el).parent().parent().find('.column-1, .columns-2').hide();
		}).click(function(){
			$(this).parent().parent().find('.column-1, .columns-2').toggle();
		});
		view.find('.cell-layout li').click(function(){
			view.find('.cell-layout li').removeClass('selected');
			$(this).addClass('selected');
			view.find('.cell-layout input').val($(this).attr('class').split(/\s+/)[0]);
			view.removeClass(currentClass);
			view.addClass(currentClass = getCurrentLayout());
			reloadImages();
		});
		view.find('.select-link-mode').change(linkModeChanged);
		function linkModeChanged(){
			var mode = view.find('.select-link-mode').val()
			view.find('.select-link-mode').parent().parent().parent().find('.link-to-url, .link-to-lightbox').hide();
			view.find('.select-link-mode').parent().parent().parent().find('.link-to-' + mode ).show();
		}
		linkModeChanged();
		view.find('.cell-clone').click(function(){
			var clone = view.clone();
			// Reset selected values
			clone.removeClass('expanded').find('.cell-content').hide();
			
			clone.find('.color-picker').show().removeClass('wp-color-picker');
			clone.find('.wp-picker-container a, .wp-picker-container input[type=button], .wp-picker-holder').remove();
			clone.find('.wp-picker-container input[type=text]').unwrap().unwrap();
			view.parent().append(clone);
			clone.find('select, textarea').each(function(index, element){$(element).val($(view.find('select, textarea')[index]).val());});
			renameCellInputs();
			new Cell(clone);
			return false;
		});
		view.find('.cell-layout li').removeClass('selected');
		if (view.find('.cell-layout input').val()){
			view.find('.cell-layout li.' + view.find('.cell-layout input').val()).addClass('selected');
		}
		view.find('.section.expandable label.huge').on('click', function(event){
			$(this).parent().find('.columns-2, .column-1').toggle();
			$(this).parent().toggleClass('expanded');
		});
		view.addClass(currentClass = getCurrentLayout());
	}
	
	function ManualEditor(){
		var wasVisible = false;
		$('#add-new-cell').click(function(){
			$('#cells').append(cell = $('#cell-template .cell').clone());
			cell.find('.cell-title input.cell-title-editor').val("Cell " + ($('#cells .cell').size()));
			cell.find('>h3 .heading').text(cell.find('.cell-title input.cell-title-editor').val());
			(new Cell(cell, {pickerOnCreate: true})).toggle(function(){
				if ($('.cell').size() > 2)
					$(document).scrollTo(cell, {offset: -100, duration: 400});
			});
			renameCellInputs();
			return false;
		});
		renameCellInputs();
		this.show = function(){
			$('#manual-mode').addClass('active');
			if (!wasVisible){
				$('#manual-mode #cells .cell').each(function(index, item){new Cell(item)});
				$('#cells').sortable({update: renameCellInputs});
			}
			wasVisible = true;
		}
		this.hide = function(){
			$('#manual-mode').removeClass('active');
		}
		this.append = function(cells){
			$('#cells').append(cells)
			renameCellInputs();
			cells.each(function(index, cell){
				new Cell($(cell));
			});
		}
	}
	
	function AutoEditor(){
		var $taxFilters = $('#taxonomy-filters')
		var $customFilters = $('#custom-field-filters');
		$taxFilters.find('button').click(function(){$(this).closest('li').remove(); return false;});
		$customFilters.find('button').click(function(){$(this).closest('li').remove(); return false;});
		$('#add-taxonomy-filter').click(function(){
			$('#taxonomy-filter-template li').clone().appendTo($taxFilters.find('ul')).find('button').click(function(){$(this).closest('li').remove(); return false;});
			return false;
		});
		$('#add-custom-field-filter').click(function(){
			$('#custom-field-filter-template li').clone().appendTo($customFilters.find('ul')).find('button').click(function(){$(this).closest('li').remove(); return false;});
			return false;
		});
		new Cell($('#auto-cell-template'), {pickerOnCreate: true});
		this.show = function(){
			$('#auto-mode').addClass('active');
		}
		this.hide = function(){
			$('#auto-mode').removeClass('active');
		}
		$('#build-now').click(function(event){
			event.preventDefault();
			var spinner = $(this).parent().find('.spinner');
			spinner.css('display', 'inline-block');
			$.post('admin-ajax.php?action=uber_grid_build_cells', {data: $('#post').serialize()}, function(response){
				spinner.css('display', 'none');
				response = $(response);
				
				if (manualEditor)
					manualEditor.append(response);
				else{
					$('#cells').append(response);
					renameCellInputs();
				}

				$('#enable-manual-mode').click();
			});
		});
	}
	
	
	$('#preview').click(function(){
		showPreviewWindow();
		function showPreviewWindow(){
			$('#preview-backdrop, #preview-window').show().show();
				$.post('admin-ajax.php?action=uber_grid_preview', {data: $('#post').serialize()}, function(response){
					$('#preview-content').html(response);
				});
			$('#preview-close, #preview-footer-close').click(function(){
				$('#preview-backdrop, #preview-window').hide();
			});
		}
	});
	
		
	$.post('admin-ajax.php?action=uber_grid_get_fonts', function(response){
		if (response.error){
			$('#grid_fonts #fonts').remove();
			$('#grid_fonts .spin-wrapper').remove();
			$('#grid_fonts .inside').append('<div class="error">Error loading fonts</div>');
			return;
		}
		$('#fonts-loaded').val(1);
		$.each(response.items, function(index, item){
			var option = $('<option/>').text(item.family);
			$('#grid_fonts select[role=font]').append(option);
		});
		$('#grid_fonts select[role=font]').each(function(index, element){
			$(element).find('option').each(function(index, option){
				if ($(option).text() == $(element).attr('data-font')){
					$(option).attr('selected', 'selected');
				}
			});
		});
		$('#grid_fonts select[role=style]').each(function(index, element){
			updateStylesAvailable($(element));
			$(element).find('option').each(function(index, option){
				if ($(option).text() == $(element).attr('data-font')){
					$(option).attr('selected', 'selected');
				}
			});
		});
		$('#grid_fonts select[role=font]').change(function(){
			updateStylesAvailable($(this).next());
		});
		$('#grid_fonts .spin-wrapper').animate({opacity: 0}, function(){$(this).remove(); $('#grid_fonts #fonts').animate({opacity: 1});});
		
		
		function updateStylesAvailable(element){
			var font = $(element).prev().val();
			element.find('option').remove();
			var variantFound = false;
			$.each(response.items, function(index, item){
				if (item.family == font){
					$.each(item.variants, function(index, variant){
						element.append($('<option />').text(variant));
					});
					variantFound = true;
				}
			});
			if (!variantFound){
				element.append($("<option value='light'>Light</option>"));
				element.append($("<option value='regular' selected='selected'>Regular</option>"));
				element.append($("<option value='bold'>Bold</option>"));
			};
		}
	});
	
	manualEditor = new ManualEditor();
	autoEditor = new AutoEditor();
	if ($('#current-mode').val() == 'auto'){
		autoEditor.show();
	} else {
		manualEditor.show();
	}
	$('#enable-manual-mode').click(function(){
		$('#enable-auto-mode').removeClass('nav-tab-active');
		$(this).addClass('nav-tab-active');
		$('#current-mode').val('manual');
		manualEditor.show();
		autoEditor.hide();
	});
	$('#enable-auto-mode').click(function(){
		$('#enable-manual-mode').removeClass('nav-tab-active');
		$('#manual-mode').removeClass('active');
		$(this).addClass('nav-tab-active');
		$('#auto-mode').addClass('active');
		$('#current-mode').val('auto');
		manualEditor.hide();
		autoEditor.show();
	});
})