<div class="section cell-title">
	<label class="huge"><?php _e('Main', 'uber-grid')?></label>
	<div class="columns-2">
		<div class="column">
			<div class="field">
				<label><?php _e('Title', 'uber-grid')?></label>
				<input type="text" name="<?php echo $name_prefix ?>[title]" placeholder="<?php _e('Title', 'uber-grid') ?>" class="cell-title-editor" value="<?php echo esc_attr($cell->title)?>">
				<input type="text" name="<?php echo $name_prefix ?>[title_color]" value="<?php echo $cell->title_color ?>" class="color-picker">
			</div>
			<div class="field">
				<input type="text" name="<?php echo $name_prefix ?>[tagline]" placeholder="<?php _e('Tagline', 'uber-grid') ?>" class="full-width" value="<?php echo esc_attr($cell->tagline) ?>">
				<input type="text" name="<?php echo $name_prefix ?>[tagline_color]" value="<?php echo $cell->tagline_color ?>" class="color-picker">
			</div>
			
			<div class="field">
				<label><?php _e('Title / Tagline position')?></label>
				<select name="<?php echo $name_prefix ?>[title_position]">
					<option value="" <?php selected('', $cell->title_position)?>><?php _e('Do not show', 'uber-grid')?></option>
					<option value="center" <?php selected('center', $cell->title_position)?>><?php _e('Center', 'uber-grid')?></option>
					<option value="top-center" <?php selected('top-center', $cell->title_position)?>><?php _e('Top center', 'uber-grid')?></option>
					<option value="top-left" <?php selected('top-left', $cell->title_position)?>><?php _e('Top left', 'uber-grid')?></option>
					<option value="top-right" <?php selected('top-right', $cell->title_position)?>><?php _e('Top right', 'uber-grid')?></option>
					<option value="bottom-center" <?php selected('bottom-center', $cell->title_position)?>><?php _e('Bottom center', 'uber-grid')?></option>
					<option value="bottom-left" <?php selected('bottom-left', $cell->title_position)?>><?php _e('Bottom left', 'uber-grid')?></option>
					<option value="bottom-right" <?php selected('bottom-right', $cell->title_position)?>><?php _e('Bottom right', 'uber-grid')?></option>
					<option value="top-left-bottom-left" <?php selected('top-left-bottom-left', $cell->title_position)?>><?php _e('Top left - bottom left', 'uber-grid')?></option>
					<option value="top-left-bottom-right" <?php selected('top-left-bottom-right', $cell->title_position)?>><?php _e('Top left - bottom right', 'uber-grid')?></option>
					<option value="top-right-bottom-right" <?php selected('top-right-bottom-right', $cell->title_position)?>><?php _e('Top right - bottom right', 'uber-grid')?></option>
					<option value="top-left-bottom-left" <?php selected('top-left-bottom-left', $cell->title_position)?>><?php _e('Top left - bottom left', 'uber-grid')?></option>
				</select>
			</div>
			<div class="field">
				<label><?php _e('Tags (used for filtering)', 'uber-grid')?></label>
				<input type="text" name="<?php echo $name_prefix ?>[tags]" placeholder="<?php _e('comma-separated tags')?>" value="<?php echo esc_attr($cell->tags)?>">
			</div>
		</div>
		<div class="column">
			<label><?php _e('Main image', 'uber-grid')?></label>
			<div class="image-selector no-image">
				<input name="<?php echo $name_prefix ?>[image]" value="<?php echo $cell->image ?>" type="hidden">
				<?php if ($cell->image): ?>
					<img src="<?php echo esc_attr($cell->getImageSrc($grid)) ?>">
				<?php endif ?>
				<div class="overlay"></div>
				<div class="actions-wrapper">
					<button class="select-image button "><?php _e('Select image', 'uber-grid')?></button>
					<br>
					<a href="#" class="image-delete"><?php _e('Remove image', 'uber-grid')?></a>
				</div>
			</div>
		</div>
	</div>
	<br class="clear">
</div>
<div class="section cell-layout">
	<label class="huge"><?php _e('Layout',  'uber-grid')?></label>
	<input type="hidden" name="<?php echo $name_prefix ?>[layout]" value="<?php echo $cell->layout ?>">
	<ul class="layouts column-1">
		<li class="r1c1-io"><div class="img"></div></li>
		<li class="r1c2-io"><div class="img"></div></li>
		<li class="r1c2-il"><div class="img"></div></li>
		<li class="r1c2-ir"><div class="img"></div></li>
		<li class="r2c1-io"><div class="img"></div></li>
		<li class="r2c1-it"><div class="img"></div></li>
		<li class="r2c1-ib"><div class="img"></div></li>
		<li class="r2c2-io"><div class="img"></div></li>
		<li class="r2c2-il"><div class="img"></div></li>
		<li class="r2c2-ir"><div class="img"></div></li>
		<li class="r2c2-it"><div class="img"></div></li>
		<li class="r2c2-ib"><div class="img"></div></li>
	</ul>
	<br class="clear">
</div>
<div class="section image expandable">
	<label class="huge"><?php _e('Title Background', 'uber-grid')?></label>
	<div class="column-1 ">
		<div class="column">
			<label><?php _e('Background image', 'uber-grid')?></label>
			<div class="image-selector no-image">
				<input name="<?php echo $name_prefix ?>[title_background_image]" value="<?php echo $cell->title_background_image ?>" type="hidden">
				<?php if ($cell->title_background_image): ?>
					<img src="<?php echo esc_attr($cell->getTitleBackgroundImageSrc()) ?>">
				<?php endif ?>
				<div class="actions-wrapper">
					<button class="select-image button "><?php _e('Select image', 'uber-grid')?></button>
					<br>
					<a href="#" class="image-delete"><?php _e('Remove image', 'uber-grid')?></a>
				</div>
			</div>
		</div>
		<div class="column">
			<div class="field">
				<label><?php _e('Title background color', 'uber-grid')?></label>
				<input type="text" name="<?php echo $name_prefix ?>[title_background_color]" value="<?php echo $cell->title_background_color ?>" class="color-picker">
			</div>
		</div>
	</div>
	<br class="clear">
</div>
<div class="section linking">
	<label class="huge"><input type="checkbox" name="<?php echo $name_prefix ?>[link_enable]" value="1" <?php echo checked($cell->link_enable)?>><?php _e('Link')?></label>
	<div class="columns-2">
		<div class="column">
			<div class="field">
				<label><?php _e('Link mode')?></label>
				<select name="<?php echo $name_prefix ?>[link_mode]" class="select-link-mode">
					<option value="url" <?php selected('url', $cell->link_mode)?>><?php _e('URL', 'uber-grid')?></option>
					<option value="lightbox" <?php selected('lightbox', $cell->link_mode)?>><?php _e('Lightbox', 'uber-grid')?></option>
				</select>
			</div>
			<div class="field">
				<label><?php _e('Link this cell to URL', 'uber-grid')?></label>
				<input type="text" class="full-width" name="<?php echo $name_prefix ?>[link_url]" value="<?php echo esc_attr($cell->link_url) ?>">
				<small><?php _e('Please don\'t use youtu.be short URLs - use full youtube.com/watch/... ones instead')?></small>
			</div>
			<div class="link-to-lightbox">
				<label><?php _e('Lightbox image', 'uber-grid')?></label>
				<div class="image-selector no-image">
					<input type="hidden" name="<?php echo $name_prefix ?>[lightbox_image]" value="<?php echo $cell->lightbox_image ?>">
					<?php if ($cell->lightbox_image): ?>
						<img src="<?php echo esc_attr($cell->getLightboxImageSrc()) ?>">
					<?php endif ?>
					<div class="actions-wrapper">
						<button class="select-image button "><?php _e('Select image', 'uber-grid')?></button>
						<br>
						<a href="#" class="image-delete"><?php _e('Remove image', 'uber-grid')?></a>
					</div>
				</div>
			</div>
			<div class="field link-to-lightbox">
				<label><?php _e('Lightbox Title', 'uber-grid')?></label>
				<input type="text" class="full-width" name="<?php echo $name_prefix ?>[lightbox_title]" value="<?php echo esc_html($cell->lightbox_title) ?>">
			</div>
			<div class="field link-to-lightbox">
				<label><?php _e('Lightbox Text', 'uber-grid')?></label>
				<textarea class="full-width" name="<?php echo $name_prefix ?>[lightbox_text]"><?php echo esc_textarea($cell->lightbox_text) ?></textarea>
			</div>
			
		</div>
		<div class="column">
			<div class="field link-to-url">
				<label><?php _e('Link "target" attribute value', 'uber-grid')?></label>
				<input type="text" class="full-width" name="<?php echo $name_prefix ?>[link_target]" value="<?php echo esc_attr($cell->link_target) ?>">
			</div>
			<div class="field link-to-url">
				<label><?php _e('Link "rel" attribute value', 'uber-grid')?></label>
				<input type="text" class="full-width" name="<?php echo $name_prefix ?>[link_rel]" value="<?php echo esc_attr($cell->link_rel) ?>">
			</div>
			<?php foreach(array('facebook', 'twitter', 'linkedin', 'pinterest', 'email', 'skype', 'dribbble', 'flickr', 'website', 'googleplus') as $service): ?>
				<div class="field link-to-lightbox">
					<label><?php _e(ucfirst($service . " url"), 'uber-grid')?></label>
					<?php $service_name = "lightbox_$service" ?>
					<input type="text" class="full-width" name="<?php echo $name_prefix ?>[lightbox_<?php echo $service ?>]" value="<?php echo esc_attr($cell->$service_name) ?>">
				</div>
			<?php endforeach ?>
		</div>
	</div>
	<br class="clear">
</div>
<div class="section hover">
	<label class="huge"><input type="checkbox" name="<?php echo $name_prefix ?>[hover_enable]" value="1" <?php echo checked($cell->hover_enable)?>><?php _e('On-hover', 'uber-grid')?></label>
	<div class="columns-2">
		<div class="column">
			
			<p>
				<label><?php _e('Title', 'uber-grid')?></label>
				<input type="text" class="full-width" name="<?php echo $name_prefix ?>[hover_title]" value="<?php echo esc_html($cell->hover_title) ?>">
			</p>
			<p>
				<label><?php _e('Text', 'uber-grid')?></label>
				<textarea class="full-width" name="<?php echo $name_prefix ?>[hover_text]"><?php echo esc_textarea($cell->hover_text)?></textarea>
			</p>
			<p>
				<label><?php _e('Text color', 'uber-grid')?></label>
				<input type="text" class="color-picker" name="<?php echo $name_prefix ?>[hover_text_color]" value="<?php echo $cell->hover_text_color ?>">
			</p>
		</div>
		<div class="column">
			<p>
				<label><input type="checkbox" value="1" <?php checked($cell->hover_hide_arrow)?> name="<?php echo $name_prefix?>[hover_hide_arrow]"> <?php _e('Disable arrow in hover block', 'uber-grid')?>
			</p>
			<label><?php _e('Background image', 'uber-grid')?></label>
			<div class="image-selector no-image">
				<input type="hidden" name="<?php echo $name_prefix ?>[hover_background_image]" value="<?php echo $cell->hover_background_image ?>">
				<?php if ($cell->hover_background_image): ?><img src="<?php echo esc_attr($cell->gethoverBackgroundImageSrc()) ?>"><?php endif ?>
				<div class="overlay"></div>
				<div class="actions-wrapper">
					<button class="select-image button "><?php _e('Select image', 'uber-grid')?></button>
					<br>
					<a href="#" class="image-delete"><?php _e('Remove image', 'uber-grid')?></a>
				</div>
			</div>
			<label><?php _e('Background color', 'uber-grid')?></label>
			<input type="text" class="color-picker" name="<?php echo $name_prefix ?>[hover_background_color]" value="<?php echo $cell->hover_background_color ?>">
		</div>
		<br class="clear">
	</div>
	<br class="clear">
</div>
<div class="section label-content">
	<label class="huge"><input type="checkbox" name="<?php echo $name_prefix ?>[label_enable]" <?php checked($cell->label_enable)?> value="1"><?php _e('Label below', 'uber-grid')?></label>
	<div class="column-1">
		<div class="field">
			<input type="text" class="full-width larger" name="<?php echo $name_prefix ?>[label_title]" value="<?php echo esc_attr($cell->label_title) ?>" placeholder="<?php _e('Title', 'uber-grid') ?>">
			<input type="text" name="<?php echo $name_prefix ?>[label_title_color]" value="<?php echo $cell->label_title_color ?>" class="color-picker">
		</div>
		<div class="field">
			<label><?php _e('Small text', 'uber-grid')?></label>
			<input type="text" class="full-width" name="<?php echo $name_prefix ?>[label_tagline]" value="<?php echo esc_attr($cell->label_tagline) ?>">
			<input type="text" name="<?php echo $name_prefix ?>[label_tagline_color]" value="<?php echo $cell->label_tagline_color ?>" class="color-picker">
		</div>
		<div class="field">
			<label><?php _e('Price tag', 'uber-grid')?></label>
			<input type="text" name="<?php echo $name_prefix ?>[label_price]" value="<?php echo esc_attr($cell->label_price) ?>">
		</div>
		<div class="field">
			<label><?php _e('Background color', 'uber-grid')?></label>
			<input type="text" name="<?php echo $name_prefix ?>[label_background_color]" value="<?php echo $cell->label_background_color ?>" class="color-picker">
		</div>
		<div class="field">
			<label><?php _e('Price color', 'uber-grid')?></label>
			<input type="text" name="<?php echo $name_prefix ?>[label_price_color]" value="<?php echo $cell->label_price_color ?>" class="color-picker">
		</div>
		<div class="field">
			<label><?php _e('Price background color', 'uber-grid')?></label>
			<input type="text" name="<?php echo $name_prefix ?>[label_price_background_color]" value="<?php echo $cell->label_price_background_color ?>" class="color-picker">
		</div>
	</div>
	<br class="clear">
</div>
