<?php
/**
 * adminFunctions.php
 * @package plugins_shared
 * @version version 1.3.0
 */

/**
 * add the admin field settings
 * @param array $args
 */
function eipAdminAddFieldSettings($args)
{
	foreach ($args as $fe_FS) 
	{
		//add_settings_field( $id, $title, $callback, $page, $section, $args );
		add_settings_field($fe_FS['id'], $fe_FS['title'],$fe_FS['callback'],$fe_FS['page'],$fe_FS['section'],$fe_FS['args']);
	}	
}

/**
 * Sanitize and validate input. Accepts an array, return a sanitized array.
 * @param array $userInput
 */
function eipScrubInput($userInput)
{	
	foreach($userInput as $feUI)
	{
		$userInput[$feUI] = wp_filter_nohtml_kses($feUI);
	}
	$userInput['forumDBConn'] = ($userInput['forumDBConn'] == "SQL" || $userInput['forumDBConn'] == "PDO") ? $userInput['forumDBConn'] : "SQL";
	
	if(array_key_exists('forumPosts',$userInput)){$userInput['forumPosts'] 			= eipFilterNumeric($userInput['forumPosts'], 1, 99, 10);}
	if(array_key_exists('forumMembers',$userInput)){$userInput['forumMembers']		= eipFilterNumeric($userInput['forumMembers'], 1, 200, 50);}
	if(array_key_exists('forumUserPosts',$userInput)){$userInput['forumUserPosts']	= eipFilterNumeric($userInput['forumUserPosts'], 1, 99, 5);}
	if(array_key_exists('forumLookBack',$userInput)){$userInput['forumLookBack'] 	= eipFilterNumeric($userInput['forumLookBack'], 1, 365, 30);}
	if(array_key_exists('forumThreadLen',$userInput)){$userInput['forumThreadLen']	= eipFilterNumeric($userInput['forumThreadLen'], 4, 128, 30);}
	return ($userInput);
}
?>