<?php

class XenResource_Install_Controller
{
	public static function install($previous)
	{
		$db = XenForo_Application::get('db');

		if (XenForo_Application::$versionId < 1010370)
		{
			// note: this can't be phrased
			throw new XenForo_Exception('This add-on requires XenForo 1.1.3 or higher.', true);
		}

		if (!$previous)
		{
			foreach (self::getTables() AS $tableSql)
			{
				try
				{
					$db->query($tableSql);
				}
				catch (Zend_Db_Exception $e) {}
			}

			foreach (self::getAlters() AS $alterSql)
			{
				try
				{
					$db->query($alterSql);
				}
				catch (Zend_Db_Exception $e) {}
			}

			foreach (self::getData() AS $dataSql)
			{
				$db->query($dataSql);
			}
		}
		else
		{
			// upgrades
		}
	}

	public static function uninstall()
	{
		$db = XenForo_Application::get('db');

		foreach (self::getTables() AS $tableName => $tableSql)
		{
			try
			{
				$db->query("DROP TABLE IF EXISTS `$tableName`");
			}
			catch (Zend_Db_Exception $e) {}
		}

		try
		{
			$db->query("ALTER TABLE xf_user DROP resource_count");
		}
		catch (Zend_Db_Exception $e) {}

		$contentTypes = array('resource', 'resource_update', 'resource_version', 'resource_rating');
		$contentTypesQuoted = $db->quote($contentTypes);

		XenForo_Db::beginTransaction($db);

		$contentTypeTables = array(
			'xf_attachment',
			'xf_content_type',
			'xf_content_type_field',
			'xf_deletion_log',
			'xf_liked_content',
			'xf_moderation_queue',
			'xf_moderator_log',
			'xf_news_feed',
			'xf_report',
			'xf_user_alert'
		);
		foreach ($contentTypeTables AS $table)
		{
			$db->delete($table, 'content_type IN (' . $contentTypesQuoted . ')');
		}

		$db->delete('xf_admin_permission_entry', "admin_permission_id = 'resourceManager'");
		$db->delete('xf_permission_entry', "permission_group_id = 'resource'");

		XenForo_Db::commit($db);
	}

	public static function getTables()
	{
		$tables = array();

		// TODO: these strings are just dumped straight from phpMyAdmin...clean them up when they are finalised

		$tables['xf_resource'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource` (
			  `resource_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `title` varchar(100) NOT NULL DEFAULT '',
			  `tag_line` varchar(100) NOT NULL DEFAULT '',
			  `user_id` int(10) unsigned NOT NULL,
			  `username` varchar(100) NOT NULL DEFAULT '',
			  `resource_state` ENUM(  'visible',  'moderated',  'deleted' ) NOT NULL DEFAULT  'visible',
			  `resource_date` int(10) unsigned NOT NULL,
			  `resource_category_id` int(11) NOT NULL,
			  `current_version_id` int(10) unsigned NOT NULL,
			  `description_update_id` int(10) unsigned NOT NULL COMMENT 'Points to the resource update that acts as the description for this resource',
			  `discussion_thread_id` int(10) unsigned NOT NULL COMMENT 'Points to an automatically-created thread for this resource',
			  `external_url` varchar(500) NOT NULL DEFAULT '',
			  is_fileless tinyint unsigned not null default 0,
			  external_purchase_url varchar(500) not null default '',
			  price decimal(10,2) unsigned not null default 0,
			  `currency` VARCHAR( 3 ) NOT NULL DEFAULT '',
			  `download_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_avg` float unsigned NOT NULL DEFAULT '0',
			  `rating_weighted` float unsigned NOT NULL DEFAULT '0',
			  update_count int unsigned not null default 0,
			  review_count int unsigned not null default 0,
			  `last_update` int(10) unsigned NOT NULL,
			  alt_support_url varchar(500) not null default '',
			  had_first_visible tinyint unsigned not null default 0,
			  PRIMARY KEY (`resource_id`),
			  KEY `category_last_update` (`resource_category_id`, last_update),
			  KEY `category_rating_weighted` (`resource_category_id`, rating_weighted),
			  KEY `last_update` (`last_update`),
			  KEY `rating_weighted` (`rating_weighted`),
			  KEY `user_id_last_update` (`user_id`, last_update),
			  KEY discussion_thread_id (discussion_thread_id)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8
		";

		$tables['xf_resource_update'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource_update` (
			  `resource_update_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
			  `resource_id` int(11) NOT NULL,
			  `title` varchar(100) NOT NULL DEFAULT '' COMMENT 'Title field is optional, and is not used in the first post.',
			  `message` mediumtext NOT NULL COMMENT 'Supports BB code',
			  `message_state` enum('visible', 'moderated', 'deleted') NOT NULL DEFAULT 'visible',
			  `post_date` int(10) unsigned NOT NULL,
			  `attach_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `likes` int(10) unsigned NOT NULL DEFAULT '0',
			  `like_users` blob NOT NULL,
			  ip_id int unsigned not null default 0,
			  had_first_visible tinyint unsigned not null default 0,
			  PRIMARY KEY (`resource_update_id`),
			  KEY `resource_id_post_date` (`resource_id`, post_date)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8
		";

		$tables['xf_resource_category'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource_category` (
				`resource_category_id` int(10) unsigned NOT NULL auto_increment,
				`category_title` varchar(100) NOT NULL,
				category_description text not null,
				`parent_category_id` int(10) unsigned NOT NULL default '0',
				`depth` smallint(5) unsigned NOT NULL default '0',
				`lft` int(10) unsigned NOT NULL default '0',
				`rgt` int(10) unsigned NOT NULL default '0',
				`display_order` int(10) unsigned NOT NULL default '0',
				`resource_count` int(10) unsigned NOT NULL default '0',
				`last_update` int(10) unsigned NOT NULL default '0',
				`last_resource_title` varchar(100) NOT NULL default '',
				`last_resource_id` int(10) unsigned NOT NULL default '0',
				`category_breadcrumb` blob NOT NULL,
				allow_local tinyint unsigned not null default 0,
				allow_external tinyint unsigned not null default 0,
				allow_commercial_external tinyint unsigned not null default 0,
				allow_fileless tinyint unsigned not null default 0,
				thread_node_id int unsigned not null default 0,
				thread_prefix_id int unsigned not null default 0,
				always_moderate_create tinyint unsigned not null default 0,
				always_moderate_update tinyint unsigned not null default 0,
				allow_submit_user_group_ids blob NOT NULL,
				PRIMARY KEY  (`resource_category_id`),
				KEY `parent_category_id_lft` (`parent_category_id`,`lft`),
				KEY `lft_rgt` (`lft`,`rgt`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8
		";

		$tables['xf_resource_download'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource_download` (
			  `resource_download_id` int(10) unsigned NOT NULL auto_increment,
			  `resource_version_id` int(10) unsigned NOT NULL,
			  `user_id` int(10) unsigned NOT NULL,
			  `resource_id` int(10) unsigned NOT NULL,
			  `last_download_date` int(10) unsigned NOT NULL,
			  PRIMARY KEY  (`resource_download_id`),
			  UNIQUE KEY `version_user` (`resource_version_id`,`user_id`),
			  KEY `user_resource` (`user_id`,`resource_id`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8
		";

		$tables['xf_resource_rating'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource_rating` (
			  `resource_rating_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `resource_version_id` int(10) unsigned NOT NULL,
			  `user_id` int(10) unsigned NOT NULL,
			  `rating` tinyint(3) unsigned NOT NULL,
			  `rating_date` int(10) unsigned NOT NULL,
			  `message` mediumtext NOT NULL,
			  `resource_id` int(10) unsigned NOT NULL,
			  `version_string` varchar(50) NOT NULL,
			  `author_response` mediumtext NOT NULL,
			  `is_review` tinyint(3) unsigned NOT NULL DEFAULT '0',
			  `count_rating` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Whether this counts towards the global resource rating.',
			  `rating_state` ENUM(  'visible',  'deleted' ) NOT NULL DEFAULT  'visible',
			  PRIMARY KEY (`resource_rating_id`),
			  UNIQUE KEY `version_user_id` (`resource_version_id`,`user_id`),
			  KEY `user_id` (`user_id`),
			  KEY `count_rating_resource_id` (`count_rating`,`resource_id`),
			  KEY `resource_id_rating_date` (`resource_id`,`rating_date`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8
		";

		$tables['xf_resource_version'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource_version` (
			  `resource_version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `resource_id` int(10) unsigned NOT NULL,
			  `resource_update_id` int(10) unsigned NOT NULL,
			  `version_string` varchar(50) NOT NULL,
			  `release_date` int(10) unsigned NOT NULL,
			  download_url varchar(250) NOT NULL DEFAULT '',
			  `download_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
			  `version_state` ENUM(  'visible',  'moderated',  'deleted' ) NOT NULL DEFAULT  'visible',
			  had_first_visible tinyint unsigned not null default 0,
			  PRIMARY KEY (`resource_version_id`),
			  KEY `resource_id_release_date` (`resource_id`, release_date)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8
		";

		$tables['xf_resource_watch'] = "
			CREATE TABLE IF NOT EXISTS `xf_resource_watch` (
				`user_id` int(10) unsigned NOT NULL,
				`resource_id` int(10) unsigned NOT NULL,
				`email_subscribe` tinyint(3) unsigned NOT NULL default '0',
				watch_key varchar(16) not null default '',
				PRIMARY KEY  (`user_id`,`resource_id`),
				KEY `resource_id_email_subscribe` (`resource_id`,`email_subscribe`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8
		";

		return $tables;
	}

	public static function getAlters()
	{
		$alters = array();

		$alters['user'] = "
			ALTER TABLE xf_user ADD resource_count INT UNSIGNED NOT NULL DEFAULT 0,
				ADD INDEX resource_count (resource_count)
		";

		return $alters;
	}

	public static function getData()
	{
		$data = array();

		$data['xf_content_type'] = "
			INSERT IGNORE INTO xf_content_type
				(content_type, addon_id, fields)
			VALUES
				('resource', 'XenResource', ''),
				('resource_update', 'XenResource', ''),
				('resource_version', 'XenResource', ''),
				('resource_rating', 'XenResource', '')
		";

		$data['xf_content_type_field'] = "
			INSERT IGNORE INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				('resource',         'moderation_queue_handler_class', 'XenResource_ModerationQueueHandler_Resource'),
				('resource',         'moderator_log_handler_class',    'XenResource_ModeratorLogHandler_Resource'),
				('resource',         'spam_handler_class',             'XenResource_SpamHandler_Resource'),
				('resource',         'stats_handler_class',            'XenResource_StatsHandler_Resource'),

				('resource_update',  'alert_handler_class',            'XenResource_AlertHandler_Update'),
				('resource_update',  'attachment_handler_class',       'XenResource_AttachmentHandler_Update'),
				('resource_update',  'like_handler_class',             'XenResource_LikeHandler_Update'),
				('resource_update',  'news_feed_handler_class',        'XenResource_NewsFeedHandler_Update'),
				('resource_update',  'search_handler_class',           'XenResource_Search_DataHandler_Update'),
				('resource_update',  'report_handler_class',           'XenResource_ReportHandler_Update'),
				('resource_update',  'moderation_queue_handler_class', 'XenResource_ModerationQueueHandler_Update'),
				('resource_update',  'moderator_log_handler_class',    'XenResource_ModeratorLogHandler_Update'),

				('resource_version', 'attachment_handler_class',       'XenResource_AttachmentHandler_Version'),
				('resource_version', 'moderation_queue_handler_class', 'XenResource_ModerationQueueHandler_Version'),
				('resource_version', 'moderator_log_handler_class',    'XenResource_ModeratorLogHandler_Version'),

				('resource_rating',  'report_handler_class',           'XenResource_ReportHandler_Rating'),
				('resource_rating',  'alert_handler_class',            'XenResource_AlertHandler_Rating'),
				('resource_rating',  'spam_handler_class',             'XenResource_SpamHandler_Rating')
		";

		$data['xf_resource_category'] = "
			INSERT INTO `xf_resource_category`
				(`resource_category_id`, `category_title`, `category_description`, `parent_category_id`, `depth`, `lft`, `rgt`, `display_order`, `resource_count`, `last_update`, `last_resource_title`, `last_resource_id`, `category_breadcrumb`, `allow_local`, `allow_external`, `allow_commercial_external`, `allow_fileless`, `thread_node_id`, `thread_prefix_id`, `always_moderate_create`, `always_moderate_update`, `allow_submit_user_group_ids`)
			VALUES
				(1, 'Example Category', 'This is an example resource manager category. You can manage the resource manager categories via the <a href=\"admin.php?resource-categories/\">Admin Control Panel</a>. From there, you can setup more categories or change the resource manager options.', 0, 0, 1, 2, 1, 0, 0, '0', 0, 0x613a303a7b7d, 1, 1, 1, 1, 0, 0, 0, 0, '-1');
		";

		$data['xf_admin_permission_entry'] = "
			INSERT IGNORE INTO xf_admin_permission_entry
				(user_id, admin_permission_id)
			SELECT user_id, 'resourceManager'
			FROM xf_admin_permission_entry
			WHERE admin_permission_id = 'node'
		";

		$data['xf_phrase'] = "
			INSERT IGNORE INTO `xf_phrase`
				(`language_id`, `title`, `phrase_text`, `global_cache`, `addon_id`, `version_id`, `version_string`)
			VALUES
				(0, 'rating', 'Rating', 0, '', 0, ''),
				(0, 'rating_1', 'Terrible', 0, '', 0, ''),
				(0, 'rating_2', 'Poor', 0, '', 0, ''),
				(0, 'rating_3', 'Average', 0, '', 0, ''),
				(0, 'rating_4', 'Good', 0, '', 0, ''),
				(0, 'rating_5', 'Excellent', 0, '', 0, ''),
				(0, 'submit_rating', 'Submit Rating', 0, '', 0, ''),
				(0, 'your_rating_has_been_recorded', 'Your rating has been recorded.', 0, '', 0, '');
		";

		$data['xf_permission_entry_view'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'view', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'general' AND permission_id = 'viewNode'
		";
		$data['xf_permission_entry_viewUpdateAttach'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'viewUpdateAttach', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'general' AND permission_id = 'viewNode'
		";
		$data['xf_permission_entry_download'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'download', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'viewAttach'
		";
		$data['xf_permission_entry_like'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'like', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'like'
		";
		$data['xf_permission_entry_rate'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'rate', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'like'
		";
		$data['xf_permission_entry_add'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'add', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'postThread'
		";
		$data['xf_permission_entry_uploadUpdateAttach'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'uploadUpdateAttach', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'postThread'
		";
		$data['xf_permission_entry_updateSelf'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'updateSelf', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'editOwnPost'
		";
		$data['xf_permission_entry_reviewReply'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'reviewReply', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'editOwnPost'
		";
		$data['xf_permission_entry_deleteSelf'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'deleteSelf', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'deleteOwnPost'
		";
		$data['xf_permission_entry_viewDeleted'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'viewDeleted', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'viewDeleted'
		";
		$data['xf_permission_entry_deleteAny'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'deleteAny', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'deleteAnyPost'
		";
		$data['xf_permission_entry_undelete'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'undelete', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'undelete'
		";
		$data['xf_permission_entry_hardDeleteAny'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'hardDeleteAny', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'hardDeleteAnyPost'
		";
		$data['xf_permission_entry_deleteReviewAny'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'deleteReviewAny', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'deleteAnyPost'
		";
		$data['xf_permission_entry_editAny'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'editAny', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'editAnyPost'
		";
		$data['xf_permission_entry_reassign'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'reassign', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'editAnyPost'
		";
		$data['xf_permission_entry_viewModerated'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'viewModerated', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'viewModerated'
		";
		$data['xf_permission_entry_approveUnapprove'] = "
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			SELECT user_group_id, user_id, 'resource', 'approveUnapprove', permission_value, 0
			FROM xf_permission_entry
			WHERE permission_group_id = 'forum' AND permission_id = 'approveUnapprove'
		";

		return $data;
	}
}