<?php

/**
* Data writer for categories
*/
class XenGallery_DataWriter_Category extends XenForo_DataWriter
{
	/**
	 * Title of the phrase that will be created when a call to set the
	 * existing data fails (when the data doesn't exist).
	 *
	 * @var string
	 */
	protected $_existingDataErrorPhrase = 'xengallery_requested_category_not_found';

	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'xengallery_category' => array(
				'xengallery_category_id' => array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'category_title'       => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 100,
					'requiredError' => 'please_enter_valid_title'
				),
				'category_description' => array('type' => self::TYPE_STRING, 'default' => 0),
				'upload_user_groups'  => array('type' => self::TYPE_SERIALIZED, 'default' => 'a:0:{}'),
				'allowed_types'  => array('type' => self::TYPE_SERIALIZED, 'default' => 'a:1:{i:0;s:3:"all";}'),				
				'parent_category_id'   => array('type' => self::TYPE_UINT, 'default' => 0),
				'display_order'        => array('type' => self::TYPE_UINT, 'default' => 1),
				'category_breadcrumb'  => array('type' => self::TYPE_SERIALIZED, 'default' => 'a:0:{}'),
				'depth'                => array('type' => self::TYPE_UINT, 'default' => 0),					
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('xengallery_category' => $this->_getCategoryModel()->getCategoryById($id));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'xengallery_category_id = ' . $this->_db->quote($this->getExisting('xengallery_category_id'));
	}
	
	protected function _postSave()
	{
		if ($this->isInsert()
			|| $this->isChanged('display_order')
			|| $this->isChanged('parent_category_id')
			|| $this->isChanged('category_title')
		)
		{
			$this->_getCategoryModel()->rebuildCategoryStructure();
		}
	}
	
	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		$db = $this->_db;
		
		$db->update('xengallery_category',
			array('parent_category_id' => $this->get('parent_category_id')),
			'parent_category_id = ' . $this->_db->quote($this->get('xengallery_category_id'))
		);
		
		$media = $db->fetchAll('
			SELECT *
			FROM xengallery_media
			WHERE xengallery_category_id = ?
		', $this->get('xengallery_category_id'));
		
		$mediaIds = array();
		foreach ($media AS $_media)
		{
			$mediaIds[] = $_media['media_id'];
		}
		$mediaIdsQuoted = $db->quote($mediaIds);
		
		if ($mediaIdsQuoted)
		{
			$db->delete('xengallery_comment', 'media_id IN (' . $mediaIdsQuoted . ')');
			$db->delete('xengallery_rating', 'media_id IN (' . $mediaIdsQuoted . ')');
			$db->delete('xengallery_media', 'media_id IN (' . $mediaIdsQuoted . ')');
			
			$rebuild = new XenGallery_CacheRebuilder_MediaCount('MediaCount');
			$rebuild->rebuild();
			
			$indexer = new XenForo_Search_Indexer();
			$dataHandler = XenForo_Search_DataHandler_Abstract::create('XenGallery_Search_DataHandler_Media');
			
			$dataHandler->deleteFromIndex($indexer, $media);
			
			$db->update('xf_attachment', array('unassociated' => 1), 'content_type = \'xengallery_media\' AND content_id IN (' . $mediaIdsQuoted . ')');
		}

		$this->_getCategoryModel()->rebuildCategoryStructure();
	}	

	/**
	 * @return XenGallery_Model_Category
	 */
	protected function _getCategoryModel()
	{
		return $this->getModelFromCache('XenGallery_Model_Category');
	}
}