<?php
						
class Waindigo_PostAsUser_ControllerPublic_Forum extends XFCP_Waindigo_PostAsUser_ControllerPublic_Forum
{
	public function actionCreateThread()
	{
		$response = parent::actionCreateThread();
		
		/* @var $response XenForo_ControllerResponse_View */
		if (get_class($response) == 'XenForo_ControllerResponse_View')
		{
			/* @var $xenOptions XenForo_Options */
			$xenOptions = XenForo_Application::get('options');
			
			if ($xenOptions->waindigo_postAsUser_useComboBox)
			{
				$response->params['useAutoCombo'] = Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled('Waindigo_AutoCombo', 'load_class_controller');
			}
			else
			{
				/* @var $userModel XenForo_Model_User */
				$userModel = XenForo_Model::create('XenForo_Model_User');
				
				if ($userModel->canPostAsDifferentUser())
				{
					$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_postAsUser_userGroups);
					
					if (!empty($userGroupIds))
					{
						$response->params['postAsUsers'] = $userModel->getUsersByUserGroupIds($userGroupIds);
						unset($response->params['postAsUsers'][XenForo_Visitor::getUserId()]);
					}
				}
			}
		}
		
		return $response;
	}
	
	public function actionAddThread()
	{
		$GLOBALS['Waindigo_PostAsUser_ControllerPublic_Forum'] = $this;
		
		return parent::actionAddThread();
	}
	
	public function processPostAsUser(Waindigo_PostAsUser_DataWriter_Discussion_Thread $dw)
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
			
		$input = $this->_input->filter(array(
			'post_as_user_id' => XenForo_Input::UINT,
			'post_as_username' => XenForo_Input::STRING,
		));
		if ($input['post_as_username'])
		{
			$user = $userModel->getUserByName($input['post_as_username']);
			$input['post_as_user_id'] = $user['user_id'];
		}
		if ($input['post_as_user_id'] && $userModel->canPostAsDifferentUser())
		{				
			if (!isset($user))
			{
				$user = $userModel->getUserById($input['post_as_user_id']);
			}
		
			$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_postAsUser_userGroups);
				
			if (!empty($user))
			{
				foreach ($userGroupIds as $userGroupId)
				{
					if ($continue = $userModel->isMemberOfUserGroup($user, $userGroupId))
					{
						break;
					}
				}
				
				if ($continue)
				{
					$dw->set('user_id', $user['user_id']);
					$dw->set('username', $user['username']);
					$dw->set('last_post_user_id', $user['user_id']);
					$dw->set('last_post_username', $user['username']);
			    }
			}
		}
	
		unset($GLOBALS['Waindigo_PostAsUser_ControllerPublic_Forum']);
	}
}