<?php
class SplendidNetwork_XfRuAlbumsMore_ControllerPublic_RecentActivity extends XFCP_SplendidNetwork_XfRuAlbumsMore_ControllerPublic_RecentActivity
{
	public function actionIndex()
	{
		$response = parent::actionIndex();
		
		$newsFeeds = $response->params['newsFeed'];
		$visitor = XenForo_Visitor::getInstance();
		
		foreach($newsFeeds AS $key => $newsFeed)
		{
			if($newsFeed['content_type'] == 'xfr_useralbum' || $newsFeed['content_type'] == 'xfr_useralbum_image' || $newsFeed['content_type'] == 'xfr_useralbum_image_cmnt')
			{
				$albumId = $newsFeed['content_id'];
				$albumType = $newsFeed['content']['album_type'];
				
				if(!$visitor['user_id'])
				{
					if($albumType == 'members' || $albumType == 'followed' || $albumType == 'selected')
					{
						unset($newsFeeds[$key]);
					}
				}
				else
				{
					if($newsFeed['user_id'] == $visitor['user_id'])
						continue;
				
					if($visitor->hasPermission('xfrUserAlbumsPermissions', 'xfr_UAM_ByPassPrivacy'))
						continue;
				
					if($albumType == 'followed')
					{
						$userModel = $this->_getUserModel();
				
						$followRecord = $userModel->getFollowRecord($newsFeed['user_id'], $visitor['user_id']);
						if(!$followRecord)
						{
							unset($newsFeeds[$key]);
						}
					}
				
					if($albumType == 'selected')
					{
						$selected_users = explode(',',$newsFeed['content']['selected_users']);
				
						if (!in_array($visitor['user_id'], $selected_users))
						{
							unset($newsFeeds[$key]);
						}
					}
				}
			}
		}
	
		$response->params['newsFeed'] = $newsFeeds;
		return $response;
	}
	
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
}