<?php

class ProfileViewCount_Install
{
        
        // Some installation code taken from Jake Bunce's Nodes as Tabs add-on
	// http://xenforo.com/community/resources/nodes-as-tabs.9/
        
        public static function installer()
        {
                self::addColumnIfNotExists('view_count', 'INT(10) UNSIGNED NOT NULL DEFAULT  "0"', 'custom_fields');
                
        		$query = 
        		'CREATE TABLE IF NOT EXISTS xf_profile_view (
        			user_id INT UNSIGNED NOT NULL,
        			visitor_id INT UNSIGNED NOT NULL,
        			KEY user_id (user_id)
        		) ENGINE = MEMORY CHARACTER SET utf8 COLLATE utf8_general_ci';
        		
        		$db = XenForo_Application::getDb();
 
        		$db->query($query);
        }
        
        public static function uninstaller()
        {
                self::dropColumnIfExists('view_count');
                
                $query = 'DROP TABLE IF EXISTS xf_profile_view';
                
        		$db = XenForo_Application::getDb();
 
        		$db->query($query);                
        }       
        
        public static function addColumnIfNotExists($fieldName, $fieldDef, $after)
        {
            $db = XenForo_Application::get('db');

            $exists = $db->fetchRow("
                            SHOW COLUMNS
                            FROM xf_user_profile
                            WHERE Field = ?
                    ", $fieldName);

            if (!$exists)
            {
                    $db->query("
                                    ALTER TABLE xf_user_profile ADD {$fieldName} {$fieldDef} AFTER {$after}
                    ");
            }
        }        
        
        public static function dropColumnIfExists($fieldName)
        {
            $db = XenForo_Application::get('db');

            $exists = $db->fetchRow("
                            SHOW COLUMNS
                            FROM xf_user_profile
                            WHERE Field = ?
                    ", $fieldName);

            if ($exists)
            {
                    $db->query("
                                    ALTER TABLE xf_user_profile DROP {$fieldName}
                    ");
            }
        }                
}
