<?php
class Brivium_Credits_DataWriter_User extends XFCP_Brivium_Credits_DataWriter_User
{
	protected function _getFields()
	{
		$result = parent::_getFields();
		$result['xf_user']['credits'] = array('type' => self::TYPE_FLOAT, 'default' => 0);
		$result['xf_user']['currency_id'] = array('type' => self::TYPE_UINT, 'default' => 0);
		return $result;
	}
	protected function _preSave()
	{
		if (isset($GLOBALS['BRC_CPA_actionPreferencesSave_currencyId'])) {
			$this->set('currency_id', $GLOBALS['BRC_CPA_actionPreferencesSave_currencyId']);
			unset($GLOBALS['BRC_CPA_actionPreferencesSave_currencyId']);
		}
		return parent::_preSave();
	}
	public function save() {
		if (isset($GLOBALS['BRC_CAU_actionSave'])) {
			$GLOBALS['BRC_CAU_actionSave']->brcActionSave($this);
		}
		return parent::save();
	}
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		$userId = $this->get('user_id');
		if (isset($GLOBALS['BRC_CAU_actionSave']) && isset($GLOBALS['BRC_CAU_actionSave_credits']) && isset($GLOBALS['BRC_CAU_actionSave_currencyId'])) {
			$this->_db->update('xf_user',
				array(
					'credits' => $GLOBALS['BRC_CAU_actionSave_credits'],
					'currency_id' => $GLOBALS['BRC_CAU_actionSave_currencyId'],				
				),
				' user_id = ' . $userId
			);
			unset($GLOBALS['BRC_CAU_actionSave']);
			unset($GLOBALS['BRC_CAU_actionSave_credits']);
			unset($GLOBALS['BRC_CAU_actionSave_currencyId']);
		}
		if (isset($GLOBALS['BRC_CPA_actionPersonalDetailsSave'])) {
			if($this->_checkUpdateFullProfile() && !$this->getModelFromCache('Brivium_Credits_Model_Credit')->countActionOfUser('updateFullProfile',$userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId);
			}
			if(!$this->_checkUpdateFullProfile() && $this->getModelFromCache('Brivium_Credits_Model_Credit')->countActionOfUser('updateFullProfile',$userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId,array('reverted'=>true));
			}
			unset($GLOBALS['BRC_CPA_actionPersonalDetailsSave']);
		}
		
		if(!$this->getExisting('avatar_date') && $this->get('avatar_date')){
			$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('uploadAvatar',$userId);
			if($this->_checkUpdateFullProfile() && !$this->getModelFromCache('Brivium_Credits_Model_Credit')->countActionOfUser('updateFullProfile',$userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId);
			}
		}
		if($this->getExisting('avatar_date') && !$this->get('avatar_date')){
			$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('uploadAvatar',$userId,array('reverted'=>true));
			if(!$this->_checkUpdateFullProfile() && $this->getModelFromCache('Brivium_Credits_Model_Credit')->countActionOfUser('updateFullProfile',$userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId,array('reverted'=>true));
			}
		}
		return parent::_postSave();
	}
	
	protected function _checkUpdateFullProfile()
	{
		$user = $this->getMergedData();
		$profileFields = array(
			'homepage',
			'location',
			'occupation',
			'dob_day',
			'dob_month',
			'dob_year',
			'about',
			'avatar_date',
		);
		$count = 0;
		foreach($profileFields AS $fieldName){
			if($this->get($fieldName)){
				if(isset($user[$fieldName]) && !empty($user[$fieldName])){
					$count ++;
				}
			}
		}
		if($count == 8){
			return true;
		}
		return false;
	}
	
	
}
?>
