<?php

class Brivium_Credits_ControllerAdmin_Currencies extends XenForo_ControllerAdmin_Abstract
{
	public function actionIndex()
	{
		$currencyModel = $this->_getCurrencyModel();
		$currencies = $currencyModel->getAllCurrencies();
		$viewParams = array(
			'currencies' => $currencies,
			'total' => count($currencies),
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Currency_List', 'BRC_currency_list', $viewParams);
	}
	
	public function _getCurrencyAddEditResponse(array $currency)
	{
		$viewParams = array(
			'currency' => $currency,
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Currency_Edit', 'BRC_currency_edit', $viewParams);
	}

	public function actionAdd()
	{
		$currency = $this->_getCurrencyModel()->getDefaultCurrency();

		return $this->_getCurrencyAddEditResponse($currency);
	}

	public function actionEdit()
	{
		$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
		$currency = $this->_getCurrencyOrError($currencyId);
		//prd($currency);
		return $this->_getCurrencyAddEditResponse($currency);
	}
	
	
	public function actionSave()
	{
		$this->_assertPostOnly();

		if ($this->_input->filterSingle('delete', XenForo_Input::STRING))
		{
			// user clicked delete
			return $this->responseReroute('Brivium_Credits_ControllerAdmin_Currencies', 'deleteConfirm');
		}

		$input = $this->_input->filter(array(
			'title' => XenForo_Input::STRING,
			'code' => XenForo_Input::STRING,
			
			'symbol_left' => XenForo_Input::STRING,
			'symbol_right' => XenForo_Input::STRING,
			'decimal_place' => XenForo_Input::UINT,
			'value' => XenForo_Input::FLOAT,
			'status' => XenForo_Input::UINT,
		));
		$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);

		
		$writer = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Currency');
		if ($currencyId)
		{
			$writer->setExistingData($currencyId);
		}

		$writer->bulkSet($input);
		$writer->save();

		$currencyId = $writer->get('currency_id');
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('currencies') . $this->getLastHash($currencyId)
		);
	}
	
	public function actionDelete()
	{
		if ($this->isConfirmedPost())
		{
			$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Currency');
			$dw->setExistingData($this->_input->filterSingle('currency_id', XenForo_Input::UINT));
			$dw->delete();
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('currencies')
			);
		}
		else // show confirmation dialog
		{
			$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
			$currency = $this->_getCurrencyOrError($currencyId);
			
			$writer = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Currency', XenForo_DataWriter::ERROR_EXCEPTION);
			$writer->setExistingData($currency);
			$writer->preDelete();
			$viewParams = array(
				'currency' => $currency
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Currency_Delete', 'BRC_currency_delete', $viewParams);
		}
		
	}
	
	/**
	 * Gets the specified currency or throws an error.
	 *
	 * @param integer $currencyId
	 * @param boolean $allowMaster Allow the master currency (0) to be fetched
	 *
	 * @return array
	 */
	protected function _getCurrencyOrError($currencyId)
	{
		$currency = $this->_getCurrencyModel()->getCurrencyById($currencyId);
		if (!$currency)
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'), 404));
		}

		return $currency;
	}
	/**
	 * Gets the currency model.
	 *
	 * @return Brivium_Credits_Model_Currency
	 */
	protected function _getCurrencyModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Currency');
	}
	
}