<?php

class Brivium_Credits_Listener_Listener
{
	public static function visitorSetup(XenForo_Visitor &$visitor) {
		$currencies = (XenForo_Application::isRegistered('brcCurrencies')
			? XenForo_Application::get('brcCurrencies')
			: XenForo_Model::create('XenForo_Model_DataRegistry')->get('brcCurrencies')
		);
		if($visitor['user_id']){
			$currencyId = $visitor['currency_id'];
		}else{
			$visitor['currency_id'] = 1;
			$currencyId = 1;
		}
		if ($currencyId && !empty($currencies[$currencyId]))
		{
			$currency = $currencies[$currencyId];
		}
		else
		{
			$currencyId = XenForo_Application::get('options')->BRC_defaultCurrencyId;
			if (!empty($currencies[$currencyId]))
			{
				$currency = $currencies[$currencyId];
			}
			else
			{
				$currency = reset($currencies);
				$currencyId = $currency['currency_id'];
			}
		}
		Brivium_Credits_Currency::setDefaultCurrency($currency);
		Brivium_Credits_Currency::setDefaultCurrencyId($currencyId);
	}
	public static function init_dependencies(XenForo_Dependencies_Abstract $dependencies, array $data) {
		$data = XenForo_Model::create('XenForo_Model_DataRegistry')->getMulti(array('brcCurrencies','brcActions'));
		$currencies = (!empty($data['brcCurrencies']) && is_array($data['brcCurrencies']) ? $data['brcCurrencies'] : XenForo_Model::create('Brivium_Credits_Model_Currency')->rebuildCurrencyCache());
		$actions = (!empty($data['brcActions']) && is_array($data['brcActions']) ? $data['brcActions'] : XenForo_Model::create('Brivium_Credits_Model_Action')->rebuildActionCache());
		
		XenForo_Application::set('brcCurrencies',$currencies);
		Brivium_Credits_Currency::setCurrencies($currencies);
		
		$actionsObj = new Brivium_Credits_Actions($actions);
		XenForo_Application::set('brcActions',$actionsObj);
		
		XenForo_Template_Helper_Core::$helperCallbacks['brc_currencyformat'] = array('Brivium_Credits_Listener_Helpers', 'helperCurrencyFormat');
	}
	public static function loadClassController($class, &$extend)
	{
		$classes = array(
			'ControllerAdmin_User',
			'ControllerPublic_Account',
			'ControllerPublic_Login',
			'ControllerPublic_Register',
		);
		foreach($classes AS $clas){if ($class == 'XenForo_' .$clas){$extend[] = 'Brivium_Credits_' .$clas;}}
	}
	public static function loadClassDatawriter($class, &$extend)
	{
		$classes = array(
			'ConversationMessage',
			'Discussion_Thread',
			'DiscussionMessage_Post',
			'DiscussionMessage_ProfilePost',
			'Follower',
			'Poll',
			'Report',
			'User',
		);
		foreach($classes AS $clas){if ($class == 'XenForo_DataWriter_' .$clas){$extend[] = 'Brivium_Credits_DataWriter_' .$clas;}}
	}
	public static function loadClassModel($class, &$extend)
	{
		$classes = array(
			'AddOn',
			'Attachment',
			'Like',
			'Thread',
			'User',
		);
		foreach($classes AS $clas){if ($class == 'XenForo_Model_' .$clas){$extend[] = 'Brivium_Credits_Model_' .$clas;}}
	}
	public static function loadClassImporter($class, array &$extend) {
		switch($class){
			case 'XenForo_Importer_vBulletin': 
				$extend[] = 'Brivium_Credits_Importer_vBulletin';
				break;
		}
	}
	
	protected static  $canTransfer = null;
	
	public static function templateHook ($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
		$param = array();
		
		$options = XenForo_Application::get('options');
		switch($hookName){
			case 'admin_user_edit_tabs': // Admin
			case 'admin_user_edit_panes': // Admin
			case 'account_alerts_extra':
				$newTemplate = $template->create('BRC_' . $hookName, $template->getParams());
				$contents .= $newTemplate->render();
				break;
			case 'account_preferences_locale':
				if($options->BRC_userCanChangeCurrency){
					$newTemplate = $template->create('BRC_' . $hookName, $template->getParams());
					$contents .= $newTemplate->render();
				}
				break;
			case 'footer':
				$template = XenForo_Model::create('Brivium_Credits_Model_Credit')->footer();
				$contents = $template .$contents;
				break;
			case 'message_user_info_extra':
			case 'sidebar_visitor_panel_stats':
			case 'member_view_info_block':
			case 'member_card_stats':
			case 'navigation_visitor_tabs_end':
				if($options->get('BRC_displayOption', $hookName)){
					$param['canTransfer'] = is_null(self::$canTransfer)?XenForo_Model::create('Brivium_Credits_Model_Credit')->requireInclude('transfer'):self::$canTransfer;
					self::$canTransfer = $param['canTransfer'];
					$newTemplate = $template->create('BRC_' . $hookName,$template->getParams());
					$newTemplate->setParams($hookParams);
					$newTemplate->setParams($param);
					$contents .= $newTemplate->render();
				}
				break;
		}
    }
}