<?php

/**
 * Cron entry for Birthday.
 */
class Brivium_Credits_CronEntry_Birthday
{
	public static function runBirthdayUpdate()
	{
		$creditModel = XenForo_Model::create('Brivium_Credits_Model_Credit');
		$action = XenForo_Model::create('Brivium_Credits_Model_Action')->getActionById('birthday');
		
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0,
			'dob_month' => date("m"),
			'dob_day' => date("j"),
		);
		$users = $userModel->getUsers($criteria, array(
			'join' => XenForo_Model_User::FETCH_USER_FULL
		));
		foreach ($users AS $user)
		{
			$birthday = XenForo_Model::create('XenForo_Model_UserProfile')->getUserBirthdayDetails($user,true);
			$amount = $action['amount'] + $birthday['age']*$action['multiplier'];
			$tran = $creditModel->updateUserCredit('birthday',$user['user_id'],array('amount' => $amount));
		}
	}
}