<?php

/**
 * Route prefix handler for XenGallery categories in the admin control panel.
 */
class XenGallery_Route_Prefix_Media implements XenForo_Route_Interface
{
	protected $_subComponents = array(
			'categories' => array(
				'intId' => 'xengallery_category_id',
				'title' => 'category_title',
				'actionPrefix' => 'category'
			),
			'users' => array(
				'intId' => 'user_id',
				'title' => 'username',
				'actionPrefix' => 'user'
			),			
			'files' => array(
				'intId' => 'media_id',
				'title' => 'media_title',
				'actionPrefix' => 'file'				
			),
			'comments' => array(
				'intId' => 'comment_id',
				'actionPrefix' => 'comment'
			)
		);
		
	/**
	 * Match a specific route for an already matched prefix.
	 *
	 * @see XenForo_Route_Interface::match()
	 */
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
		$controller = 'XenGallery_ControllerPublic_Media';
		$action = $router->getSubComponentAction($this->_subComponents, $routePath, $request, $controller);
		
		if ($action === false)
		{
			$action = $router->resolveActionWithIntegerParam($routePath, $request, 'media_id');
			//$action = $router->resolveActionAsPageNumber($action, $request);
		}

		return $router->getRouteMatch($controller, $action, 'xengallery');
	}

	/**
	 * Method to build a link to the specified page/action with the provided
	 * data and params.
	 *
	 * @see XenForo_Route_BuilderInterface
	 */
	public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
	{
		$outputPrefix = XenForo_Application::get('options')->xengalleryRoutePrefix;
		
		$link = XenForo_Link::buildSubComponentLink($this->_subComponents, $outputPrefix, $action, $extension, $data);
		
		if (!$link)
		{
			//$action = XenForo_Link::getPageNumberAsAction($action, $extraParams);
			$link = XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix, $action, $extension, $data, 'media_id', 'media_title');
		}
		
		return $link;
	}
}